/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.lang.NotImplementedException;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.compress.colgroup.AColGroup;
import org.apache.sysds.runtime.compress.colgroup.AMorphingMMColGroup;
import org.apache.sysds.runtime.compress.colgroup.ColGroupEmpty;
import org.apache.sysds.runtime.compress.colgroup.ColGroupSDCSingleZeros;
import org.apache.sysds.runtime.compress.colgroup.FORUtil;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.dictionary.Dictionary;
import org.apache.sysds.runtime.compress.colgroup.offset.AIterator;
import org.apache.sysds.runtime.compress.colgroup.offset.AOffset;
import org.apache.sysds.runtime.compress.colgroup.offset.OffsetFactory;
import org.apache.sysds.runtime.compress.cost.ComputationCostEstimator;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.functionobjects.Builtin;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.matrix.operators.BinaryOperator;
import org.apache.sysds.runtime.matrix.operators.CMOperator;
import org.apache.sysds.runtime.matrix.operators.ScalarOperator;
import org.apache.sysds.runtime.matrix.operators.UnaryOperator;

public class ColGroupSDCSingle
extends AMorphingMMColGroup {
    private static final long serialVersionUID = 3883228464052204200L;
    protected AOffset _indexes;
    protected double[] _defaultTuple;

    protected ColGroupSDCSingle(int numRows) {
        super(numRows);
    }

    private ColGroupSDCSingle(int[] colIndices, int numRows, ADictionary dict, double[] defaultTuple, AOffset offsets, int[] cachedCounts) {
        super(colIndices, numRows, dict, cachedCounts);
        this._indexes = offsets;
        this._zeros = false;
        this._defaultTuple = defaultTuple;
        if (this._indexes == null) {
            throw new NullPointerException("null indexes is invalid for SDCSingle");
        }
    }

    protected static AColGroup create(int[] colIndexes, int numRows, ADictionary dict, double[] defaultTuple, AOffset offsets, int[] cachedCounts) {
        boolean allZero = FORUtil.allZero(defaultTuple);
        if (dict == null && allZero) {
            return new ColGroupEmpty(colIndexes);
        }
        if (dict == null) {
            Dictionary ADict = new Dictionary(new double[colIndexes.length]);
            return new ColGroupSDCSingle(colIndexes, numRows, ADict, defaultTuple, offsets, cachedCounts);
        }
        if (allZero) {
            return ColGroupSDCSingleZeros.create(colIndexes, numRows, dict, offsets, cachedCounts);
        }
        return new ColGroupSDCSingle(colIndexes, numRows, dict, defaultTuple, offsets, cachedCounts);
    }

    @Override
    public AColGroup.CompressionType getCompType() {
        return AColGroup.CompressionType.SDC;
    }

    @Override
    public AColGroup.ColGroupType getColGroupType() {
        return AColGroup.ColGroupType.SDCSingle;
    }

    @Override
    public double getIdx(int r, int colIdx) {
        AIterator it = this._indexes.getIterator(r);
        if (it == null || it.value() != r) {
            return this._defaultTuple[colIdx];
        }
        return this._dict.getValue(colIdx);
    }

    @Override
    public ADictionary getDictionary() {
        throw new NotImplementedException("Not implemented getting the dictionary out, and i think we should consider removing the option");
    }

    @Override
    protected double[] preAggSumRows() {
        return this._dict.sumAllRowsToDoubleWithDefault(this._defaultTuple);
    }

    @Override
    protected double[] preAggSumSqRows() {
        return this._dict.sumAllRowsToDoubleSqWithDefault(this._defaultTuple);
    }

    @Override
    protected double[] preAggProductRows() {
        throw new NotImplementedException("Should implement preAgg with extra cell");
    }

    @Override
    protected double[] preAggBuiltinRows(Builtin builtin) {
        return this._dict.aggregateRowsWithDefault(builtin, this._defaultTuple);
    }

    @Override
    protected double computeMxx(double c, Builtin builtin) {
        double ret = this._dict.aggregate(c, builtin);
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            ret = builtin.execute(ret, this._defaultTuple[i]);
        }
        return ret;
    }

    @Override
    protected void computeColMxx(double[] c, Builtin builtin) {
        this._dict.aggregateCols(c, builtin, this._colIndexes);
        for (int x = 0; x < this._colIndexes.length; ++x) {
            c[this._colIndexes[x]] = builtin.execute(c[this._colIndexes[x]], this._defaultTuple[x]);
        }
    }

    @Override
    protected void computeRowSums(double[] c, int rl, int ru, double[] preAgg) {
        ColGroupSDCSingle.computeRowSums(c, rl, ru, preAgg, this._indexes, this._numRows);
    }

    protected static final void computeRowSums(double[] c, int rl, int ru, double[] preAgg, AOffset indexes, int nRows) {
        int r;
        double def;
        block10: {
            AIterator it = indexes.getIterator(rl);
            def = preAgg[1];
            double norm = preAgg[0];
            if (it != null && it.value() > ru) {
                indexes.cacheIterator(it, ru);
            } else {
                if (it != null && ru >= indexes.getOffsetToLast()) {
                    int maxOff = indexes.getOffsetToLast();
                    while (true) {
                        if (it.value() == r) {
                            int n = r++;
                            c[n] = c[n] + norm;
                            if (it.value() >= maxOff) break block10;
                            it.next();
                        } else {
                            int n = r;
                            c[n] = c[n] + def;
                        }
                        ++r;
                    }
                }
                if (it != null) {
                    for (r = rl; r < ru; ++r) {
                        if (it.value() == r) {
                            int n = r;
                            c[n] = c[n] + norm;
                            continue;
                        }
                        int n = r;
                        c[n] = c[n] + def;
                    }
                    indexes.cacheIterator(it, ru);
                }
            }
        }
        while (r < ru) {
            int n = r++;
            c[n] = c[n] + def;
        }
    }

    @Override
    protected void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, double[] preAgg) {
        ColGroupSDCSingle.computeRowMxx(c, builtin, rl, ru, this._indexes, this._numRows, preAgg[1], preAgg[0]);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected static final void computeRowMxx(double[] c, Builtin builtin, int rl, int ru, AOffset indexes, int nRows, double def, double norm) {
        int r;
        block7: {
            AIterator it;
            block10: {
                block9: {
                    block8: {
                        it = indexes.getIterator(rl);
                        if (it == null || it.value() <= ru) break block8;
                        indexes.cacheIterator(it, ru);
                        break block7;
                    }
                    if (it != null && ru >= indexes.getOffsetToLast()) break block9;
                    if (it == null) break block7;
                    break block10;
                }
                int maxOff = indexes.getOffsetToLast();
                while (true) {
                    block12: {
                        block11: {
                            if (it.value() != r) break block11;
                            c[r] = builtin.execute(c[r], norm);
                            if (it.value() < maxOff) {
                                it.next();
                                break block12;
                            } else {
                                ++r;
                                break block7;
                            }
                        }
                        c[r] = builtin.execute(c[r], def);
                    }
                    ++r;
                }
            }
            for (r = rl; r < ru; ++r) {
                if (it.value() == r) {
                    c[r] = builtin.execute(c[r], norm);
                    it.next();
                    continue;
                }
                c[r] = builtin.execute(c[r], def);
            }
            indexes.cacheIterator(it, ru);
        }
        while (r < ru) {
            c[r] = builtin.execute(c[r], def);
            ++r;
        }
        return;
    }

    @Override
    protected void computeSum(double[] c, int nRows) {
        super.computeSum(c, nRows);
        int count = this._numRows - this.getCounts()[0];
        for (int x = 0; x < this._defaultTuple.length; ++x) {
            c[0] = c[0] + this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    public void computeColSums(double[] c, int nRows) {
        super.computeColSums(c, nRows);
        int count = this._numRows - this.getCounts()[0];
        for (int x = 0; x < this._colIndexes.length; ++x) {
            int n = this._colIndexes[x];
            c[n] = c[n] + this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    protected void computeSumSq(double[] c, int nRows) {
        super.computeSumSq(c, nRows);
        int count = this._numRows - this.getCounts()[0];
        for (int x = 0; x < this._colIndexes.length; ++x) {
            c[0] = c[0] + this._defaultTuple[x] * this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    protected void computeColSumsSq(double[] c, int nRows) {
        super.computeColSumsSq(c, nRows);
        int count = this._numRows - this.getCounts()[0];
        for (int x = 0; x < this._colIndexes.length; ++x) {
            int n = this._colIndexes[x];
            c[n] = c[n] + this._defaultTuple[x] * this._defaultTuple[x] * (double)count;
        }
    }

    @Override
    protected void computeProduct(double[] c, int nRows) {
        int count = this._numRows - this.getCounts()[0];
        this._dict.productWithDefault(c, this.getCounts(), this._defaultTuple, count);
    }

    @Override
    protected void computeColProduct(double[] c, int nRows) {
        super.computeColProduct(c, nRows);
        int count = this._numRows - this.getCounts()[0];
        for (int x = 0; x < this._colIndexes.length; ++x) {
            int n = this._colIndexes[x];
            c[n] = c[n] * Math.pow(this._defaultTuple[x], count);
        }
    }

    @Override
    protected void computeRowProduct(double[] c, int rl, int ru, double[] preAgg) {
        throw new NotImplementedException();
    }

    @Override
    public int[] getCounts(int[] counts) {
        counts[0] = this._indexes.getSize();
        return counts;
    }

    @Override
    public long estimateInMemorySize() {
        long size = super.estimateInMemorySize();
        size += this._indexes.getInMemorySize();
        return size += (long)(8 * this._colIndexes.length);
    }

    @Override
    public AColGroup scalarOperation(ScalarOperator op) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.executeScalar(this._defaultTuple[i]);
        }
        ADictionary nDict = this._dict.applyScalarOp(op);
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, nDict, newDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup unaryOperation(UnaryOperator op) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.fn.execute(this._defaultTuple[i]);
        }
        ADictionary nDict = this._dict.applyUnaryOp(op);
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, nDict, newDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpLeft(BinaryOperator op, double[] v, boolean isRowSafe) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.fn.execute(v[this._colIndexes[i]], this._defaultTuple[i]);
        }
        ADictionary newDict = this._dict.binOpLeft(op, v, this._colIndexes);
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, newDict, newDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup binaryRowOpRight(BinaryOperator op, double[] v, boolean isRowSafe) {
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = op.fn.execute(this._defaultTuple[i], v[this._colIndexes[i]]);
        }
        ADictionary newDict = this._dict.binOpRight(op, v, this._colIndexes);
        return new ColGroupSDCSingle(this._colIndexes, this._numRows, newDict, newDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        this._indexes.write(out);
        for (double d : this._defaultTuple) {
            out.writeDouble(d);
        }
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        this._indexes = OffsetFactory.readIn(in);
        this._defaultTuple = new double[this._colIndexes.length];
        for (int i = 0; i < this._colIndexes.length; ++i) {
            this._defaultTuple[i] = in.readDouble();
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        long ret = super.getExactSizeOnDisk();
        ret += this._indexes.getExactSizeOnDisk();
        return ret += (long)(8 * this._colIndexes.length);
    }

    @Override
    public AColGroup replace(double pattern, double replace) {
        ADictionary replaced = this._dict.replace(pattern, replace, this._colIndexes.length);
        double[] newDefaultTuple = new double[this._defaultTuple.length];
        for (int i = 0; i < this._defaultTuple.length; ++i) {
            newDefaultTuple[i] = this._defaultTuple[i] == pattern ? replace : this._defaultTuple[i];
        }
        return ColGroupSDCSingle.create(this._colIndexes, this._numRows, replaced, newDefaultTuple, this._indexes, this.getCachedCounts());
    }

    @Override
    public AColGroup extractCommon(double[] constV) {
        for (int i = 0; i < this._colIndexes.length; ++i) {
            int n = this._colIndexes[i];
            constV[n] = constV[n] + this._defaultTuple[i];
        }
        ADictionary subtractedDict = this._dict.subtractTuple(this._defaultTuple);
        return ColGroupSDCSingleZeros.create(this._colIndexes, this._numRows, subtractedDict, this._indexes, this.getCachedCounts());
    }

    @Override
    public long getNumberNonZeros(int nRows) {
        long nnz = super.getNumberNonZeros(nRows);
        int count = this._numRows - this.getCounts()[0];
        for (int x = 0; x < this._colIndexes.length; ++x) {
            nnz += this._defaultTuple[x] != 0.0 ? (long)count : 0L;
        }
        return nnz;
    }

    @Override
    public CM_COV_Object centralMoment(CMOperator op, int nRows) {
        CM_COV_Object ret = super.centralMoment(op, nRows);
        int count = this._numRows - this.getCounts()[0];
        op.fn.execute(ret, this._defaultTuple[0], count);
        return ret;
    }

    @Override
    public AColGroup rexpandCols(int max, boolean ignore, boolean cast, int nRows) {
        ADictionary d = this._dict.rexpandCols(max, ignore, cast, this._colIndexes.length);
        double def = this._defaultTuple[0];
        if (d == null) {
            if (def <= 0.0 || def > (double)max) {
                return ColGroupEmpty.create(max);
            }
            double[] retDef = new double[max];
            retDef[(int)this._defaultTuple[0] - 1] = 1.0;
            return new ColGroupSDCSingle(Util.genColsIndices(max), nRows, new Dictionary(new double[max]), retDef, this._indexes, null);
        }
        if (def <= 0.0) {
            if (ignore) {
                return ColGroupSDCSingleZeros.create(Util.genColsIndices(max), nRows, d, this._indexes, this.getCachedCounts());
            }
            throw new DMLRuntimeException("Invalid content of zero in rexpand");
        }
        if (def > (double)max) {
            return ColGroupSDCSingleZeros.create(Util.genColsIndices(max), nRows, d, this._indexes, this.getCachedCounts());
        }
        double[] retDef = new double[max];
        retDef[(int)this._defaultTuple[0] - 1] = 1.0;
        return new ColGroupSDCSingle(Util.genColsIndices(max), nRows, d, retDef, this._indexes, this.getCachedCounts());
    }

    @Override
    public double getCost(ComputationCostEstimator e, int nRows) {
        int nVals = this.getNumValues();
        int nCols = this.getNumCols();
        int nRowsScanned = this.getCounts()[0];
        return e.getCost(nRows, nRowsScanned, nCols, nVals, this._dict.getSparsity());
    }

    @Override
    protected AColGroup sliceMultiColumns(int idStart, int idEnd, int[] outputCols) {
        ColGroupSDCSingle ret = (ColGroupSDCSingle)super.sliceMultiColumns(idStart, idEnd, outputCols);
        ret._defaultTuple = new double[idEnd - idStart];
        int i = idStart;
        int j = 0;
        while (i < idEnd) {
            ret._defaultTuple[j] = this._defaultTuple[i];
            ++i;
            ++j;
        }
        return ret;
    }

    @Override
    protected AColGroup sliceSingleColumn(int idx) {
        ColGroupSDCSingle ret = (ColGroupSDCSingle)super.sliceSingleColumn(idx);
        ret._defaultTuple = new double[1];
        ret._defaultTuple[0] = this._defaultTuple[idx];
        return ret;
    }

    @Override
    public boolean containsValue(double pattern) {
        if (pattern == 0.0 && this._zeros) {
            return true;
        }
        boolean ret = this._dict.containsValue(pattern);
        if (ret) {
            return ret;
        }
        for (double v : this._defaultTuple) {
            if (v != pattern) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append(String.format("\n%15s", "Default: "));
        sb.append(Arrays.toString(this._defaultTuple));
        sb.append(String.format("\n%15s", "Indexes: "));
        sb.append(this._indexes.toString());
        return sb.toString();
    }
}

