/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.mapping;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.BitSet;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.compress.colgroup.mapping.AMapToData;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToFactory;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToInt;
import org.apache.sysds.runtime.compress.colgroup.mapping.MapToZero;
import org.apache.sysds.utils.MemoryEstimates;

public class MapToBit
extends AMapToData {
    private static final long serialVersionUID = -8065234231282619923L;
    private final BitSet _data;
    private final int _size;

    protected MapToBit(int size) {
        this(2, size);
    }

    public MapToBit(int unique, int size) {
        super(Math.min(unique, 2));
        this._data = new BitSet(size);
        this._size = size;
    }

    private MapToBit(int unique, BitSet d, int size) {
        super(unique);
        this._data = d;
        this._size = size;
        if (this._data.isEmpty()) {
            unique = 1;
            LOG.warn((Object)"Empty bit set should not happen");
        }
    }

    protected BitSet getData() {
        return this._data;
    }

    @Override
    public MapToFactory.MAP_TYPE getType() {
        return MapToFactory.MAP_TYPE.BIT;
    }

    @Override
    public int getIndex(int n) {
        return this._data.get(n) ? 1 : 0;
    }

    @Override
    public void fill(int v) {
        this._data.set(0, this._size, true);
    }

    @Override
    public long getInMemorySize() {
        return MapToBit.getInMemorySize(this._data.size());
    }

    public static long getInMemorySize(int dataLength) {
        long size = 28L;
        return size += MemoryEstimates.bitSetCost(dataLength);
    }

    @Override
    public void set(int n, int v) {
        this._data.set(n, v == 1);
    }

    @Override
    public int setAndGet(int n, int v) {
        this._data.set(n, v == 1);
        return 1;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public void replace(int v, int r) {
        if (v == 0) {
            this._data.set(0, this.size(), true);
        } else {
            this._data.clear();
        }
    }

    @Override
    public long getExactSizeOnDisk() {
        long size = 9L;
        return size += (long)(this._data.toLongArray().length * 8);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        long[] internals = this._data.toLongArray();
        out.writeByte(MapToFactory.MAP_TYPE.BIT.ordinal());
        out.writeInt(this._size);
        out.writeInt(internals.length);
        for (int i = 0; i < internals.length; ++i) {
            out.writeLong(internals[i]);
        }
    }

    protected static MapToBit readFields(DataInput in) throws IOException {
        int size = in.readInt();
        long[] internalLong = new long[in.readInt()];
        for (int i = 0; i < internalLong.length; ++i) {
            internalLong[i] = in.readLong();
        }
        return new MapToBit(2, BitSet.valueOf(internalLong), size);
    }

    @Override
    public int getUpperBoundValue() {
        return 1;
    }

    @Override
    protected void count(int[] ret) {
        int sz = this.size();
        ret[1] = this._data.cardinality();
        ret[0] = sz - ret[1];
    }

    @Override
    public void preAggregateDDC_DDCSingleCol(AMapToData tm, double[] td, double[] v) {
        if (tm instanceof MapToBit) {
            this.preAggregateDDCSingleColBitBit((MapToBit)tm, td, v);
        } else {
            super.preAggregateDDC_DDCSingleCol(tm, td, v);
        }
    }

    private void preAggregateDDCSingleColBitBit(MapToBit tmb, double[] td, double[] v) {
        JoinBitSets j = new JoinBitSets(tmb._data, this._data, this._size);
        v[1] = v[1] + td[1] * (double)j.tt;
        v[0] = v[0] + td[1] * (double)j.ft;
        v[1] = v[1] + td[0] * (double)j.tf;
        v[0] = v[0] + td[0] * (double)j.ff;
    }

    @Override
    public void preAggregateDDC_DDCMultiCol(AMapToData tm, ADictionary td, double[] v, int nCol) {
        if (tm instanceof MapToBit) {
            this.preAggregateDDCMultiColBitBit((MapToBit)tm, td, v, nCol);
        } else {
            super.preAggregateDDC_DDCMultiCol(tm, td, v, nCol);
        }
    }

    private void preAggregateDDCMultiColBitBit(MapToBit tmb, ADictionary td, double[] v, int nCol) {
        JoinBitSets j = new JoinBitSets(tmb._data, this._data, this._size);
        double[] tv = td.getValues();
        int i = 0;
        while (i < nCol) {
            int off = nCol + i;
            int n = i;
            v[n] = v[n] + tv[i] * (double)j.ff;
            int n2 = off;
            v[n2] = v[n2] + tv[i] * (double)j.tf;
            int n3 = off;
            v[n3] = v[n3] + tv[off] * (double)j.tt;
            int n4 = i++;
            v[n4] = v[n4] + tv[off] * (double)j.ft;
        }
    }

    public boolean isEmpty() {
        return this._data.isEmpty();
    }

    @Override
    public void copy(AMapToData d) {
        if (d instanceof MapToBit) {
            this.copyBit((MapToBit)d);
        } else if (d instanceof MapToInt) {
            this.copyInt((MapToInt)d);
        } else {
            int sz = this.size();
            for (int i = 0; i < sz; ++i) {
                if (d.getIndex(i) == 0) continue;
                this._data.set(i);
            }
        }
    }

    @Override
    public void copyInt(int[] d) {
        for (int i = d.length - 1; i > -1; --i) {
            if (d[i] == 0) continue;
            this._data.set(i);
        }
    }

    @Override
    public void copyBit(BitSet d) {
        this._data.clear();
        this._data.or(d);
    }

    @Override
    public AMapToData resize(int unique) {
        if (unique <= 1) {
            return new MapToZero(this.size());
        }
        return this;
    }

    private static class JoinBitSets {
        int tt = 0;
        int ft = 0;
        int tf = 0;
        int ff = 0;

        protected JoinBitSets(BitSet t_data, BitSet o_data, int size) {
            int i;
            long[] t_longs = t_data.toLongArray();
            long[] _longs = o_data.toLongArray();
            int common = Math.min(t_longs.length, _longs.length);
            for (i = 0; i < common; ++i) {
                long t = t_longs[i];
                long v = _longs[i];
                this.tt += Long.bitCount(t & v);
                this.ft += Long.bitCount(t & (v ^ 0xFFFFFFFFFFFFFFFFL));
                this.tf += Long.bitCount((t ^ 0xFFFFFFFFFFFFFFFFL) & v);
                this.ff += Long.bitCount((t ^ 0xFFFFFFFFFFFFFFFFL) & (v ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if (t_longs.length > common) {
                for (i = common; i < t_longs.length; ++i) {
                    int v = Long.bitCount(t_longs[i]);
                    this.ft += v;
                    this.ff += 64 - v;
                }
            } else if (_longs.length > common) {
                for (i = common; i < _longs.length; ++i) {
                    int v = Long.bitCount(_longs[i]);
                    this.tf += v;
                    this.ff += 64 - v;
                }
            }
            int longest = Math.max(t_longs.length, _longs.length);
            this.ff += size - longest * 64;
        }
    }
}

