/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressedMatrixBlock;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;

public class CompressedSizeInfo {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeInfo.class.getName());
    public List<CompressedSizeInfoColGroup> compressionInfo;

    public CompressedSizeInfo(CompressedSizeInfoColGroup g) {
        this.compressionInfo = new ArrayList<CompressedSizeInfoColGroup>();
        this.compressionInfo.add(g);
    }

    public CompressedSizeInfo(List<CompressedSizeInfoColGroup> compressionInfo) {
        this.compressionInfo = compressionInfo;
    }

    public CompressedSizeInfoColGroup getGroupInfo(int index) {
        return this.compressionInfo.get(index);
    }

    public List<CompressedSizeInfoColGroup> getInfo() {
        return this.compressionInfo;
    }

    public CompressedSizeInfo setInfo(List<CompressedSizeInfoColGroup> info) {
        this.compressionInfo = info;
        return this;
    }

    public void clearMaps() {
        for (CompressedSizeInfoColGroup g : this.compressionInfo) {
            g.clearMap();
        }
    }

    public long memoryEstimate() {
        long est = CompressedMatrixBlock.baseSizeInMemory();
        for (CompressedSizeInfoColGroup csi : this.compressionInfo) {
            est += csi.getMinSize();
        }
        return est;
    }

    public int getNumberColGroups() {
        return this.compressionInfo.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompressedSizeInfo");
        for (CompressedSizeInfoColGroup g : this.compressionInfo) {
            sb.append("\n" + g.toString());
        }
        return sb.toString();
    }

    public String getEstimatedDistinct() {
        StringBuilder sb = new StringBuilder();
        if (this.compressionInfo == null) {
            return "";
        }
        sb.append("[");
        sb.append(this.compressionInfo.get(0).getNumVals());
        for (int i = 1; i < this.compressionInfo.size(); ++i) {
            sb.append(", " + this.compressionInfo.get(i).getNumVals());
        }
        sb.append("]");
        return sb.toString();
    }

    public String getNrColumnsString() {
        StringBuilder sb = new StringBuilder();
        if (this.compressionInfo == null) {
            return "";
        }
        sb.append("[");
        sb.append(this.compressionInfo.get(0).getColumns().length);
        for (int i = 1; i < this.compressionInfo.size(); ++i) {
            sb.append(", " + this.compressionInfo.get(i).getColumns().length);
        }
        sb.append("]");
        return sb.toString();
    }
}

