/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.fed;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.Future;
import java.util.stream.IntStream;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRange;
import org.apache.sysds.runtime.controlprogram.federated.FederatedRequest;
import org.apache.sysds.runtime.controlprogram.federated.FederatedResponse;
import org.apache.sysds.runtime.controlprogram.federated.FederatedUDF;
import org.apache.sysds.runtime.controlprogram.federated.FederationMap;
import org.apache.sysds.runtime.controlprogram.federated.FederationUtils;
import org.apache.sysds.runtime.controlprogram.federated.MatrixLineagePair;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.CovarianceCPInstruction;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.cp.ScalarObject;
import org.apache.sysds.runtime.instructions.fed.BinaryFEDInstruction;
import org.apache.sysds.runtime.instructions.fed.FEDInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.operators.COVOperator;
import org.apache.sysds.runtime.matrix.operators.Operator;

public class CovarianceFEDInstruction
extends BinaryFEDInstruction {
    private CovarianceFEDInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(FEDInstruction.FEDType.AggregateBinary, op, in1, in2, in3, out, opcode, istr);
    }

    public static CovarianceFEDInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        FEDInstruction.FederatedOutput fedOut = FEDInstruction.FederatedOutput.valueOf(parts[parts.length - 1]);
        String cleanInstStr = InstructionUtils.removeFEDOutputFlag(str);
        CovarianceFEDInstruction fedInst = CovarianceFEDInstruction.parseInstruction(CovarianceCPInstruction.parseInstruction(cleanInstStr));
        fedInst._fedOut = fedOut;
        return fedInst;
    }

    public static CovarianceFEDInstruction parseInstruction(Instruction inst) {
        if (inst instanceof CovarianceCPInstruction) {
            return CovarianceFEDInstruction.parseInstruction((CovarianceCPInstruction)inst);
        }
        if (inst instanceof SPInstruction) {
            return CovarianceFEDInstruction.parseInstruction(CovarianceCPInstruction.parseInstruction(inst.getInstructionString()));
        }
        return CovarianceFEDInstruction.parseInstruction(inst.getInstructionString());
    }

    public static CovarianceFEDInstruction parseInstruction(CovarianceCPInstruction inst) {
        return new CovarianceFEDInstruction(inst.getOperator(), inst.input1, inst.input2, inst.input3, inst.output, inst.getOpcode(), inst.getInstructionString());
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        boolean weightsAligned;
        MatrixLineagePair weights;
        MatrixObject mo1 = ec.getMatrixObject(this.input1);
        MatrixObject mo2 = ec.getMatrixObject(this.input2);
        MatrixLineagePair matrixLineagePair = weights = this.input3 != null ? ec.getMatrixLineagePair(this.input3) : null;
        if (mo1.isFederated() && mo2.isFederated() && !mo1.getFedMapping().isAligned(mo2.getFedMapping(), false)) {
            throw new DMLRuntimeException("Not supported matrix-matrix binary operation: covariance.");
        }
        boolean moAligned = mo1.isFederated() && mo2.isFederated() && mo1.getFedMapping().isAligned(mo2.getFedMapping(), false);
        boolean bl = weightsAligned = weights == null || weights.isFederated() && mo2.isFederated() && weights.getFedMapping().isAligned(mo2.getFedMapping(), false);
        if (moAligned && weightsAligned) {
            this.processAlignedFedCov(ec, mo1, mo2, weights);
        } else if (moAligned) {
            this.processFedCovWeights(ec, mo1, mo2, weights);
        } else {
            this.processCov(ec, mo1, mo2);
        }
    }

    private void processAlignedFedCov(ExecutionContext ec, MatrixObject mo1, MatrixObject mo2, MatrixLineagePair moLin3) {
        FederatedRequest fr1 = moLin3 == null ? FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), mo2.getFedMapping().getID()}) : FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2, this.input3}, new long[]{mo1.getFedMapping().getID(), mo2.getFedMapping().getID(), moLin3.getFedMapping().getID()});
        FederatedRequest fr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
        FederatedRequest fr3 = mo1.getFedMapping().cleanup(this.getTID(), fr1.getID());
        Future<FederatedResponse>[] covTmp = mo1.getFedMapping().execute(this.getTID(), fr1, fr2, fr3);
        Future<FederatedResponse>[] meanTmp1 = this.processMean(mo1, 0);
        Future<FederatedResponse>[] meanTmp2 = this.processMean(mo2, 1);
        ImmutableTriple<Double[], Double[], Double[]> res = CovarianceFEDInstruction.getResponses(covTmp, meanTmp1, meanTmp2);
        double result = CovarianceFEDInstruction.aggCov((Double[])res.left, (Double[])res.middle, (Double[])res.right, mo1.getFedMapping().getFederatedRanges());
        ec.setVariable(this.output.getName(), new DoubleObject(result));
    }

    private void processFedCovWeights(ExecutionContext ec, MatrixObject mo1, MatrixObject mo2, MatrixLineagePair moLin3) {
        FederatedRequest[] fr2 = mo1.getFedMapping().broadcastSliced(moLin3, false);
        FederatedRequest fr1 = FederationUtils.callInstruction(this.instString, this.output, new CPOperand[]{this.input1, this.input2}, new long[]{mo1.getFedMapping().getID(), mo2.getFedMapping().getID()});
        FederatedRequest fr3 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, fr1.getID());
        FederatedRequest fr4 = mo1.getFedMapping().cleanup(this.getTID(), fr1.getID());
        Future<FederatedResponse>[] covTmp = mo1.getFedMapping().execute(this.getTID(), fr1, fr2[0], fr3, fr4);
        Future<FederatedResponse>[] meanTmp1 = this.processMean(mo1, 0);
        Future<FederatedResponse>[] meanTmp2 = this.processMean(mo2, 1);
        ImmutableTriple<Double[], Double[], Double[]> res = CovarianceFEDInstruction.getResponses(covTmp, meanTmp1, meanTmp2);
        double result = CovarianceFEDInstruction.aggCov((Double[])res.left, (Double[])res.middle, (Double[])res.right, mo1.getFedMapping().getFederatedRanges());
        ec.setVariable(this.output.getName(), new DoubleObject(result));
    }

    private void processCov(ExecutionContext ec, MatrixObject mo1, MatrixObject mo2) {
        MatrixBlock mb;
        MatrixObject mo;
        COVOperator cop = (COVOperator)this._optr;
        if (!mo1.isFederated() && mo2.isFederated()) {
            mo = mo2;
            mb = ec.getMatrixInput(this.input1.getName());
        } else {
            mo = mo1;
            mb = ec.getMatrixInput(this.input2.getName());
        }
        FederationMap fedMapping = mo.getFedMapping();
        ArrayList globalCmobj = new ArrayList();
        long varID = FederationUtils.getNextFedDataID();
        fedMapping.mapParallel(varID, (range, data) -> {
            try {
                Object wtBlock;
                FederatedResponse response;
                if (this.input3 == null) {
                    response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new COVFunction(data.getVarID(), mb.slice(range.getBeginDimsInt()[0], range.getEndDimsInt()[0] - 1), cop))).get();
                } else {
                    wtBlock = ec.getMatrixInput(this.input2.getName());
                    response = data.executeFederatedOperation(new FederatedRequest(FederatedRequest.RequestType.EXEC_UDF, -1L, new COVWeightsFunction(data.getVarID(), mb.slice(range.getBeginDimsInt()[0], range.getEndDimsInt()[0] - 1), cop, (MatrixBlock)wtBlock))).get();
                }
                if (!response.isSuccessful()) {
                    response.throwExceptionFromResponse();
                }
                wtBlock = globalCmobj;
                synchronized (wtBlock) {
                    globalCmobj.add((CM_COV_Object)response.getData()[0]);
                }
            }
            catch (Exception e) {
                throw new DMLRuntimeException(e);
            }
            return null;
        });
        Optional res = globalCmobj.stream().reduce((arg0, arg1) -> (CM_COV_Object)cop.fn.execute((Data)arg0, (Data)arg1));
        try {
            ec.setScalarOutput(this.output.getName(), new DoubleObject(((CM_COV_Object)res.get()).getRequiredResult(cop)));
        }
        catch (Exception e) {
            throw new DMLRuntimeException(e);
        }
    }

    private static ImmutableTriple<Double[], Double[], Double[]> getResponses(Future<FederatedResponse>[] covFfr, Future<FederatedResponse>[] mean1Ffr, Future<FederatedResponse>[] mean2Ffr) {
        Double[] cov = new Double[covFfr.length];
        Double[] mean1 = new Double[mean1Ffr.length];
        Double[] mean2 = new Double[mean2Ffr.length];
        IntStream.range(0, covFfr.length).forEach(i -> {
            try {
                cov[i] = ((ScalarObject)((FederatedResponse)covFfr[i].get()).getData()[0]).getDoubleValue();
                mean1[i] = ((ScalarObject)((FederatedResponse)mean1Ffr[1].get()).getData()[0]).getDoubleValue();
                mean2[i] = ((ScalarObject)((FederatedResponse)mean2Ffr[2].get()).getData()[0]).getDoubleValue();
            }
            catch (Exception e) {
                throw new DMLRuntimeException("CovarianceFEDInstruction: incorrect means or cov.");
            }
        });
        return new ImmutableTriple((Object)cov, (Object)mean1, (Object)mean2);
    }

    private static double aggCov(Double[] covValues, Double[] mean1, Double[] mean2, FederatedRange[] ranges) {
        double cov = covValues[0];
        long size1 = ranges[0].getSize();
        double mean = (mean1[0] + mean2[0]) / 2.0;
        for (int i = 0; i < covValues.length - 1; ++i) {
            long size2 = ranges[i + 1].getSize();
            double nextMean = (mean1[i + 1] + mean2[i + 1]) / 2.0;
            double newMean = ((double)size1 * mean + (double)size2 * nextMean) / (double)(size1 + size2);
            cov = ((double)size1 * cov + (double)size2 * covValues[i + 1] + (double)size1 * (mean - newMean) * (mean - newMean) + (double)size2 * (nextMean - newMean) * (nextMean - newMean)) / (double)(size1 + size2);
            mean = newMean;
            size1 += size2;
        }
        return cov;
    }

    private Future<FederatedResponse>[] processMean(MatrixObject mo1, int var) {
        String[] parts = this.instString.split("\u00b0");
        String meanInstr = this.instString.replace(this.getOpcode(), this.getOpcode().replace("cov", "uamean"));
        meanInstr = meanInstr.replace((var == 0 ? parts[2] : parts[3]) + "\u00b0", "");
        meanInstr = meanInstr.replace(parts[4], parts[4].replace("FP64", "STRING\u00b016"));
        Future<FederatedResponse>[] meanTmp = null;
        FederatedRequest meanFr1 = FederationUtils.callInstruction(meanInstr, this.output, new CPOperand[]{var == 0 ? this.input2 : this.input1}, new long[]{mo1.getFedMapping().getID()});
        FederatedRequest meanFr2 = new FederatedRequest(FederatedRequest.RequestType.GET_VAR, meanFr1.getID());
        FederatedRequest meanFr3 = mo1.getFedMapping().cleanup(this.getTID(), meanFr1.getID());
        meanTmp = mo1.getFedMapping().execute(this.getTID(), meanFr1, meanFr2, meanFr3);
        return meanTmp;
    }

    private static class COVWeightsFunction
    extends FederatedUDF {
        private static final long serialVersionUID = -1768739786192949573L;
        private final COVOperator _op;
        private final MatrixBlock _mo2;
        private final MatrixBlock _weights;

        protected COVWeightsFunction(long input, MatrixBlock mo2, COVOperator op, MatrixBlock weights) {
            super(new long[]{input});
            this._mo2 = mo2;
            this._op = op;
            this._weights = weights;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, mb.covOperations(this._op, this._mo2, this._weights));
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }

    private static class COVFunction
    extends FederatedUDF {
        private static final long serialVersionUID = -501036588060113499L;
        private final MatrixBlock _mo2;
        private final COVOperator _op;

        public COVFunction(long input, MatrixBlock mo2, COVOperator op) {
            super(new long[]{input});
            this._op = op;
            this._mo2 = mo2;
        }

        @Override
        public FederatedResponse execute(ExecutionContext ec, Data ... data) {
            MatrixBlock mb = (MatrixBlock)((MatrixObject)data[0]).acquireReadAndRelease();
            return new FederatedResponse(FederatedResponse.ResponseType.SUCCESS, mb.covOperations(this._op, this._mo2));
        }

        @Override
        public Pair<String, LineageItem> getLineageItem(ExecutionContext ec) {
            return null;
        }
    }
}

