/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.broadcast;

import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.zip.Adler32;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkException;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.TorrentBroadcast$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.serializer.Serializer;
import org.apache.spark.storage.BlockData;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.storage.BlockResult;
import org.apache.spark.storage.BroadcastBlockId;
import org.apache.spark.storage.BroadcastBlockId$;
import org.apache.spark.storage.ByteBufferBlockData;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.io.ChunkedByteBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Integral;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\t\rd!\u0002\u0017.\u0001=*\u0004\u0002\u0003-\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\t\u0013e\u0003!\u0011!Q\u0001\nik\u0006\u0002\u00030\u0001\u0005\u0007\u0005\u000b1B0\t\u000b\u0015\u0004A\u0011\u00014\t\u00131\u0004\u0001\u0019!a\u0001\n\u0013i\u0007\"\u0003<\u0001\u0001\u0004\u0005\r\u0011\"\u0003x\u0011%i\b\u00011A\u0001B\u0003&a\u000eC\u0006\u0002\u0006\u0001\u0001\r\u00111A\u0005\n\u0005\u001d\u0001bCA\r\u0001\u0001\u0007\t\u0019!C\u0005\u00037A1\"a\b\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002\n!Y\u00111\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0013\u0011-\ti\u0003\u0001a\u0001\u0002\u0004%I!a\f\t\u0017\u0005M\u0002\u00011A\u0001B\u0003&\u0011q\u0005\u0005\b\u0003o\u0001A\u0011BA\u001d\u0011%\t9\u0005\u0001b\u0001\n\u0013\tI\u0005\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA&\u0011%\tI\u0006\u0001b\u0001\n\u0013\t)\u0003\u0003\u0005\u0002\\\u0001\u0001\u000b\u0011BA\u0014\u0011%\ti\u0006\u0001a\u0001\n\u0013\ty\u0006C\u0005\u0002h\u0001\u0001\r\u0011\"\u0003\u0002j!A\u0011Q\u000e\u0001!B\u0013\t\t\u0007C\u0006\u0002p\u0001\u0001\r\u00111A\u0005\n\u0005E\u0004bCA=\u0001\u0001\u0007\t\u0019!C\u0005\u0003wB1\"a \u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002t!9\u0011\u0011\u0011\u0001\u0005R\u0005\r\u0005bBAC\u0001\u0011%\u0011q\u0011\u0005\b\u00033\u0003A\u0011BAN\u0011\u001d\t\t\u000b\u0001C\u0005\u0003GCq!!,\u0001\t#\ny\u000bC\u0004\u00026\u0002!\t&a.\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u0011\u0011\u001a\u0001\u0005\n\u0005\r\u0005bBAf\u0001\u0011%\u0011Q\u001a\u0005\u000e\u00033\u0004\u0001\u0013aA\u0001\u0002\u0013%\u00111\\/\b\u000f\u0005uW\u0006#\u0003\u0002`\u001a1A&\fE\u0005\u0003CDa!\u001a\u0013\u0005\u0002\u00055\b\"CAxI\t\u0007I\u0011BAy\u0011!\ty\u0010\nQ\u0001\n\u0005M\bb\u0002B\u0001I\u0011\u0005!1\u0001\u0005\b\u0005S!C\u0011\u0001B\u0016\u0011\u001d\u0011Y\u0005\nC\u0001\u0005\u001bB\u0011Ba\u0016%\u0003\u0003%IA!\u0017\u0003!Q{'O]3oi\n\u0013x.\u00193dCN$(B\u0001\u00180\u0003%\u0011'o\\1eG\u0006\u001cHO\u0003\u00021c\u0005)1\u000f]1sW*\u0011!gM\u0001\u0007CB\f7\r[3\u000b\u0003Q\n1a\u001c:h+\t1Th\u0005\u0003\u0001o)\u0003\u0006c\u0001\u001d:w5\tQ&\u0003\u0002;[\tI!I]8bI\u000e\f7\u000f\u001e\t\u0003yub\u0001\u0001B\u0003?\u0001\t\u0007\u0001IA\u0001U\u0007\u0001\t\"!Q$\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\u000f9{G\u000f[5oOB\u0011!\tS\u0005\u0003\u0013\u000e\u00131!\u00118z!\tYe*D\u0001M\u0015\tiu&\u0001\u0005j]R,'O\\1m\u0013\tyEJA\u0004M_\u001e<\u0017N\\4\u0011\u0005E3V\"\u0001*\u000b\u0005M#\u0016AA5p\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0007=\u0014'.\u0001\u0002jIB\u0011!iW\u0005\u00039\u000e\u0013A\u0001T8oO&\u0011\u0011,O\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u00011dw5\t\u0011M\u0003\u0002c\u0007\u00069!/\u001a4mK\u000e$\u0018B\u00013b\u0005!\u0019E.Y:t)\u0006<\u0017A\u0002\u001fj]&$h\bF\u0002hU.$\"\u0001[5\u0011\u0007a\u00021\bC\u0003_\t\u0001\u000fq\fC\u0003Y\t\u0001\u00071\bC\u0003Z\t\u0001\u0007!,\u0001\u0004`m\u0006dW/Z\u000b\u0002]B\u0019q\u000e^\u001e\u000e\u0003AT!!\u001d:\u0002\u0007I,gM\u0003\u0002t)\u0006!A.\u00198h\u0013\t)\bOA\u0007T_\u001a$(+\u001a4fe\u0016t7-Z\u0001\u000b?Z\fG.^3`I\u0015\fHC\u0001=|!\t\u0011\u00150\u0003\u0002{\u0007\n!QK\\5u\u0011\u001dah!!AA\u00029\f1\u0001\u001f\u00132\u0003\u001dyf/\u00197vK\u0002B#aB@\u0011\u0007\t\u000b\t!C\u0002\u0002\u0004\r\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002!\r|W\u000e\u001d:fgNLwN\\\"pI\u0016\u001cWCAA\u0005!\u0015\u0011\u00151BA\b\u0013\r\tia\u0011\u0002\u0007\u001fB$\u0018n\u001c8\u0011\t\u0005E\u0011QC\u0007\u0003\u0003'Q!aU\u0018\n\t\u0005]\u00111\u0003\u0002\u0011\u0007>l\u0007O]3tg&|gnQ8eK\u000e\fAcY8naJ,7o]5p]\u000e{G-Z2`I\u0015\fHc\u0001=\u0002\u001e!AA0CA\u0001\u0002\u0004\tI!A\td_6\u0004(/Z:tS>t7i\u001c3fG\u0002B#AC@\u0002\u0013\tdwnY6TSj,WCAA\u0014!\r\u0011\u0015\u0011F\u0005\u0004\u0003W\u0019%aA%oi\u0006i!\r\\8dWNK'0Z0%KF$2\u0001_A\u0019\u0011!aH\"!AA\u0002\u0005\u001d\u0012A\u00032m_\u000e\\7+\u001b>fA!\u0012Qb`\u0001\bg\u0016$8i\u001c8g)\rA\u00181\b\u0005\b\u0003{q\u0001\u0019AA \u0003\u0011\u0019wN\u001c4\u0011\t\u0005\u0005\u00131I\u0007\u0002_%\u0019\u0011QI\u0018\u0003\u0013M\u0003\u0018M]6D_:4\u0017a\u00032s_\u0006$7-Y:u\u0013\u0012,\"!a\u0013\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u00150\u0003\u001d\u0019Ho\u001c:bO\u0016LA!!\u0016\u0002P\t\u0001\"I]8bI\u000e\f7\u000f\u001e\"m_\u000e\\\u0017\nZ\u0001\rEJ|\u0017\rZ2bgRLE\rI\u0001\n]Vl'\t\\8dWN\f!B\\;n\u00052|7m[:!\u0003=\u0019\u0007.Z2lgVlWI\\1cY\u0016$WCAA1!\r\u0011\u00151M\u0005\u0004\u0003K\u001a%a\u0002\"p_2,\u0017M\\\u0001\u0014G\",7m[:v[\u0016s\u0017M\u00197fI~#S-\u001d\u000b\u0004q\u0006-\u0004\u0002\u0003?\u0015\u0003\u0003\u0005\r!!\u0019\u0002!\rDWmY6tk6,e.\u00192mK\u0012\u0004\u0013!C2iK\u000e\\7/^7t+\t\t\u0019\bE\u0003C\u0003k\n9#C\u0002\u0002x\r\u0013Q!\u0011:sCf\fQb\u00195fG.\u001cX/\\:`I\u0015\fHc\u0001=\u0002~!AApFA\u0001\u0002\u0004\t\u0019(\u0001\u0006dQ\u0016\u001c7n];ng\u0002\n\u0001bZ3u-\u0006dW/\u001a\u000b\u0002w\u0005a1-\u00197d\u0007\",7m[:v[R!\u0011qEAE\u0011\u001d\tYI\u0007a\u0001\u0003\u001b\u000bQA\u00197pG.\u0004B!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0004\u0003'#\u0016a\u00018j_&!\u0011qSAI\u0005)\u0011\u0015\u0010^3Ck\u001a4WM]\u0001\foJLG/\u001a\"m_\u000e\\7\u000f\u0006\u0003\u0002(\u0005u\u0005BBAP7\u0001\u00071(A\u0003wC2,X-\u0001\u0006sK\u0006$'\t\\8dWN$\"!!*\u0011\u000b\t\u000b)(a*\u0011\t\u00055\u0013\u0011V\u0005\u0005\u0003W\u000byEA\u0005CY>\u001c7\u000eR1uC\u0006YAm\\+oa\u0016\u00148/[:u)\rA\u0018\u0011\u0017\u0005\b\u0003gk\u0002\u0019AA1\u0003!\u0011Gn\\2lS:<\u0017!\u00033p\t\u0016\u001cHO]8z)\rA\u0018\u0011\u0018\u0005\b\u0003gs\u0002\u0019AA1\u0003-9(/\u001b;f\u001f\nTWm\u0019;\u0015\u0007a\fy\fC\u0004\u0002B~\u0001\r!a1\u0002\u0007=,H\u000fE\u0002R\u0003\u000bL1!a2S\u0005Iy%M[3di>+H\u000f];u'R\u0014X-Y7\u0002%I,\u0017\r\u001a\"s_\u0006$7-Y:u\u00052|7m[\u0001\u0018e\u0016dW-Y:f\u00052|7m['b]\u0006<WM\u001d'pG.$2\u0001_Ah\u0011\u001d\t\t.\ta\u0001\u0003'\fqA\u00197pG.LE\r\u0005\u0003\u0002N\u0005U\u0017\u0002BAl\u0003\u001f\u0012qA\u00117pG.LE-\u0001\u0005tkB,'\u000fJ5e+\u0005Q\u0016\u0001\u0005+peJ,g\u000e\u001e\"s_\u0006$7-Y:u!\tADe\u0005\u0004%\u0003GT\u0015\u0011\u001e\t\u0004\u0005\u0006\u0015\u0018bAAt\u0007\n1\u0011I\\=SK\u001a\u00042AQAv\u0013\t96\t\u0006\u0002\u0002`\u0006!Bo\u001c:sK:$(I]8bI\u000e\f7\u000f\u001e'pG.,\"!a=\u0011\r\u0005U\u00181`A&\u001b\t\t9PC\u0002\u0002z>\nA!\u001e;jY&!\u0011Q`A|\u0005\u001dYU-\u001f'pG.\fQ\u0003^8se\u0016tGO\u0011:pC\u0012\u001c\u0017m\u001d;M_\u000e\\\u0007%\u0001\bcY>\u001c7.\u001b4z\u001f\nTWm\u0019;\u0016\t\t\u0015!1\u0003\u000b\u000b\u0005\u000f\u0011)Ba\u0006\u0003\u001a\t\u001dB\u0003\u0002B\u0005\u0005\u0017\u0001RAQA;\u0003\u001bC\u0011B!\u0004)\u0003\u0003\u0005\u001dAa\u0004\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$#\u0007\u0005\u0003aG\nE\u0001c\u0001\u001f\u0003\u0014\u0011)a\b\u000bb\u0001\u0001\"1\u0001\f\u000ba\u0001\u0005#Aq!a\t)\u0001\u0004\t9\u0003C\u0004\u0003\u001c!\u0002\rA!\b\u0002\u0015M,'/[1mSj,'\u000f\u0005\u0003\u0003 \t\rRB\u0001B\u0011\u0015\r\u0011YbL\u0005\u0005\u0005K\u0011\tC\u0001\u0006TKJL\u0017\r\\5{KJDq!!\u0002)\u0001\u0004\tI!\u0001\tv]\ncwnY6jMf|%M[3diV!!Q\u0006B\u001a)!\u0011yCa\u000f\u0003H\t%C\u0003\u0002B\u0019\u0005k\u00012\u0001\u0010B\u001a\t\u0015q\u0014F1\u0001A\u0011%\u00119$KA\u0001\u0002\b\u0011I$\u0001\u0006fm&$WM\\2fIM\u0002B\u0001Y2\u00032!9!QH\u0015A\u0002\t}\u0012A\u00022m_\u000e\\7\u000fE\u0003C\u0003k\u0012\t\u0005E\u0002R\u0005\u0007J1A!\u0012S\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\tm\u0011\u00061\u0001\u0003\u001e!9\u0011QA\u0015A\u0002\u0005%\u0011!C;oa\u0016\u00148/[:u)\u001dA(q\nB)\u0005+BQ!\u0017\u0016A\u0002iCqAa\u0015+\u0001\u0004\t\t'\u0001\tsK6|g/\u001a$s_6$%/\u001b<fe\"9\u00111\u0017\u0016A\u0002\u0005\u0005\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"Aa\u0017\u0011\t\tu#qL\u0007\u0002e&\u0019!\u0011\r:\u0003\r=\u0013'.Z2u\u0001")
public class TorrentBroadcast<T>
extends Broadcast<T> {
    private final ClassTag<T> evidence$1;
    private transient SoftReference<T> _value;
    private transient Option<CompressionCodec> compressionCodec;
    private transient int blockSize;
    private final BroadcastBlockId broadcastId;
    private final int numBlocks;
    private boolean checksumEnabled;
    private int[] checksums;

    public static <T> T unBlockifyObject(InputStream[] inputStreamArray, Serializer serializer, Option<CompressionCodec> option, ClassTag<T> classTag) {
        return TorrentBroadcast$.MODULE$.unBlockifyObject(inputStreamArray, serializer, option, classTag);
    }

    public static <T> ByteBuffer[] blockifyObject(T t, int n, Serializer serializer, Option<CompressionCodec> option, ClassTag<T> classTag) {
        return TorrentBroadcast$.MODULE$.blockifyObject(t, n, serializer, option, classTag);
    }

    private /* synthetic */ long super$id() {
        return super.id();
    }

    private SoftReference<T> _value() {
        return this._value;
    }

    private void _value_$eq(SoftReference<T> x$1) {
        this._value = x$1;
    }

    private Option<CompressionCodec> compressionCodec() {
        return this.compressionCodec;
    }

    private void compressionCodec_$eq(Option<CompressionCodec> x$1) {
        this.compressionCodec = x$1;
    }

    private int blockSize() {
        return this.blockSize;
    }

    private void blockSize_$eq(int x$1) {
        this.blockSize = x$1;
    }

    private void setConf(SparkConf conf) {
        this.compressionCodec_$eq((Option<CompressionCodec>)(BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.BROADCAST_COMPRESS())) ? new Some((Object)CompressionCodec$.MODULE$.createCodec(conf)) : None$.MODULE$));
        this.blockSize_$eq((int)BoxesRunTime.unboxToLong((Object)conf.get(package$.MODULE$.BROADCAST_BLOCKSIZE())) * 1024);
        this.checksumEnabled_$eq(BoxesRunTime.unboxToBoolean((Object)conf.get(package$.MODULE$.BROADCAST_CHECKSUM())));
    }

    private BroadcastBlockId broadcastId() {
        return this.broadcastId;
    }

    private int numBlocks() {
        return this.numBlocks;
    }

    private boolean checksumEnabled() {
        return this.checksumEnabled;
    }

    private void checksumEnabled_$eq(boolean x$1) {
        this.checksumEnabled = x$1;
    }

    private int[] checksums() {
        return this.checksums;
    }

    private void checksums_$eq(int[] x$1) {
        this.checksums = x$1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized T getValue() {
        T t;
        T memoized;
        T t2 = memoized = this._value() == null ? null : (T)this._value().get();
        if (memoized != null) {
            t = memoized;
        } else {
            void var2_2;
            T newlyRead = this.readBroadcastBlock();
            this._value_$eq(new SoftReference<T>(newlyRead));
            t = var2_2;
        }
        return t;
    }

    private int calcChecksum(ByteBuffer block) {
        Adler32 adler = new Adler32();
        if (block.hasArray()) {
            adler.update(block.array(), block.arrayOffset() + block.position(), block.limit() - block.position());
        } else {
            byte[] bytes = new byte[block.remaining()];
            block.duplicate().get(bytes);
            adler.update(bytes);
        }
        return (int)adler.getValue();
    }

    private int writeBlocks(T value) {
        int n;
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        if (!blockManager.putSingle(this.broadcastId(), value, StorageLevel$.MODULE$.MEMORY_AND_DISK(), false, this.evidence$1)) {
            throw new SparkException(new StringBuilder(32).append("Failed to store ").append(this.broadcastId()).append(" in BlockManager").toString());
        }
        try {
            ByteBuffer[] blocks = TorrentBroadcast$.MODULE$.blockifyObject(value, this.blockSize(), SparkEnv$.MODULE$.get().serializer(), this.compressionCodec(), this.evidence$1);
            if (this.checksumEnabled()) {
                this.checksums_$eq(new int[blocks.length]);
            }
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                TorrentBroadcast.$anonfun$writeBlocks$1(this, blockManager, x0$1);
                return BoxedUnit.UNIT;
            });
            n = blocks.length;
        }
        catch (Throwable t) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(57).append("Store broadcast ").append(this.broadcastId()).append(" fail, remove all pieces of the broadcast").toString());
            blockManager.removeBroadcast(super.id(), true);
            throw t;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private BlockData[] readBlocks() {
        void var1_1;
        BlockData[] blocks = new BlockData[this.numBlocks()];
        BlockManager bm = SparkEnv$.MODULE$.get().blockManager();
        ((IterableLike)Random$.MODULE$.shuffle((TraversableOnce)Seq$.MODULE$.range((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)this.numBlocks()), (Integral)Numeric.IntIsIntegral$.MODULE$), Seq$.MODULE$.canBuildFrom())).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)pid -> {
            BroadcastBlockId pieceId = new BroadcastBlockId(this.super$id(), new StringBuilder(5).append("piece").append(pid).toString());
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Reading piece ").append(pieceId).append(" of ").append(this.broadcastId()).toString());
            Option<BlockData> option = bm.getLocalBytes(pieceId);
            if (option instanceof Some) {
                BlockData block;
                Some some = (Some)option;
                blocks$1[pid] = block = (BlockData)some.value();
                this.releaseBlockManagerLock(pieceId);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                ChunkedByteBuffer b;
                Option<ChunkedByteBuffer> option2 = bm.getRemoteBytes(pieceId);
                if (option2 instanceof Some) {
                    int sum;
                    Some some = (Some)option2;
                    b = (ChunkedByteBuffer)some.value();
                    if (this.checksumEnabled() && (sum = this.calcChecksum(b.chunks()[0])) != this.checksums()[pid]) {
                        throw new SparkException(new StringBuilder(31).append("corrupt remote block ").append(pieceId).append(" of ").append(this.broadcastId()).append(":").append(" ").append(sum).append(" != ").append(this.checksums()[pid]).toString());
                    }
                    if (!bm.putBytes(pieceId, b, StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), true, $this.evidence$1)) {
                        throw new SparkException(new StringBuilder(42).append("Failed to store ").append(pieceId).append(" of ").append(this.broadcastId()).append(" in local BlockManager").toString());
                    }
                } else {
                    if (None$.MODULE$.equals(option2)) {
                        throw new SparkException(new StringBuilder(18).append("Failed to get ").append(pieceId).append(" of ").append(this.broadcastId()).toString());
                    }
                    throw new MatchError(option2);
                }
                blocks$1[pid] = new ByteBufferBlockData(b, true);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option);
            }
        });
        return var1_1;
    }

    @Override
    public void doUnpersist(boolean blocking) {
        TorrentBroadcast$.MODULE$.unpersist(super.id(), false, blocking);
    }

    @Override
    public void doDestroy(boolean blocking) {
        TorrentBroadcast$.MODULE$.unpersist(super.id(), true, blocking);
    }

    private void writeObject(ObjectOutputStream out) {
        Utils$.MODULE$.tryOrIOException((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.assertValid();
            out.defaultWriteObject();
        });
    }

    private T readBroadcastBlock() {
        return Utils$.MODULE$.tryOrIOException((Function0 & Serializable & scala.Serializable)() -> TorrentBroadcast$.MODULE$.org$apache$spark$broadcast$TorrentBroadcast$$torrentBroadcastLock().withLock(this.broadcastId(), (Function0 & Serializable & scala.Serializable)() -> {
            Map<Object, Object> broadcastCache = SparkEnv$.MODULE$.get().broadcastManager().cachedValues();
            return Option$.MODULE$.apply(broadcastCache.get(this.broadcastId())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Object object;
                this.setConf(SparkEnv$.MODULE$.get().conf());
                BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
                Option<BlockResult> option = blockManager.getLocalValues(this.broadcastId());
                if (option instanceof Some) {
                    Some some = (Some)option;
                    BlockResult blockResult = (BlockResult)some.value();
                    if (!blockResult.data().hasNext()) {
                        throw new SparkException(new StringBuilder(45).append("Failed to get locally stored broadcast data: ").append(this.broadcastId()).toString());
                    }
                    Object x = blockResult.data().next();
                    this.releaseBlockManagerLock(this.broadcastId());
                    Object object2 = x != null ? broadcastCache.put(this.broadcastId(), x) : BoxedUnit.UNIT;
                    object = x;
                } else if (None$.MODULE$.equals(option)) {
                    Object t;
                    String estimatedTotalSize = Utils$.MODULE$.bytesToString(this.numBlocks() * this.blockSize());
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Started reading broadcast variable ").append(this.super$id()).append(" with ").append(this.numBlocks()).append(" pieces ").append("(estimated total size ").append(estimatedTotalSize).append(")").toString());
                    long startTimeNs = System.nanoTime();
                    BlockData[] blocks = this.readBlocks();
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Reading broadcast variable ").append(this.super$id()).append(" took ").append(Utils$.MODULE$.getUsedTimeNs(startTimeNs)).toString());
                    try {
                        Object obj = TorrentBroadcast$.MODULE$.unBlockifyObject((InputStream[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toInputStream(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InputStream.class))), SparkEnv$.MODULE$.get().serializer(), this.compressionCodec(), $this.evidence$1);
                        StorageLevel storageLevel = StorageLevel$.MODULE$.MEMORY_AND_DISK();
                        if (!blockManager.putSingle(this.broadcastId(), obj, storageLevel, false, $this.evidence$1)) {
                            throw new SparkException(new StringBuilder(32).append("Failed to store ").append(this.broadcastId()).append(" in BlockManager").toString());
                        }
                        Object object3 = obj != null ? broadcastCache.put(this.broadcastId(), obj) : BoxedUnit.UNIT;
                        t = obj;
                    }
                    finally {
                        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])blocks)).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                            x$3.dispose();
                            return BoxedUnit.UNIT;
                        });
                    }
                    object = t;
                } else {
                    throw new MatchError(option);
                }
                return object;
            });
        }));
    }

    private void releaseBlockManagerLock(BlockId blockId) {
        BlockManager blockManager = SparkEnv$.MODULE$.get().blockManager();
        Option option = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
        if (option instanceof Some) {
            Some some = (Some)option;
            TaskContext taskContext = (TaskContext)some.value();
            taskContext.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$4 -> {
                blockManager.releaseLock(blockId, blockManager.releaseLock$default$2());
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            blockManager.releaseLock(blockId, blockManager.releaseLock$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ void $anonfun$writeBlocks$1(TorrentBroadcast $this, BlockManager blockManager$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            ChunkedByteBuffer bytes;
            BroadcastBlockId pieceId;
            ByteBuffer block = (ByteBuffer)tuple2._1();
            int i = tuple2._2$mcI$sp();
            if ($this.checksumEnabled()) {
                $this.checksums()[i] = $this.calcChecksum(block);
            }
            if (!blockManager$1.putBytes(pieceId = new BroadcastBlockId($this.super$id(), new StringBuilder(5).append("piece").append(i).toString()), bytes = new ChunkedByteBuffer(block.duplicate()), StorageLevel$.MODULE$.MEMORY_AND_DISK_SER(), true, $this.evidence$1)) {
                throw new SparkException(new StringBuilder(42).append("Failed to store ").append(pieceId).append(" of ").append($this.broadcastId()).append(" ").append("in local BlockManager").toString());
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public TorrentBroadcast(T obj, long id, ClassTag<T> evidence$1) {
        this.evidence$1 = evidence$1;
        super(id, evidence$1);
        this.setConf(SparkEnv$.MODULE$.get().conf());
        this.broadcastId = new BroadcastBlockId(super.id(), BroadcastBlockId$.MODULE$.apply$default$2());
        this.numBlocks = this.writeBlocks(obj);
        this.checksumEnabled = false;
    }
}

