# -------------------------------------------------------------
#
# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
#
# -------------------------------------------------------------

# Autogenerated By   : src/main/python/generator/generator.py
# Autogenerated From : scripts/builtin/gridSearch.dml

from typing import Dict, Iterable

from systemds.operator import OperationNode, Matrix, Frame, List, MultiReturn, Scalar
from systemds.script_building.dag import OutputType
from systemds.utils.consts import VALID_INPUT_TYPES


def gridSearch(X: Matrix,
               y: Matrix,
               train: str,
               predict: str,
               params: List,
               paramValues: List,
               **kwargs: Dict[str, VALID_INPUT_TYPES]):
    """
     The gridSearch-function is used to find the optimal hyper-parameters of a model which results in the most
     accurate predictions. This function takes train and eval functions by name.
    
    
    
    :param X: Input feature matrix
    :param y: Input Matrix of vectors.
    :param train: Name ft of the train function to call via ft(trainArgs)
    :param predict: Name fp of the loss function to call via fp((predictArgs,B))
    :param numB: Maximum number of parameters in model B (pass the max because the size
        may vary with parameters like icpt or multi-class classification)
    :param params: List of varied hyper-parameter names
    :param dataArgs: List of data parameters (to identify data parameters by name i.e. list("X", "Y"))
    :param paramValues: List of matrices providing the parameter values as
        columnvectors for position-aligned hyper-parameters in 'params'
    :param trainArgs: named List of arguments to pass to the 'train' function, where
        gridSearch replaces enumerated hyper-parameter by name, if
        not provided or an empty list, the lm parameters are used
    :param predictArgs: List of arguments to pass to the 'predict' function, where
        gridSearch appends the trained models at the end, if
        not provided or an empty list, list(X, y) is used instead
    :param cv: flag enabling k-fold cross validation, otherwise training loss
    :param cvk: if cv=TRUE, specifies the the number of folds, otherwise ignored
    :param verbose: flag for verbose debug output
    :return: Matrix[Double]the trained model with minimal loss (by the 'predict' function)
        Multi-column models are returned as a column-major linearized column vector
    :return: one-row frame w/ optimal hyper-parameters (by 'params' position)
    """

    params_dict = {'X': X, 'y': y, 'train': train, 'predict': predict, 'params': params, 'paramValues': paramValues}
    params_dict.update(kwargs)
    
    vX_0 = Matrix(X.sds_context, '')
    vX_1 = Frame(X.sds_context, '')
    output_nodes = [vX_0, vX_1, ]

    op = MultiReturn(X.sds_context, 'gridSearch', output_nodes, named_input_nodes=params_dict)

    vX_0._unnamed_input_nodes = [op]
    vX_1._unnamed_input_nodes = [op]

    return op
