/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cocode;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cocode.AColumnCoCoder;
import org.apache.sysds.runtime.compress.cocode.CoCodeGreedy;
import org.apache.sysds.runtime.compress.cocode.CoCodePriorityQue;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.estim.AComEst;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;

public class CoCodeHybrid
extends AColumnCoCoder {
    protected CoCodeHybrid(AComEst sizeEstimator, ACostEstimate costEstimator, CompressionSettings cs) {
        super(sizeEstimator, costEstimator, cs);
    }

    @Override
    protected CompressedSizeInfo coCodeColumns(CompressedSizeInfo colInfos, int k) {
        int startSize = colInfos.getInfo().size();
        if (startSize == 1) {
            return colInfos;
        }
        if (startSize <= 16) {
            LOG.debug((Object)"Hybrid chose to do greedy cocode because of few columns");
            CoCodeGreedy gd = new CoCodeGreedy(this._sest, this._cest, this._cs);
            return colInfos.setInfo(gd.combine(colInfos.getInfo(), k));
        }
        if (startSize > 1000) {
            return colInfos.setInfo(CoCodePriorityQue.join(colInfos.getInfo(), this._sest, this._cest, 1, k));
        }
        LOG.debug((Object)"Using Hybrid Cocode Strategy: ");
        int PriorityQueGoal = startSize / 5;
        if (PriorityQueGoal > 30) {
            Timing time = new Timing(true);
            colInfos.setInfo(CoCodePriorityQue.join(colInfos.getInfo(), this._sest, this._cest, PriorityQueGoal, k));
            LOG.debug((Object)("Que based time: " + time.stop()));
            int pqSize = colInfos.getInfo().size();
            if (pqSize <= PriorityQueGoal * 2) {
                time = new Timing(true);
                CoCodeGreedy gd = new CoCodeGreedy(this._sest, this._cest, this._cs);
                colInfos.setInfo(gd.combine(colInfos.getInfo(), k));
                LOG.debug((Object)("Greedy time:     " + time.stop()));
            }
            return colInfos;
        }
        return colInfos.setInfo(CoCodePriorityQue.join(colInfos.getInfo(), this._sest, this._cest, 1, k));
    }
}

