/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.columns;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.frame.data.columns.ABooleanArray;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ArrayFactory;
import org.apache.sysds.runtime.frame.data.columns.BitSetArray;
import org.apache.sysds.runtime.frame.data.columns.CharArray;
import org.apache.sysds.runtime.frame.data.columns.DoubleArray;
import org.apache.sysds.runtime.frame.data.columns.FloatArray;
import org.apache.sysds.runtime.frame.data.columns.HashLongArray;
import org.apache.sysds.runtime.frame.data.columns.IntegerArray;
import org.apache.sysds.runtime.frame.data.columns.LongArray;
import org.apache.sysds.runtime.frame.data.columns.OptionalArray;
import org.apache.sysds.runtime.frame.data.columns.StringArray;
import org.apache.sysds.runtime.frame.data.compress.ArrayCompressionStatistics;
import org.apache.sysds.runtime.matrix.data.Pair;
import org.apache.sysds.runtime.util.UtilFunctions;
import org.apache.sysds.utils.MemoryEstimates;

public class BooleanArray
extends ABooleanArray {
    protected boolean[] _data;

    public BooleanArray(boolean[] data) {
        super(data.length);
        this._data = data;
    }

    public boolean[] get() {
        return this._data;
    }

    @Override
    public Boolean get(int index) {
        return this._data[index];
    }

    @Override
    public void set(int index, Boolean value) {
        this._data[index] = value != null && value != false;
    }

    @Override
    public void set(int index, double value) {
        this._data[index] = (double)Math.round(value) == 1.0;
    }

    @Override
    public void set(int index, String value) {
        this.set(index, BooleanArray.parseBoolean(value));
    }

    @Override
    public void set(int rl, int ru, Array<Boolean> value) {
        this.set(rl, ru, value, 0);
    }

    @Override
    public void setFromOtherType(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            this.set(i, UtilFunctions.objectToBoolean(vt, value.get(i)));
        }
    }

    @Override
    public void set(int rl, int ru, Array<Boolean> value, int rlSrc) {
        if (value instanceof BooleanArray) {
            try {
                System.arraycopy(value.get(), rlSrc, this._data, rl, ru - rl + 1);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.set(rl, ru, value, rlSrc);
    }

    @Override
    public void setNz(int rl, int ru, Array<Boolean> value) {
        if (value instanceof BooleanArray) {
            boolean[] data2 = ((BooleanArray)value)._data;
            for (int i = rl; i <= ru; ++i) {
                if (!data2[i]) continue;
                this._data[i] = data2[i];
            }
        } else {
            for (int i = rl; i <= ru; ++i) {
                boolean v = value.get(i);
                if (!v) continue;
                this._data[i] = v;
            }
        }
    }

    @Override
    public void setFromOtherTypeNz(int rl, int ru, Array<?> value) {
        Types.ValueType vt = value.getValueType();
        for (int i = rl; i <= ru; ++i) {
            boolean v = UtilFunctions.objectToBoolean(vt, value.get(i));
            if (!v) continue;
            this._data[i] = v;
        }
    }

    @Override
    public void append(String value) {
        this.append(BooleanArray.parseBoolean(value));
    }

    @Override
    public void append(Boolean value) {
        if (this._data.length <= this._size) {
            this._data = Arrays.copyOf(this._data, this.newSize());
        }
        this._data[this._size++] = value != null ? value : false;
    }

    @Override
    public Array<Boolean> append(Array<Boolean> other) {
        int endSize = this._size + other.size();
        ABooleanArray retBS = ArrayFactory.allocateBoolean(endSize);
        retBS.set(0, this._size - 1, this);
        if (other instanceof OptionalArray) {
            retBS.set(this._size, endSize - 1, ((OptionalArray)other)._a);
            return OptionalArray.appendOther((OptionalArray)other, retBS);
        }
        retBS.set(this._size, endSize - 1, other);
        return retBS;
    }

    public void write(DataOutput out) throws IOException {
        out.writeByte(ArrayFactory.FrameArrayType.BOOLEAN.ordinal());
        for (int i = 0; i < this._size; ++i) {
            out.writeBoolean(this._data[i]);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this._size = this._data.length;
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readBoolean();
        }
    }

    @Override
    public ABooleanArray clone() {
        return new BooleanArray(Arrays.copyOf(this._data, this._size));
    }

    @Override
    public ABooleanArray slice(int rl, int ru) {
        return new BooleanArray(Arrays.copyOfRange(this._data, rl, ru));
    }

    @Override
    public void reset(int size) {
        if (this._data.length < size || this._data.length > 2 * size) {
            this._data = new boolean[size];
        } else {
            for (int i = 0; i < size; ++i) {
                this._data[i] = false;
            }
        }
        this._size = size;
    }

    @Override
    public byte[] getAsByteArray() {
        ByteBuffer booleanBuffer = ByteBuffer.allocate(this._size);
        booleanBuffer.order(ByteOrder.nativeOrder());
        for (int i = 0; i < this._size; ++i) {
            booleanBuffer.put((byte)(this._data[i] ? 1 : 0));
        }
        return booleanBuffer.array();
    }

    @Override
    public Types.ValueType getValueType() {
        return Types.ValueType.BOOLEAN;
    }

    @Override
    public Pair<Types.ValueType, Boolean> analyzeValueType(int maxCells) {
        return new Pair<Types.ValueType, Boolean>(Types.ValueType.BOOLEAN, false);
    }

    @Override
    public ArrayFactory.FrameArrayType getFrameArrayType() {
        return ArrayFactory.FrameArrayType.BOOLEAN;
    }

    @Override
    public long getInMemorySize() {
        return BooleanArray.estimateInMemorySize(this._size);
    }

    public static long estimateInMemorySize(int nRow) {
        long size = BooleanArray.baseMemoryCost();
        size = (long)((double)size + MemoryEstimates.booleanArrayCost(nRow));
        return size;
    }

    @Override
    public long getExactSerializedSize() {
        return 1 + this._data.length;
    }

    protected ABooleanArray changeTypeBitSet() {
        return new BitSetArray(this._data);
    }

    protected ABooleanArray changeTypeBoolean() {
        return this;
    }

    @Override
    protected Array<Double> changeTypeDouble() {
        double[] ret = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i] ? 1.0 : 0.0;
        }
        return new DoubleArray(ret);
    }

    @Override
    protected Array<Float> changeTypeFloat() {
        float[] ret = new float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i] ? 1.0f : 0.0f;
        }
        return new FloatArray(ret);
    }

    @Override
    protected Array<Integer> changeTypeInteger() {
        int[] ret = new int[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i] ? 1 : 0;
        }
        return new IntegerArray(ret);
    }

    @Override
    protected Array<Long> changeTypeLong() {
        long[] ret = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i] ? 1L : 0L;
        }
        return new LongArray(ret);
    }

    @Override
    protected Array<Object> changeTypeHash64() {
        long[] ret = new long[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this._data[i] ? 1L : 0L;
        }
        return new HashLongArray(ret);
    }

    @Override
    protected Array<String> changeTypeString() {
        String[] ret = new String[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = this.get(i).toString();
        }
        return new StringArray(ret);
    }

    @Override
    public Array<Character> changeTypeCharacter() {
        char[] ret = new char[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            ret[i] = (char)(this._data[i] ? 1 : 0);
        }
        return new CharArray(ret);
    }

    @Override
    public void fill(String value) {
        this.fill(BooleanArray.parseBoolean(value));
    }

    @Override
    public void fill(Boolean value) {
        value = value != null ? value : false;
        Arrays.fill(this._data, value);
    }

    @Override
    public boolean isShallowSerialize() {
        return true;
    }

    @Override
    public double getAsDouble(int i) {
        return this._data[i] ? 1.0 : 0.0;
    }

    @Override
    public boolean isEmpty() {
        for (int i = 0; i < this._size; ++i) {
            if (!this._data[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isAllTrue() {
        for (int i = 0; i < this._size; ++i) {
            if (this._data[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public ABooleanArray select(int[] indices) {
        boolean[] ret = new boolean[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            ret[i] = this._data[indices[i]];
        }
        return new BooleanArray(ret);
    }

    @Override
    public ABooleanArray select(boolean[] select, int nTrue) {
        boolean[] ret = new boolean[nTrue];
        int k = 0;
        for (int i = 0; i < select.length; ++i) {
            if (!select[i]) continue;
            ret[k++] = this._data[i];
        }
        return new BooleanArray(ret);
    }

    @Override
    public final boolean isNotEmpty(int i) {
        return this._data[i];
    }

    public static boolean parseBoolean(String value) {
        return value != null && !value.isEmpty() && (Boolean.parseBoolean(value) || value.equals("1") || value.equals("1.0") || value.equals("t"));
    }

    @Override
    public double hashDouble(int idx) {
        return this.get(idx) != false ? 1.0 : 0.0;
    }

    @Override
    public ArrayCompressionStatistics statistics(int nSamples) {
        return null;
    }

    @Override
    public boolean equals(Array<Boolean> other) {
        if (other instanceof BooleanArray) {
            return Arrays.equals(this._data, ((BooleanArray)other)._data);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this._size * 2 + 10);
        sb.append(super.toString() + ":[");
        for (int i = 0; i < this._size - 1; ++i) {
            sb.append((this._data[i] ? 1 : 0) + ",");
        }
        sb.append(this._data[this._size - 1] ? 1 : 0);
        sb.append("]");
        return sb.toString();
    }
}

