/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.sysds.conf.ConfigurationManager;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.iterators.IteratorFactory;
import org.apache.sysds.runtime.frame.data.iterators.RowIterator;
import org.apache.sysds.runtime.io.IOUtilFunctions;
import org.apache.sysds.runtime.util.HDFSTool;
import org.apache.wink.json4j.JSONException;
import org.apache.wink.json4j.JSONObject;

public class FrameWriterJSONL {
    public void writeFrameToHDFS(FrameBlock src, String fname, Map<String, Integer> schemaMap, long rlen, long clen) throws IOException, DMLRuntimeException, JSONException {
        JobConf job = new JobConf((Configuration)ConfigurationManager.getCachedJobConf());
        Path path = new Path(fname);
        HDFSTool.deleteFileIfExistOnHDFS(fname);
        if ((long)src.getNumRows() != rlen || (long)src.getNumColumns() != clen) {
            throw new IOException("Frame dimensions mismatch with metadata: " + src.getNumRows() + "x" + src.getNumColumns() + " vs " + rlen + "x" + clen + ".");
        }
        this.writeJSONLFrameToHDFS(path, job, src, rlen, clen, schemaMap);
    }

    protected void writeJSONLFrameToHDFS(Path path, JobConf jobConf, FrameBlock src, long rlen, long clen, Map<String, Integer> schemaMap) throws IOException, JSONException {
        FileSystem fileSystem = IOUtilFunctions.getFileSystem(path, (Configuration)jobConf);
        this.writeJSONLFrameToFile(path, fileSystem, src, 0, (int)rlen, schemaMap);
        IOUtilFunctions.deleteCrcFilesFromLocalFileSystem(fileSystem, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeJSONLFrameToFile(Path path, FileSystem fileSystem, FrameBlock src, int lowerRowBound, int upperRowBound, Map<String, Integer> schemaMap) throws IOException, JSONException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)fileSystem.create(path, true)));
        try {
            RowIterator<String> stringRowIterator = IteratorFactory.getStringRowIterator(src, lowerRowBound, upperRowBound);
            while (stringRowIterator.hasNext()) {
                String[] row = (String[])stringRowIterator.next();
                bufferedWriter.write(this.formatToJSONString(row, schemaMap) + "\n");
            }
        }
        finally {
            IOUtilFunctions.closeSilently(bufferedWriter);
        }
    }

    protected String formatToJSONString(String[] values, Map<String, Integer> schemaMap) throws IOException, JSONException {
        if (schemaMap.size() != values.length) {
            throw new IOException("Schema Map and row mismatch. Cannot map " + values.length + " values to " + schemaMap.size() + " JSON Objects");
        }
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<String, Integer> entry : schemaMap.entrySet()) {
            String[] splits = entry.getKey().split("/");
            Integer value = entry.getValue();
            this.gernerateJSONObjectFromPath(splits, 1, values[value], jsonObject);
        }
        return jsonObject.toString();
    }

    protected JSONObject gernerateJSONObjectFromPath(String[] path, int index, Object value, JSONObject jsonObject) throws JSONException {
        JSONObject temp = new JSONObject();
        if (index == path.length - 1) {
            if (jsonObject != null) {
                jsonObject.put(path[index], value);
                return jsonObject;
            }
            temp.put(path[index], value);
            return temp;
        }
        JSONObject newJsonObject = jsonObject == null ? null : jsonObject.optJSONObject(path[index]);
        JSONObject ret = this.gernerateJSONObjectFromPath(path, index + 1, value, newJsonObject);
        if (newJsonObject == null && jsonObject != null) {
            jsonObject.put(path[index], ret);
            return null;
        }
        if (ret == null) {
            return null;
        }
        temp.put(path[index], ret);
        return temp;
    }
}

