/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.instructions.spark;

import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysds.runtime.functionobjects.COV;
import org.apache.sysds.runtime.instructions.InstructionUtils;
import org.apache.sysds.runtime.instructions.cp.CM_COV_Object;
import org.apache.sysds.runtime.instructions.cp.CPOperand;
import org.apache.sysds.runtime.instructions.cp.Data;
import org.apache.sysds.runtime.instructions.cp.DoubleObject;
import org.apache.sysds.runtime.instructions.spark.BinarySPInstruction;
import org.apache.sysds.runtime.instructions.spark.SPInstruction;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.matrix.data.MatrixIndexes;
import org.apache.sysds.runtime.matrix.operators.COVOperator;
import scala.Tuple2;

public class CovarianceSPInstruction
extends BinarySPInstruction {
    private CovarianceSPInstruction(COVOperator op, CPOperand in, CPOperand in2, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.Covariance, op, in, in2, out, opcode, istr);
    }

    private CovarianceSPInstruction(COVOperator op, CPOperand in, CPOperand in2, CPOperand in3, CPOperand out, String opcode, String istr) {
        super(SPInstruction.SPType.Covariance, op, in, in2, out, opcode, istr);
    }

    public static CovarianceSPInstruction parseInstruction(String str) {
        CPOperand in1 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in2 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        CPOperand in3 = null;
        CPOperand out = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        String opcode = parts[0];
        if (!opcode.equalsIgnoreCase("cov")) {
            throw new DMLRuntimeException("CovarianceCPInstruction.parseInstruction():: Unknown opcode " + opcode);
        }
        COVOperator cov = new COVOperator(COV.getCOMFnObject());
        if (parts.length == 4) {
            CovarianceSPInstruction.parseBinaryInstruction(str, in1, in2, out);
            return new CovarianceSPInstruction(cov, in1, in2, out, opcode, str);
        }
        if (parts.length == 5) {
            in3 = new CPOperand("", Types.ValueType.UNKNOWN, Types.DataType.UNKNOWN);
            CovarianceSPInstruction.parseBinaryInstruction(str, in1, in2, in3, out);
            return new CovarianceSPInstruction(cov, in1, in2, in3, out, opcode, str);
        }
        throw new DMLRuntimeException("Invalid number of arguments in Instruction: " + str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        COVOperator cop = (COVOperator)this._optr;
        JavaPairRDD<MatrixIndexes, MatrixBlock> in1 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input1.getName());
        JavaPairRDD<MatrixIndexes, MatrixBlock> in2 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input2.getName());
        CM_COV_Object cmobj = null;
        if (this.input3 == null) {
            cmobj = in1.join(in2).values().map(new RDDCOVFunction(cop)).fold(new CM_COV_Object(), new RDDCOVReduceFunction(cop));
        } else {
            JavaPairRDD<MatrixIndexes, MatrixBlock> in3 = sec.getBinaryMatrixBlockRDDHandleForVariable(this.input3.getName());
            cmobj = in1.join(in2).join(in3).values().map(new RDDCOVWeightsFunction(cop)).fold(new CM_COV_Object(), new RDDCOVReduceFunction(cop));
        }
        double val = cmobj.getRequiredResult(this._optr);
        ec.setScalarOutput(this.output.getName(), new DoubleObject(val));
    }

    private static class RDDCOVReduceFunction
    implements Function2<CM_COV_Object, CM_COV_Object, CM_COV_Object> {
        private static final long serialVersionUID = 1118102911706607118L;
        private COVOperator _op = null;

        public RDDCOVReduceFunction(COVOperator op) {
            this._op = op;
        }

        public CM_COV_Object call(CM_COV_Object arg0, CM_COV_Object arg1) throws Exception {
            this._op.fn.execute((Data)arg0, arg1);
            return arg0;
        }
    }

    private static class RDDCOVWeightsFunction
    implements Function<Tuple2<Tuple2<MatrixBlock, MatrixBlock>, MatrixBlock>, CM_COV_Object> {
        private static final long serialVersionUID = 1945166819152577077L;
        private COVOperator _op = null;

        public RDDCOVWeightsFunction(COVOperator op) {
            this._op = op;
        }

        public CM_COV_Object call(Tuple2<Tuple2<MatrixBlock, MatrixBlock>, MatrixBlock> arg0) throws Exception {
            MatrixBlock input1 = (MatrixBlock)((Tuple2)arg0._1())._1();
            MatrixBlock input2 = (MatrixBlock)((Tuple2)arg0._1())._2();
            MatrixBlock weights = (MatrixBlock)arg0._2();
            return input1.covOperations(this._op, input2, weights);
        }
    }

    private static class RDDCOVFunction
    implements Function<Tuple2<MatrixBlock, MatrixBlock>, CM_COV_Object> {
        private static final long serialVersionUID = -9088449969750217519L;
        private COVOperator _op = null;

        public RDDCOVFunction(COVOperator op) {
            this._op = op;
        }

        public CM_COV_Object call(Tuple2<MatrixBlock, MatrixBlock> arg0) throws Exception {
            MatrixBlock input1 = (MatrixBlock)arg0._1();
            MatrixBlock input2 = (MatrixBlock)arg0._2();
            return input1.covOperations(this._op, input2);
        }
    }
}

