/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.corelib.mixins;

import java.util.Collections;
import java.util.List;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.InjectContainer;
import org.apache.tapestry5.annotations.MixinAfter;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.RequestParameter;
import org.apache.tapestry5.internal.AbstractEventContext;
import org.apache.tapestry5.internal.util.Holder;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.compatibility.DeprecationWarning;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;

@MixinAfter
public class Autocomplete {
    static final String EVENT_NAME = "autocomplete";
    @InjectContainer
    private Field field;
    @Inject
    private ComponentResources resources;
    @Environmental
    private JavaScriptSupport jsSupport;
    @Inject
    private TypeCoercer coercer;
    @Parameter(defaultPrefix="literal")
    private int minChars = 1;
    @Parameter(defaultPrefix="literal")
    private double frequency;
    @Parameter(defaultPrefix="literal")
    private String tokens;
    @Parameter(value="5")
    private int maxSuggestions;
    @Parameter
    private Object[] context;
    @Inject
    private DeprecationWarning deprecationWarning;

    void pageLoaded() {
        this.deprecationWarning.ignoredComponentParameters(this.resources, "frequency", "tokens");
    }

    void beginRender(MarkupWriter writer) {
        writer.attributes(EVENT_NAME, "off");
    }

    @Import(stylesheet={"typeahead-bootstrap3.css"})
    void afterRender() {
        Link link = this.resources.createEventLink(EVENT_NAME, this.context);
        JSONObject spec = new JSONObject(new Object[]{"id", this.field.getClientId(), "url", link.toString()}).put("minChars", (Object)this.minChars).put("limit", (Object)this.maxSuggestions);
        this.jsSupport.require("t5/core/autocomplete").with(spec);
    }

    Object onAutocomplete(final EventContext context, final @RequestParameter(value="t:input") String input) {
        final Holder matchesHolder = Holder.create();
        matchesHolder.put(Collections.emptyList());
        ComponentEventCallback callback = new ComponentEventCallback(){

            public boolean handleResult(Object result) {
                List matches = (List)Autocomplete.this.coercer.coerce(result, List.class);
                matchesHolder.put(matches);
                return true;
            }
        };
        AbstractEventContext newContext = new AbstractEventContext(){

            @Override
            public int getCount() {
                return context.getCount() + 1;
            }

            @Override
            public <T> T get(Class<T> desiredType, int index) {
                if (index == 0) {
                    return (T)Autocomplete.this.coercer.coerce((Object)input, desiredType);
                }
                return context.get(desiredType, index - 1);
            }
        };
        this.resources.triggerContextEvent("provideCompletions", newContext, callback);
        JSONObject reply = new JSONObject();
        reply.put("matches", (Object)JSONArray.from((Iterable)((Iterable)matchesHolder.get())));
        return reply;
    }
}

