/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.gzip;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tapestry5.internal.gzip.GZIPEnabledResponse;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.services.HttpServletRequestFilter;
import org.apache.tapestry5.services.HttpServletRequestHandler;
import org.apache.tapestry5.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.services.assets.CompressionAnalyzer;

public class GZipFilter
implements HttpServletRequestFilter {
    private final int cutover;
    private final ResponseCompressionAnalyzer responseAnalyzer;
    private final CompressionAnalyzer compressionAnalyzer;

    public GZipFilter(@Symbol(value="tapestry.min-gzip-size") int cutover, ResponseCompressionAnalyzer responseAnalyzer, CompressionAnalyzer compressionAnalyzer) {
        this.cutover = cutover;
        this.responseAnalyzer = responseAnalyzer;
        this.compressionAnalyzer = compressionAnalyzer;
    }

    @Override
    public boolean service(HttpServletRequest request, HttpServletResponse response, HttpServletRequestHandler handler) throws IOException {
        Object newResponse = this.responseAnalyzer.isGZipSupported() ? new GZIPEnabledResponse(response, request, this.cutover, this.compressionAnalyzer) : response;
        return handler.service(request, (HttpServletResponse)newResponse);
    }
}

