/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Locale;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldTranslator;
import org.apache.tapestry5.Translator;
import org.apache.tapestry5.beaneditor.Translate;
import org.apache.tapestry5.internal.services.FieldTranslatorImpl;
import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.MessageFormatter;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.services.FieldTranslatorSource;
import org.apache.tapestry5.services.FormSupport;
import org.apache.tapestry5.services.TranslatorSource;

public class FieldTranslatorSourceImpl
implements FieldTranslatorSource {
    private final TranslatorSource translatorSource;
    private final Messages globalMessages;
    private final FormSupport formSupport;

    public FieldTranslatorSourceImpl(TranslatorSource translatorSource, Messages globalMessages, FormSupport formSupport) {
        this.translatorSource = translatorSource;
        this.globalMessages = globalMessages;
        this.formSupport = formSupport;
    }

    @Override
    public FieldTranslator createDefaultTranslator(ComponentResources resources, String parameterName) {
        assert (resources != null);
        assert (InternalUtils.isNonBlank((String)parameterName));
        Field field = (Field)((Object)resources.getComponent());
        Class propertyType = resources.getBoundType(parameterName);
        return this.createDefaultTranslator(field, resources.getId(), resources.getContainerMessages(), null, propertyType, resources.getAnnotationProvider(parameterName));
    }

    @Override
    public FieldTranslator createDefaultTranslator(Field field, String overrideId, Messages overrideMessages, Locale locale, Class propertyType, AnnotationProvider propertyAnnotations) {
        assert (field != null);
        assert (overrideMessages != null);
        assert (InternalUtils.isNonBlank((String)overrideId));
        if (propertyType == null) {
            return null;
        }
        Translator translator = this.findTranslator(propertyType, propertyAnnotations);
        if (translator == null) {
            return null;
        }
        return this.createTranslator(field, overrideId, overrideMessages, locale, translator);
    }

    Translator findTranslator(Class propertyType, AnnotationProvider propertyAnnotations) {
        Translate annotation = (Translate)propertyAnnotations.getAnnotation(Translate.class);
        if (annotation != null) {
            return this.translatorSource.get(annotation.value());
        }
        if (propertyType == null) {
            return null;
        }
        return this.translatorSource.findByType(propertyType);
    }

    @Override
    public FieldTranslator createTranslator(Field field, String overrideId, Messages overrideMessages, Locale locale, Translator translator) {
        MessageFormatter formatter = this.findFormatter(overrideId, overrideMessages, translator);
        return new FieldTranslatorImpl(field, translator, formatter, this.formSupport);
    }

    @Override
    public FieldTranslator createTranslator(ComponentResources resources, String translatorName) {
        assert (resources != null);
        assert (InternalUtils.isNonBlank((String)translatorName));
        Field field = (Field)((Object)resources.getComponent());
        Translator translator = this.translatorSource.get(translatorName);
        return this.createTranslator(field, resources.getId(), resources.getContainerMessages(), null, translator);
    }

    private MessageFormatter findFormatter(String overrideId, Messages overrideMessages, Translator translator) {
        String translatorName = translator.getName();
        String overrideKey = this.formSupport.getFormValidationId() + "-" + overrideId + "-" + translatorName + "-message";
        if (overrideMessages.contains(overrideKey)) {
            return overrideMessages.getFormatter(overrideKey);
        }
        overrideKey = overrideId + "-" + translatorName + "-message";
        if (overrideMessages.contains(overrideKey)) {
            return overrideMessages.getFormatter(overrideKey);
        }
        String messageKey = translator.getMessageKey();
        if (messageKey == null) {
            messageKey = translatorName + "-message";
        }
        return this.globalMessages.getFormatter(messageKey);
    }
}

