/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import org.apache.tapestry5.Field;
import org.apache.tapestry5.FieldValidator;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.ValidationException;
import org.apache.tapestry5.Validator;
import org.apache.tapestry5.ioc.MessageFormatter;
import org.apache.tapestry5.services.FormSupport;

public class FieldValidatorImpl
implements FieldValidator {
    private final Field field;
    private final Object constraintValue;
    private final MessageFormatter messageFormatter;
    private final Validator validator;
    private final FormSupport formSupport;

    public FieldValidatorImpl(Field field, Object constraintValue, MessageFormatter messageFormatter, Validator validator, FormSupport formSupport) {
        this.field = field;
        this.constraintValue = constraintValue;
        this.messageFormatter = messageFormatter;
        this.validator = validator;
        this.formSupport = formSupport;
    }

    public void validate(Object value) throws ValidationException {
        if (!this.validator.isRequired() && this.isBlank(value)) {
            return;
        }
        if (value != null && !this.validator.getValueType().isInstance(value)) {
            return;
        }
        this.validator.validate(this.field, this.constraintValue, this.messageFormatter, value);
    }

    @Override
    public void render(MarkupWriter writer) {
        this.validator.render(this.field, this.constraintValue, this.messageFormatter, writer, this.formSupport);
    }

    @Override
    public boolean isRequired() {
        return this.validator.isRequired();
    }

    private boolean isBlank(Object value) {
        return value == null || value.equals("");
    }
}

