/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.List;
import org.apache.tapestry5.alerts.AlertManager;
import org.apache.tapestry5.internal.services.ReloadHelper;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;

public class ReloadHelperImpl
implements ReloadHelper {
    private final AlertManager alertManager;
    private final boolean productionMode;
    private final List<Runnable> callbacks = CollectionFactory.newThreadSafeList();

    public ReloadHelperImpl(AlertManager alertManager, @Symbol(value="tapestry.production-mode") boolean productionMode) {
        this.alertManager = alertManager;
        this.productionMode = productionMode;
    }

    @Override
    public void forceReload() {
        if (this.productionMode) {
            this.alertManager.error("Can not force a reload in production mode.");
            return;
        }
        for (Runnable c : this.callbacks) {
            c.run();
        }
        this.alertManager.info("Component classes, templates, and messages reloaded.");
    }

    @Override
    public void addReloadCallback(Runnable callback) {
        assert (callback != null);
        this.callbacks.add(callback);
    }
}

