/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.Collection;
import java.util.List;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.BindParameter;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.services.ComponentClassCache;
import org.apache.tapestry5.internal.transform.ParameterConduit;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.services.TypeCoercer;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.ExceptionUtils;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.model.EmbeddedComponentModel;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ComputedValue;
import org.apache.tapestry5.plastic.FieldConduit;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class BindParameterWorker
implements ComponentClassTransformWorker2 {
    private final TypeCoercer typeCoercer;
    private final ComponentClassCache componentClassCache;

    public BindParameterWorker(TypeCoercer typeCoercer, ComponentClassCache componentClassCache) {
        this.typeCoercer = typeCoercer;
        this.componentClassCache = componentClassCache;
    }

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        for (PlasticField field : plasticClass.getFieldsWithAnnotation(BindParameter.class)) {
            this.convertFieldIntoContainerBoundParameter(field);
        }
    }

    private void convertFieldIntoContainerBoundParameter(PlasticField field) {
        BindParameter annotation = (BindParameter)field.getAnnotation(BindParameter.class);
        field.claim((Object)annotation);
        final String[] possibleNames = annotation.value();
        final String fieldTypeName = field.getTypeName();
        final String fieldName = field.getName();
        ComputedValue<FieldConduit<Object>> computedConduit = new ComputedValue<FieldConduit<Object>>(){

            public FieldConduit<Object> get(InstanceContext context) {
                ComponentResources resources = (ComponentResources)context.get(ComponentResources.class);
                try {
                    return BindParameterWorker.this.createConduit(resources, fieldTypeName, fieldName, possibleNames);
                }
                catch (Exception ex) {
                    throw new TapestryException(String.format("Failure binding parameter field '%s' of mixin %s (type %s): %s", fieldName, resources.getCompleteId(), resources.getComponentModel().getComponentClassName(), ExceptionUtils.toMessage((Throwable)ex)), (Throwable)ex);
                }
            }
        };
        field.setComputedConduit((ComputedValue)computedConduit);
    }

    private FieldConduit<Object> createConduit(ComponentResources resources, String fieldTypeName, String fieldName, String[] possibleNames) {
        if (!resources.isMixin()) {
            throw new TapestryException(String.format("@BindParameter was used on field '%s' of component class '%s', but @BindParameter should only be used in mixins.", fieldName, resources.getComponentModel().getComponentClassName()), null);
        }
        InternalComponentResources containerResources = (InternalComponentResources)resources.getContainerResources();
        String containerParameterName = this.identifyParameterName(resources, InternalUtils.stripMemberName((String)fieldName), possibleNames);
        Class fieldType = this.componentClassCache.forName(fieldTypeName);
        return new BoundParameterFieldValueConduit(containerParameterName, containerResources, fieldType);
    }

    private String identifyParameterName(ComponentResources resources, String firstGuess, String ... otherGuesses) {
        ComponentModel model = resources.getContainerResources().getComponentModel();
        List guesses = CollectionFactory.newList();
        guesses.add(firstGuess);
        for (String name : otherGuesses) {
            guesses.add(name);
        }
        for (String name : guesses) {
            if (model.isFormalParameter(name)) {
                return name;
            }
            if (!this.isPublishedParameter(model, name)) continue;
            return name;
        }
        String message = String.format("Containing component %s does not contain a formal parameter or a published parameter %s %s.", model.getComponentClassName(), guesses.size() == 1 ? "matching" : "matching any of", InternalUtils.joinSorted((Collection)guesses));
        List formalAndPublishedParameters = CollectionFactory.newList(model.getParameterNames());
        formalAndPublishedParameters.addAll(this.getPublishedParameters(model));
        throw new UnknownValueException(message, new AvailableValues("Formal and published parameters", (Collection)formalAndPublishedParameters));
    }

    private boolean isPublishedParameter(ComponentModel model, String parameterName) {
        for (String embeddedComponentId : model.getEmbeddedComponentIds()) {
            EmbeddedComponentModel embeddedComponentModel = model.getEmbeddedComponentModel(embeddedComponentId);
            if (!embeddedComponentModel.getPublishedParameters().contains(parameterName)) continue;
            return true;
        }
        return false;
    }

    private List<String> getPublishedParameters(ComponentModel model) {
        List publishedParameters = CollectionFactory.newList();
        for (String embeddedComponentId : model.getEmbeddedComponentIds()) {
            EmbeddedComponentModel embeddedComponentModel = model.getEmbeddedComponentModel(embeddedComponentId);
            publishedParameters.addAll(embeddedComponentModel.getPublishedParameters());
        }
        return publishedParameters;
    }

    private InternalComponentResources getEmbeddedComponentResourcesForPublishedParameter(InternalComponentResources containerResources, String publishedParameterName) {
        List embeddedComponentResourcesList = CollectionFactory.newList();
        embeddedComponentResourcesList.add(containerResources);
        while (!embeddedComponentResourcesList.isEmpty()) {
            InternalComponentResources resources = (InternalComponentResources)embeddedComponentResourcesList.remove(0);
            ComponentModel containerComponentModel = resources.getComponentModel();
            for (String embeddedComponentId : containerComponentModel.getEmbeddedComponentIds()) {
                EmbeddedComponentModel embeddedComponentModel = containerComponentModel.getEmbeddedComponentModel(embeddedComponentId);
                InternalComponentResources embeddedComponentResources = (InternalComponentResources)resources.getEmbeddedComponent(embeddedComponentId).getComponentResources();
                if (embeddedComponentModel.getPublishedParameters().contains(publishedParameterName) && embeddedComponentResources.getComponentModel().isFormalParameter(publishedParameterName)) {
                    return embeddedComponentResources;
                }
                embeddedComponentResourcesList.add(embeddedComponentResources);
            }
        }
        return null;
    }

    private final class BoundParameterFieldValueConduit
    implements FieldConduit<Object> {
        private final String containerParameterName;
        private final InternalComponentResources containerResources;
        private final Class fieldType;
        private ParameterConduit conduit;

        private BoundParameterFieldValueConduit(String containerParameterName, InternalComponentResources containerResources, Class fieldType) {
            this.containerParameterName = containerParameterName;
            this.containerResources = containerResources;
            this.fieldType = fieldType;
        }

        private synchronized ParameterConduit getParameterConduit() {
            if (this.conduit == null) {
                this.conduit = this.containerResources.getComponentModel().isFormalParameter(this.containerParameterName) ? this.containerResources.getParameterConduit(this.containerParameterName) : BindParameterWorker.this.getEmbeddedComponentResourcesForPublishedParameter(this.containerResources, this.containerParameterName).getParameterConduit(this.containerParameterName);
            }
            return this.conduit;
        }

        public Object get(Object instance, InstanceContext context) {
            Object result = this.getParameterConduit().get(instance, context);
            return BindParameterWorker.this.typeCoercer.coerce(result, this.fieldType);
        }

        public void set(Object instance, InstanceContext context, Object newValue) {
            this.getParameterConduit().set(instance, context, newValue);
        }
    }
}

