/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.modules;

import java.util.List;
import java.util.Map;
import org.apache.tapestry5.SymbolConstants;
import org.apache.tapestry5.internal.services.AssetSourceImpl;
import org.apache.tapestry5.internal.services.ClasspathAssetAliasManagerImpl;
import org.apache.tapestry5.internal.services.ClasspathAssetFactory;
import org.apache.tapestry5.internal.services.ContextAssetFactory;
import org.apache.tapestry5.internal.services.ExternalUrlAssetFactory;
import org.apache.tapestry5.internal.services.IdentityAssetPathConverter;
import org.apache.tapestry5.internal.services.ResourceStreamer;
import org.apache.tapestry5.internal.services.assets.AssetChecksumGeneratorImpl;
import org.apache.tapestry5.internal.services.assets.AssetPathConstructorImpl;
import org.apache.tapestry5.internal.services.assets.CSSURLRewriter;
import org.apache.tapestry5.internal.services.assets.ClasspathAssetRequestHandler;
import org.apache.tapestry5.internal.services.assets.CompressionAnalyzerImpl;
import org.apache.tapestry5.internal.services.assets.ContentTypeAnalyzerImpl;
import org.apache.tapestry5.internal.services.assets.ContextAssetRequestHandler;
import org.apache.tapestry5.internal.services.assets.JavaScriptStackAssembler;
import org.apache.tapestry5.internal.services.assets.JavaScriptStackAssemblerImpl;
import org.apache.tapestry5.internal.services.assets.JavaScriptStackMinimizeDisabler;
import org.apache.tapestry5.internal.services.assets.MasterResourceMinimizer;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTrackerImpl;
import org.apache.tapestry5.internal.services.assets.SRSCachingInterceptor;
import org.apache.tapestry5.internal.services.assets.SRSCompressedCachingInterceptor;
import org.apache.tapestry5.internal.services.assets.SRSCompressingInterceptor;
import org.apache.tapestry5.internal.services.assets.SRSMinimizingInterceptor;
import org.apache.tapestry5.internal.services.assets.StackAssetRequestHandler;
import org.apache.tapestry5.internal.services.assets.StreamableResourceSourceImpl;
import org.apache.tapestry5.internal.services.assets.UTF8ForTextAssets;
import org.apache.tapestry5.internal.services.messages.ClientLocalizationMessageResource;
import org.apache.tapestry5.ioc.MappedConfiguration;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.OrderedConfiguration;
import org.apache.tapestry5.ioc.Resource;
import org.apache.tapestry5.ioc.ServiceBinder;
import org.apache.tapestry5.ioc.annotations.Autobuild;
import org.apache.tapestry5.ioc.annotations.Contribute;
import org.apache.tapestry5.ioc.annotations.Decorate;
import org.apache.tapestry5.ioc.annotations.Marker;
import org.apache.tapestry5.ioc.annotations.Order;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.services.ChainBuilder;
import org.apache.tapestry5.ioc.services.FactoryDefaults;
import org.apache.tapestry5.ioc.services.SymbolProvider;
import org.apache.tapestry5.services.ApplicationGlobals;
import org.apache.tapestry5.services.AssetFactory;
import org.apache.tapestry5.services.AssetPathConverter;
import org.apache.tapestry5.services.AssetRequestDispatcher;
import org.apache.tapestry5.services.AssetSource;
import org.apache.tapestry5.services.ClasspathAssetAliasManager;
import org.apache.tapestry5.services.ClasspathAssetProtectionRule;
import org.apache.tapestry5.services.ClasspathProvider;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ContextProvider;
import org.apache.tapestry5.services.Core;
import org.apache.tapestry5.services.Dispatcher;
import org.apache.tapestry5.services.Request;
import org.apache.tapestry5.services.ResponseCompressionAnalyzer;
import org.apache.tapestry5.services.assets.AssetChecksumGenerator;
import org.apache.tapestry5.services.assets.AssetPathConstructor;
import org.apache.tapestry5.services.assets.AssetRequestHandler;
import org.apache.tapestry5.services.assets.CompressionAnalyzer;
import org.apache.tapestry5.services.assets.ContentTypeAnalyzer;
import org.apache.tapestry5.services.assets.ResourceMinimizer;
import org.apache.tapestry5.services.assets.StreamableResourceSource;
import org.apache.tapestry5.services.javascript.JavaScriptStackSource;
import org.apache.tapestry5.services.messages.ComponentMessagesSource;

@Marker(value={Core.class})
public class AssetsModule {
    public static void bind(ServiceBinder binder) {
        binder.bind(AssetFactory.class, ClasspathAssetFactory.class).withSimpleId();
        binder.bind(AssetPathConverter.class, IdentityAssetPathConverter.class);
        binder.bind(AssetPathConstructor.class, AssetPathConstructorImpl.class);
        binder.bind(ClasspathAssetAliasManager.class, ClasspathAssetAliasManagerImpl.class);
        binder.bind(AssetSource.class, AssetSourceImpl.class);
        binder.bind(StreamableResourceSource.class, StreamableResourceSourceImpl.class);
        binder.bind(CompressionAnalyzer.class, CompressionAnalyzerImpl.class);
        binder.bind(ContentTypeAnalyzer.class, ContentTypeAnalyzerImpl.class);
        binder.bind(ResourceChangeTracker.class, ResourceChangeTrackerImpl.class);
        binder.bind(ResourceMinimizer.class, MasterResourceMinimizer.class);
        binder.bind(AssetChecksumGenerator.class, AssetChecksumGeneratorImpl.class);
        binder.bind(JavaScriptStackAssembler.class, JavaScriptStackAssemblerImpl.class);
    }

    @Contribute(value=AssetSource.class)
    public void configureStandardAssetFactories(MappedConfiguration<String, AssetFactory> configuration, @ContextProvider AssetFactory contextAssetFactory, @ClasspathProvider AssetFactory classpathAssetFactory) {
        configuration.add((Object)"context", (Object)contextAssetFactory);
        configuration.add((Object)"classpath", (Object)classpathAssetFactory);
        configuration.add((Object)"http", (Object)new ExternalUrlAssetFactory("http"));
        configuration.add((Object)"https", (Object)new ExternalUrlAssetFactory("https"));
        configuration.add((Object)"ftp", (Object)new ExternalUrlAssetFactory("ftp"));
        configuration.add((Object)"//", (Object)new ExternalUrlAssetFactory("//"));
    }

    @Contribute(value=SymbolProvider.class)
    @FactoryDefaults
    public static void setupSymbols(MappedConfiguration<String, Object> configuration) {
        configuration.add((Object)"tapestry.enable-minification", (Object)SymbolConstants.PRODUCTION_MODE_VALUE);
        configuration.add((Object)"tapestry.gzip-compression-enabled", (Object)true);
        configuration.add((Object)"tapestry.combine-scripts", (Object)SymbolConstants.PRODUCTION_MODE_VALUE);
        configuration.add((Object)"tapestry.asset-url-fully-qualified", (Object)false);
        configuration.add((Object)"tapestry.asset-path-prefix", (Object)"assets");
        configuration.add((Object)"tapestry.bootstrap-root", (Object)"${tapestry.asset.root}/bootstrap");
        configuration.add((Object)"tapestry.font-awesome-root", (Object)"${tapestry.asset.root}/font_awesome");
        configuration.add((Object)"tapestry.asset.root", (Object)"classpath:META-INF/assets/tapestry5");
        configuration.add((Object)"tapestry.omit-expiration-cache-control-header", (Object)"max-age=60,must-revalidate");
    }

    @Decorate(id="GZipCompression", serviceInterface=StreamableResourceSource.class)
    public StreamableResourceSource enableCompression(StreamableResourceSource delegate, @Symbol(value="tapestry.gzip-compression-enabled") boolean gzipEnabled, @Symbol(value="tapestry.min-gzip-size") int compressionCutoff, AssetChecksumGenerator checksumGenerator) {
        return gzipEnabled ? new SRSCompressingInterceptor(delegate, compressionCutoff, checksumGenerator) : null;
    }

    @Decorate(id="CacheCompressed", serviceInterface=StreamableResourceSource.class)
    @Order(value={"before:GZIpCompression"})
    public StreamableResourceSource enableCompressedCaching(StreamableResourceSource delegate, @Symbol(value="tapestry.gzip-compression-enabled") boolean gzipEnabled, ResourceChangeTracker tracker) {
        return gzipEnabled ? new SRSCompressedCachingInterceptor(delegate, tracker) : null;
    }

    @Decorate(id="Cache", serviceInterface=StreamableResourceSource.class)
    @Order(value={"after:GZipCompression"})
    public StreamableResourceSource enableUncompressedCaching(StreamableResourceSource delegate, ResourceChangeTracker tracker) {
        return new SRSCachingInterceptor(delegate, tracker);
    }

    @Decorate(id="Minification", serviceInterface=StreamableResourceSource.class)
    @Order(value={"after:Cache,TextUTF8"})
    public StreamableResourceSource enableMinification(StreamableResourceSource delegate, ResourceMinimizer minimizer, @Symbol(value="tapestry.enable-minification") boolean enabled) {
        return enabled ? new SRSMinimizingInterceptor(delegate, minimizer) : null;
    }

    @Decorate(id="CSSURLRewrite", serviceInterface=StreamableResourceSource.class)
    @Order(value={"after:Minification"})
    public StreamableResourceSource enableCSSURLRewriting(StreamableResourceSource delegate, OperationTracker tracker, AssetSource assetSource, AssetChecksumGenerator checksumGenerator, @Symbol(value="tapestry.strict-css-url-rewriting") boolean strictCssUrlRewriting) {
        return new CSSURLRewriter(delegate, tracker, assetSource, checksumGenerator, strictCssUrlRewriting);
    }

    @Decorate(id="DisableMinificationForStacks", serviceInterface=StreamableResourceSource.class)
    @Order(value={"before:Minification"})
    public StreamableResourceSource setupDisableMinificationByJavaScriptStack(StreamableResourceSource delegate, @Symbol(value="tapestry.enable-minification") boolean enabled, JavaScriptStackSource javaScriptStackSource, Request request) {
        return enabled ? new JavaScriptStackMinimizeDisabler(delegate, javaScriptStackSource, request) : null;
    }

    @Decorate(id="TextUTF8", serviceInterface=StreamableResourceSource.class)
    @Order(value={"after:Cache"})
    public StreamableResourceSource setupTextAssetsAsUTF8(StreamableResourceSource delegate) {
        return new UTF8ForTextAssets(delegate);
    }

    @Contribute(value=ContentTypeAnalyzer.class)
    public void setupDefaultContentTypeMappings(MappedConfiguration<String, String> configuration) {
        configuration.add((Object)"css", (Object)"text/css");
        configuration.add((Object)"js", (Object)"text/javascript");
        configuration.add((Object)"gif", (Object)"image/gif");
        configuration.add((Object)"jpg", (Object)"image/jpeg");
        configuration.add((Object)"jpeg", (Object)"image/jpeg");
        configuration.add((Object)"png", (Object)"image/png");
        configuration.add((Object)"swf", (Object)"application/x-shockwave-flash");
        configuration.add((Object)"svg", (Object)"image/svg+xml");
        configuration.add((Object)"woff", (Object)"application/font-woff");
        configuration.add((Object)"ttf", (Object)"application/x-font-ttf");
        configuration.add((Object)"eot", (Object)"application/vnd.ms-fontobject");
    }

    @Contribute(value=CompressionAnalyzer.class)
    public void disableCompressionForImageTypes(MappedConfiguration<String, Boolean> configuration) {
        configuration.add((Object)"image/*", (Object)false);
        configuration.add((Object)"image/svg+xml", (Object)true);
        configuration.add((Object)"application/x-shockwave-flash", (Object)false);
        configuration.add((Object)"application/font-woff", (Object)false);
        configuration.add((Object)"application/x-font-ttf", (Object)false);
        configuration.add((Object)"application/vnd.ms-fontobject", (Object)false);
    }

    @Marker(value={ContextProvider.class})
    public static AssetFactory buildContextAssetFactory(ApplicationGlobals globals, AssetPathConstructor assetPathConstructor, ResponseCompressionAnalyzer compressionAnalyzer, ResourceChangeTracker resourceChangeTracker, StreamableResourceSource streamableResourceSource) {
        return new ContextAssetFactory(compressionAnalyzer, resourceChangeTracker, streamableResourceSource, assetPathConstructor, globals.getContext());
    }

    @Contribute(value=ClasspathAssetAliasManager.class)
    public static void addApplicationAndTapestryMappings(MappedConfiguration<String, String> configuration, @Symbol(value="tapestry.app-package") String appPackage) {
        configuration.add((Object)"tapestry", (Object)"org/apache/tapestry5");
        configuration.add((Object)"app", (Object)AssetsModule.toPackagePath(appPackage));
    }

    @Contribute(value=Dispatcher.class)
    @AssetRequestDispatcher
    public static void provideBuiltinAssetDispatchers(MappedConfiguration<String, AssetRequestHandler> configuration, @ContextProvider AssetFactory contextAssetFactory, @Autobuild StackAssetRequestHandler stackAssetRequestHandler, ClasspathAssetAliasManager classpathAssetAliasManager, ResourceStreamer streamer, AssetSource assetSource, ClasspathAssetProtectionRule classpathAssetProtectionRule) {
        Map<String, String> mappings = classpathAssetAliasManager.getMappings();
        for (String folder : mappings.keySet()) {
            String path = mappings.get(folder);
            configuration.add((Object)folder, (Object)new ClasspathAssetRequestHandler(streamer, assetSource, path, classpathAssetProtectionRule));
        }
        configuration.add((Object)"ctx", (Object)new ContextAssetRequestHandler(streamer, contextAssetFactory.getRootResource()));
        configuration.add((Object)"stack", (Object)stackAssetRequestHandler);
    }

    @Contribute(value=ClasspathAssetAliasManager.class)
    public static void addMappingsForLibraryVirtualFolders(MappedConfiguration<String, String> configuration, ComponentClassResolver resolver) {
        Map<String, String> folderToPackageMapping = resolver.getFolderToPackageMapping();
        for (String folder : folderToPackageMapping.keySet()) {
            configuration.add((Object)folder, (Object)AssetsModule.toPackagePath(folderToPackageMapping.get(folder)));
            String folderSuffix = folder.equals("") ? folder : "/" + folder;
            configuration.add((Object)("meta" + folderSuffix), (Object)("META-INF/assets" + folderSuffix));
        }
    }

    private static String toPackagePath(String packageName) {
        return packageName.replace('.', '/');
    }

    @Contribute(value=ComponentMessagesSource.class)
    public static void setupGlobalMessageCatalog(AssetSource assetSource, @Symbol(value="tapestry.app-catalog") Resource applicationCatalog, OrderedConfiguration<Resource> configuration) {
        configuration.add("ClientLocalization", (Object)new ClientLocalizationMessageResource(), new String[0]);
        configuration.add("Core", (Object)assetSource.resourceForPath("org/apache/tapestry5/core.properties"), new String[0]);
        configuration.add("AppCatalog", (Object)applicationCatalog, new String[0]);
    }

    @Contribute(value=Dispatcher.class)
    @Primary
    public static void setupAssetDispatch(OrderedConfiguration<Dispatcher> configuration, @AssetRequestDispatcher Dispatcher assetDispatcher) {
        configuration.add("Asset", (Object)assetDispatcher, new String[]{"before:ComponentEvent"});
    }

    @Primary
    public static ClasspathAssetProtectionRule buildClasspathAssetProtectionRule(List<ClasspathAssetProtectionRule> rules, ChainBuilder chainBuilder) {
        return (ClasspathAssetProtectionRule)chainBuilder.build(ClasspathAssetProtectionRule.class, rules);
    }

    public static void contributeClasspathAssetProtectionRule(OrderedConfiguration<ClasspathAssetProtectionRule> configuration) {
        ClasspathAssetProtectionRule classFileRule = s -> s.toLowerCase().endsWith(".class");
        configuration.add("ClassFile", (Object)classFileRule, new String[0]);
        ClasspathAssetProtectionRule propertiesFileRule = s -> s.toLowerCase().endsWith(".properties");
        configuration.add("PropertiesFile", (Object)propertiesFileRule, new String[0]);
        ClasspathAssetProtectionRule xmlFileRule = s -> s.toLowerCase().endsWith(".xml");
        configuration.add("XMLFile", (Object)xmlFileRule, new String[0]);
        ClasspathAssetProtectionRule folderRule = s -> AssetsModule.isFolderToBlock(s);
        configuration.add("Folder", (Object)folderRule, new String[0]);
    }

    private static final boolean isFolderToBlock(String path) {
        int lastIndex = (path = path.replace('\\', '/')).lastIndexOf(47);
        if (lastIndex >= 0) {
            path = path.substring(lastIndex);
        }
        return !path.contains(".");
    }
}

