/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.internal.EagerLoadServiceProxy;
import org.apache.tapestry5.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry5.ioc.internal.services.ServiceMessages;
import org.apache.tapestry5.ioc.services.Status;

public class JustInTimeObjectCreator<T>
implements ObjectCreator<T>,
EagerLoadServiceProxy,
Runnable {
    private final ServiceActivityTracker tracker;
    private ObjectCreator<T> creator;
    private volatile T object;
    private final String serviceId;

    public JustInTimeObjectCreator(ServiceActivityTracker tracker, ObjectCreator<T> creator, String serviceId) {
        this.tracker = tracker;
        this.creator = creator;
        this.serviceId = serviceId;
    }

    public T createObject() {
        if (this.object == null) {
            this.obtainObjectFromCreator();
        }
        return this.object;
    }

    private synchronized void obtainObjectFromCreator() {
        if (this.object != null) {
            return;
        }
        try {
            this.object = this.creator.createObject();
            this.tracker.setStatus(this.serviceId, Status.REAL);
            this.creator = null;
        }
        catch (RuntimeException ex) {
            throw new RuntimeException(ServiceMessages.serviceBuildFailure((String)this.serviceId, (Throwable)ex), ex);
        }
    }

    @Override
    public void eagerLoadService() {
        this.createObject();
    }

    @Override
    public synchronized void run() {
        this.creator = new ObjectCreator<T>(){

            public T createObject() {
                throw new IllegalStateException(ServiceMessages.registryShutdown((String)JustInTimeObjectCreator.this.serviceId));
            }
        };
        this.object = null;
    }
}

