/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.jpa;

import java.io.Serializable;
import javax.persistence.EntityManager;
import org.apache.tapestry5.http.annotations.ImmutableSessionPersistedObject;
import org.apache.tapestry5.jpa.EntityManagerManager;

@ImmutableSessionPersistedObject
public class PersistedEntity
implements Serializable {
    private static final long serialVersionUID = 897120520279686518L;
    private final Class entityClass;
    private final Object id;
    private final String persistenceUnitName;

    public PersistedEntity(Class entityClass, Object id, String persistenceUnitName) {
        this.entityClass = entityClass;
        this.id = id;
        this.persistenceUnitName = persistenceUnitName;
    }

    public Object restore(EntityManagerManager entityManagerManager) {
        try {
            EntityManager entityManager = entityManagerManager.getEntityManager(this.persistenceUnitName);
            return entityManager.find(this.entityClass, this.id);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed to load session-persisted entity %s(%s): %s", this.entityClass.getName(), this.id, ex));
        }
    }

    public String toString() {
        return String.format("<PersistedEntity: %s(%s)>", this.entityClass.getName(), this.id);
    }
}

