/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.io.stream;

import org.apache.sis.io.TableAppender;
import org.apache.sis.util.internal.Numerics;

public final class Region {
    final int[] targetSize;
    final long startAt;
    private final long[] skips;
    private long[] skipBytes;
    public final long length;

    public Region(long[] size, long[] regionLower, long[] regionUpper, int[] subsampling) {
        int dimension = size.length;
        this.targetSize = new int[dimension];
        this.skips = new long[dimension + 1];
        long position = 0L;
        long stride = 1L;
        long skip = 0L;
        int i = 0;
        while (i < dimension) {
            int step = subsampling[i];
            long lower = regionLower[i];
            long count = Numerics.ceilDiv(Math.subtractExact(regionUpper[i], lower), (long)step);
            long upper = Math.addExact(lower, Math.incrementExact(Math.multiplyExact(count - 1L, step)));
            long span = size[i];
            assert (count > 0L && lower >= 0L && upper > lower && upper <= span) : i;
            this.targetSize[i] = Math.toIntExact(count);
            position = Math.addExact(position, Math.multiplyExact(stride, lower));
            skip = Math.addExact(skip, Math.multiplyExact(stride, span - (upper - lower)));
            this.skips[i] = Math.addExact(this.skips[i], Math.multiplyExact(stride, step - 1));
            stride = Math.multiplyExact(stride, span);
            this.skips[++i] = skip;
        }
        this.startAt = position;
        this.length = stride;
    }

    public void setAdditionalByteOffset(int dimension, long skip) {
        if (this.skipBytes == null) {
            this.skipBytes = new long[this.getDimension()];
        }
        this.skipBytes[dimension] = skip;
    }

    public final int getDimension() {
        return this.targetSize.length;
    }

    final int contiguousDataDimension() {
        int i;
        int dimension = this.skips.length - 1;
        for (i = 0; i < dimension && this.skips[i] == 0L; ++i) {
        }
        if (this.skipBytes != null) {
            int n = Math.min(i, this.skipBytes.length);
            for (int j = 0; j < n; ++j) {
                if (this.skipBytes[j] == 0L) continue;
                return j;
            }
        }
        return i;
    }

    final long offset(long sampleSize) {
        if (this.skipBytes != null) {
            sampleSize = Math.addExact(sampleSize, this.skipBytes[0]);
        }
        return Math.multiplyExact(this.startAt, sampleSize);
    }

    final long stride(int dimension, int base, int sampleSize) {
        long stride = Math.multiplyExact(Math.addExact(this.skips[dimension], (long)base), sampleSize);
        if (this.skipBytes != null) {
            stride = Math.addExact(stride, this.skipBytes[dimension]);
        }
        return stride;
    }

    final int targetLength(int dimension) {
        long size = 1L;
        for (int i = 0; i < dimension; ++i) {
            size *= (long)this.targetSize[i];
        }
        return Math.toIntExact(size);
    }

    public final int getTargetSize(int dimension) {
        return this.targetSize[dimension];
    }

    public String toString() {
        TableAppender table = new TableAppender(" ");
        table.setCellAlignment((byte)1);
        table.append("size").nextColumn();
        table.append("skip").nextLine();
        for (int i = 0; i < this.targetSize.length; ++i) {
            table.append(String.valueOf(this.targetSize[i])).nextColumn();
            table.append(String.valueOf(this.skips[i])).nextLine();
        }
        return table.toString();
    }
}

