/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.citation;

import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.citation.AbstractParty;
import org.apache.sis.util.iso.Types;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.citation.Contact;
import org.opengis.util.InternationalString;

@XmlType(name="CI_Individual_Type", propOrder={"positionName"})
@XmlRootElement(name="CI_Individual")
@UML(identifier="CI_Individual", specification=Specification.ISO_19115)
public class DefaultIndividual
extends AbstractParty {
    private static final long serialVersionUID = -5116802681895278739L;
    private InternationalString positionName;

    public DefaultIndividual() {
    }

    public DefaultIndividual(CharSequence name, CharSequence positionName, Contact contactInfo) {
        super(name, contactInfo);
        this.positionName = Types.toInternationalString(positionName);
    }

    public DefaultIndividual(DefaultIndividual object) {
        super(object);
        if (object != null) {
            this.positionName = object.getPositionName();
        }
    }

    @XmlElement(name="positionName")
    @UML(identifier="positionName", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public InternationalString getPositionName() {
        return this.positionName;
    }

    public void setPositionName(InternationalString newValue) {
        this.checkWritePermission(this.positionName);
        this.positionName = newValue;
    }
}

