/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.retries;

import java.util.function.Predicate;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.retries.internal.DefaultLegacyRetryStrategy;
import software.amazon.awssdk.retries.internal.circuitbreaker.TokenBucketStore;

@SdkPublicApi
@ThreadSafe
public interface LegacyRetryStrategy
extends RetryStrategy {
    public static Builder builder() {
        return DefaultLegacyRetryStrategy.builder().maxAttempts(4).tokenBucketStore(TokenBucketStore.builder().tokenBucketMaxCapacity(500).build()).tokenBucketExceptionCost(5).tokenBucketThrottlingExceptionCost(0);
    }

    public Builder toBuilder();

    public static interface Builder
    extends RetryStrategy.Builder<Builder, LegacyRetryStrategy> {
        public Builder throttlingBackoffStrategy(BackoffStrategy var1);

        public Builder circuitBreakerEnabled(Boolean var1);

        public Builder treatAsThrottling(Predicate<Throwable> var1);

        public LegacyRetryStrategy build();
    }
}

