/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.remote;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.script.Bindings;
import org.apache.tinkerpop.gremlin.jsr223.GremlinLangScriptEngine;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnection;
import org.apache.tinkerpop.gremlin.process.remote.RemoteConnectionException;
import org.apache.tinkerpop.gremlin.process.remote.traversal.EmbeddedRemoteTraversal;
import org.apache.tinkerpop.gremlin.process.remote.traversal.RemoteTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.GremlinLang;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversalSource;

public class EmbeddedRemoteConnection
implements RemoteConnection {
    private final GremlinLangScriptEngine scriptEngine = new GremlinLangScriptEngine();
    private final GraphTraversalSource g;

    public EmbeddedRemoteConnection(GraphTraversalSource g) {
        this.g = g;
    }

    @Override
    public <E> CompletableFuture<RemoteTraversal<?, E>> submitAsync(GremlinLang gremlinLang) throws RemoteConnectionException {
        CompletableFuture promise = new CompletableFuture();
        try {
            Bindings b = this.scriptEngine.createBindings();
            b.putAll((Map<? extends String, ? extends Object>)gremlinLang.getParameters());
            b.put("g", (Object)this.g);
            promise.complete(new EmbeddedRemoteTraversal((Traversal)this.scriptEngine.eval(gremlinLang.getGremlin(), b)));
        }
        catch (Exception t) {
            promise.completeExceptionally(t);
        }
        return promise;
    }

    @Override
    public void close() throws Exception {
        this.g.close();
    }
}

