/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.branch;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.TraversalParent;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.ComputerAwareStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.TraversalUtil;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public final class RepeatStep<S>
extends ComputerAwareStep<S, S>
implements TraversalParent {
    private Traversal.Admin<S, S> repeatTraversal = null;
    private Traversal.Admin<S, ?> untilTraversal = null;
    private Traversal.Admin<S, ?> emitTraversal = null;
    private String loopName = null;
    public boolean untilFirst = false;
    public boolean emitFirst = false;

    public RepeatStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        Set<TraverserRequirement> requirements = this.getSelfAndChildRequirements(TraverserRequirement.BULK);
        if (requirements.contains((Object)TraverserRequirement.SINGLE_LOOP)) {
            requirements.add(TraverserRequirement.NESTED_LOOP);
        }
        requirements.add(TraverserRequirement.SINGLE_LOOP);
        return requirements;
    }

    public void setRepeatTraversal(Traversal.Admin<S, S> repeatTraversal) {
        if (null != this.repeatTraversal) {
            throw new IllegalStateException("The repeat()-step already has its loop section declared: " + this);
        }
        this.repeatTraversal = repeatTraversal;
        this.repeatTraversal.addStep(new RepeatEndStep(this.repeatTraversal));
        this.integrateChild(this.repeatTraversal);
    }

    public void setLoopName(String loopName) {
        this.loopName = loopName;
    }

    public String getLoopName() {
        return this.loopName;
    }

    public void setUntilTraversal(Traversal.Admin<S, ?> untilTraversal) {
        if (null != this.untilTraversal) {
            throw new IllegalStateException("The repeat()-step already has its until()-modulator declared: " + this);
        }
        if (null == this.repeatTraversal) {
            this.untilFirst = true;
        }
        this.untilTraversal = this.integrateChild(untilTraversal);
    }

    public Traversal.Admin<S, ?> getUntilTraversal() {
        return this.untilTraversal;
    }

    public void setEmitTraversal(Traversal.Admin<S, ?> emitTraversal) {
        if (null != this.emitTraversal) {
            throw new IllegalStateException("The repeat()-step already has its emit()-modulator declared: " + this);
        }
        if (null == this.repeatTraversal) {
            this.emitFirst = true;
        }
        this.emitTraversal = this.integrateChild(emitTraversal);
    }

    public Traversal.Admin<S, ?> getEmitTraversal() {
        return this.emitTraversal;
    }

    public Traversal.Admin<S, S> getRepeatTraversal() {
        return this.repeatTraversal;
    }

    public List<Traversal.Admin<S, S>> getGlobalChildren() {
        return null == this.repeatTraversal ? Collections.emptyList() : Collections.singletonList(this.repeatTraversal);
    }

    public List<Traversal.Admin<S, ?>> getLocalChildren() {
        ArrayList list = new ArrayList(2);
        if (null != this.untilTraversal) {
            list.add(this.untilTraversal);
        }
        if (null != this.emitTraversal) {
            list.add(this.emitTraversal);
        }
        return list;
    }

    public final boolean doUntil(Traverser.Admin<S> traverser, boolean utilFirst) {
        return utilFirst == this.untilFirst && null != this.untilTraversal && TraversalUtil.test(traverser, this.untilTraversal);
    }

    public final boolean doEmit(Traverser.Admin<S> traverser, boolean emitFirst) {
        return emitFirst == this.emitFirst && null != this.emitTraversal && TraversalUtil.test(traverser, this.emitTraversal);
    }

    @Override
    public String toString() {
        if (this.untilFirst && this.emitFirst) {
            return StringFactory.stepString(this, this.untilString(), this.emitString(), this.repeatTraversal);
        }
        if (this.emitFirst) {
            return StringFactory.stepString(this, this.emitString(), this.repeatTraversal, this.untilString());
        }
        if (this.untilFirst) {
            return StringFactory.stepString(this, this.untilString(), this.repeatTraversal, this.emitString());
        }
        return StringFactory.stepString(this, this.repeatTraversal, this.untilString(), this.emitString());
    }

    @Override
    public void reset() {
        super.reset();
        if (null != this.emitTraversal) {
            this.emitTraversal.reset();
        }
        if (null != this.untilTraversal) {
            this.untilTraversal.reset();
        }
        if (null != this.repeatTraversal) {
            this.repeatTraversal.reset();
        }
    }

    private final String untilString() {
        return null == this.untilTraversal ? "until(false)" : "until(" + this.untilTraversal + ')';
    }

    private final String emitString() {
        return null == this.emitTraversal ? "emit(false)" : "emit(" + this.emitTraversal + ')';
    }

    @Override
    public RepeatStep<S> clone() {
        RepeatStep clone = (RepeatStep)super.clone();
        clone.repeatTraversal = this.repeatTraversal.clone();
        if (null != this.untilTraversal) {
            clone.untilTraversal = this.untilTraversal.clone();
        }
        if (null != this.emitTraversal) {
            clone.emitTraversal = this.emitTraversal.clone();
        }
        return clone;
    }

    @Override
    public void setTraversal(Traversal.Admin<?, ?> parentTraversal) {
        super.setTraversal(parentTraversal);
        this.integrateChild(this.repeatTraversal);
        this.integrateChild(this.untilTraversal);
        this.integrateChild(this.emitTraversal);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result ^= Boolean.hashCode(this.untilFirst);
        result ^= Boolean.hashCode(this.emitFirst) << 1;
        if (this.repeatTraversal != null) {
            result ^= this.repeatTraversal.hashCode();
        }
        if (this.loopName != null) {
            result ^= this.loopName.hashCode();
        }
        if (this.untilTraversal != null) {
            result ^= this.untilTraversal.hashCode();
        }
        if (this.emitTraversal != null) {
            result ^= this.emitTraversal.hashCode();
        }
        return result;
    }

    @Override
    protected Iterator<Traverser.Admin<S>> standardAlgorithm() throws NoSuchElementException {
        Object start;
        if (null == this.repeatTraversal) {
            throw new IllegalStateException("The repeat()-traversal was not defined: " + this);
        }
        do {
            if (this.repeatTraversal.getEndStep().hasNext()) {
                return this.repeatTraversal.getEndStep();
            }
            start = this.starts.next();
            start.initialiseLoops(this.getId(), this.loopName);
            if (this.doUntil((Traverser.Admin<S>)start, true)) {
                start.resetLoops();
                return IteratorUtils.of(start);
            }
            this.repeatTraversal.addStart((Traverser.Admin<S>)start);
        } while (!this.doEmit((Traverser.Admin<S>)start, true));
        Traverser.Admin emitSplit = start.split();
        emitSplit.resetLoops();
        return IteratorUtils.of(emitSplit);
    }

    @Override
    protected Iterator<Traverser.Admin<S>> computerAlgorithm() throws NoSuchElementException {
        if (null == this.repeatTraversal) {
            throw new IllegalStateException("The repeat()-traversal was not defined: " + this);
        }
        Object start = this.starts.next();
        if (this.doUntil((Traverser.Admin<S>)start, true)) {
            start.setStepId(this.getNextStep().getId());
            start.addLabels(this.labels);
            return IteratorUtils.of(start);
        }
        start.setStepId(this.repeatTraversal.getStartStep().getId());
        start.initialiseLoops(start.getStepId(), this.loopName);
        if (this.doEmit((Traverser.Admin<S>)start, true)) {
            Traverser.Admin emitSplit = start.split();
            emitSplit.resetLoops();
            emitSplit.setStepId(this.getNextStep().getId());
            return IteratorUtils.of(start, emitSplit);
        }
        return IteratorUtils.of(start);
    }

    public static <A, B, C extends Traversal<A, B>> C addRepeatToTraversal(C traversal, Traversal.Admin<B, B> repeatTraversal) {
        Step<?, B> step = traversal.asAdmin().getEndStep();
        if (step instanceof RepeatStep && null == ((RepeatStep)step).repeatTraversal) {
            ((RepeatStep)step).setRepeatTraversal(repeatTraversal);
        } else {
            RepeatStep<B> repeatStep = new RepeatStep<B>(traversal.asAdmin());
            repeatStep.setRepeatTraversal(repeatTraversal);
            traversal.asAdmin().addStep(repeatStep);
        }
        return traversal;
    }

    public static <A, B, C extends Traversal<A, B>> C addRepeatToTraversal(C traversal, String loopName, Traversal.Admin<B, B> repeatTraversal) {
        RepeatStep.addRepeatToTraversal(traversal, repeatTraversal);
        Step<?, B> step = traversal.asAdmin().getEndStep();
        ((RepeatStep)step).loopName = loopName;
        return traversal;
    }

    public static <A, B, C extends Traversal<A, B>> C addUntilToTraversal(C traversal, Traversal.Admin<B, ?> untilPredicate) {
        Step<?, B> step = traversal.asAdmin().getEndStep();
        if (step instanceof RepeatStep && null == ((RepeatStep)step).untilTraversal) {
            ((RepeatStep)step).setUntilTraversal(untilPredicate);
        } else {
            RepeatStep<B> repeatStep = new RepeatStep<B>(traversal.asAdmin());
            repeatStep.setUntilTraversal(untilPredicate);
            traversal.asAdmin().addStep(repeatStep);
        }
        return traversal;
    }

    public static <A, B, C extends Traversal<A, B>> C addEmitToTraversal(C traversal, Traversal.Admin<B, ?> emitPredicate) {
        Step<?, B> step = traversal.asAdmin().getEndStep();
        if (step instanceof RepeatStep && null == ((RepeatStep)step).emitTraversal) {
            ((RepeatStep)step).setEmitTraversal(emitPredicate);
        } else {
            RepeatStep<B> repeatStep = new RepeatStep<B>(traversal.asAdmin());
            repeatStep.setEmitTraversal(emitPredicate);
            traversal.asAdmin().addStep(repeatStep);
        }
        return traversal;
    }

    public static class RepeatEndStep<S>
    extends ComputerAwareStep<S, S> {
        public RepeatEndStep(Traversal.Admin traversal) {
            super(traversal);
        }

        @Override
        protected Iterator<Traverser.Admin<S>> standardAlgorithm() throws NoSuchElementException {
            Object start;
            RepeatStep repeatStep = (RepeatStep)this.getTraversal().getParent();
            do {
                start = this.starts.next();
                start.incrLoops();
                if (repeatStep.doUntil(start, false)) {
                    start.resetLoops();
                    return IteratorUtils.of(start);
                }
                if (!repeatStep.untilFirst && !repeatStep.emitFirst) {
                    repeatStep.repeatTraversal.addStart(start);
                    continue;
                }
                repeatStep.addStart(start);
            } while (!repeatStep.doEmit(start, false));
            Traverser.Admin emitSplit = start.split();
            emitSplit.resetLoops();
            return IteratorUtils.of(emitSplit);
        }

        @Override
        protected Iterator<Traverser.Admin<S>> computerAlgorithm() throws NoSuchElementException {
            RepeatStep repeatStep = (RepeatStep)this.getTraversal().getParent();
            Object start = this.starts.next();
            start.incrLoops();
            if (repeatStep.doUntil(start, false)) {
                start.resetLoops();
                start.setStepId(repeatStep.getNextStep().getId());
                start.addLabels(repeatStep.labels);
                return IteratorUtils.of(start);
            }
            start.setStepId(repeatStep.getId());
            if (repeatStep.doEmit(start, false)) {
                Traverser.Admin emitSplit = start.split();
                emitSplit.resetLoops();
                emitSplit.setStepId(repeatStep.getNextStep().getId());
                emitSplit.addLabels(repeatStep.labels);
                return IteratorUtils.of(start, emitSplit);
            }
            return IteratorUtils.of(start);
        }
    }
}

