/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import java.util.concurrent.Callable;
import javax.naming.NamingException;
import org.apache.openejb.core.ivm.naming.Reference;

public class LazyObjectReference<T>
extends Reference {
    private final Callable<T> creator;
    private volatile T instance;

    public LazyObjectReference(Callable<T> creator) {
        this.creator = creator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject() throws NamingException {
        if (this.instance == null) {
            LazyObjectReference lazyObjectReference = this;
            synchronized (lazyObjectReference) {
                if (this.instance == null) {
                    try {
                        this.instance = this.creator.call();
                    }
                    catch (Exception e) {
                        throw new LazyNamingException(e.getMessage());
                    }
                }
            }
        }
        return this.instance;
    }

    public boolean isInitialized() {
        return this.instance != null;
    }

    public static final class LazyNamingException
    extends NamingException {
        private LazyNamingException(String message) {
            super(message);
        }
    }
}

