/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.learner.trabal;

import org.apache.uima.ruta.textruler.learner.trabal.ConditionType;
import org.apache.uima.ruta.textruler.learner.trabal.TrabalRuleItem;

public class Condition {
    private ConditionType type;
    private TrabalRuleItem item;
    private boolean isNegative = false;
    private boolean isExpansionCondition = false;

    public Condition(ConditionType type, TrabalRuleItem item) {
        this.type = type;
        this.item = item;
    }

    public Condition(ConditionType type, TrabalRuleItem item, boolean isNegative, boolean isExpansionCondition) {
        this.type = type;
        this.item = item;
        this.isNegative = isNegative;
        this.isExpansionCondition = isExpansionCondition;
    }

    public ConditionType getType() {
        return this.type;
    }

    public TrabalRuleItem getItem() {
        return this.item;
    }

    public boolean isNegative() {
        return this.isNegative;
    }

    public void setNegative() {
        this.isNegative = true;
    }

    public void setPositive() {
        this.isNegative = false;
    }

    public void changePosNegValue() {
        this.isNegative = !this.isNegative;
    }

    public boolean isExpansionCondition() {
        return this.isExpansionCondition;
    }

    public void setExpansionCondition() {
        this.isExpansionCondition = true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Condition other = (Condition)obj;
        if (this.type != other.getType()) {
            return false;
        }
        if (!this.item.getName().equals(other.getItem().getName())) {
            return false;
        }
        return this.isNegative == other.isNegative;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        if (this.isNegative) {
            return "-" + this.type.getConditionString(this.item.toString());
        }
        return this.type.getConditionString(this.item.toString());
    }

    public Condition clone() {
        Condition result = new Condition(this.type, this.item, this.isNegative, this.isExpansionCondition);
        return result;
    }
}

