/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.File;
import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.FileUtils;

public class AnnotationWriter
extends JCasAnnotator_ImplBase {
    private static final String OUTPUT = "Output";
    private static final String ENCODING = "Encoding";
    private static final String TYPE = "Type";
    private UimaContext context;
    private String output;
    private String type;
    private String encoding;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        if (aContext == null && this.context != null) {
            aContext = this.context;
        }
        this.output = (String)aContext.getConfigParameterValue(OUTPUT);
        this.type = (String)aContext.getConfigParameterValue(TYPE);
        this.encoding = (String)aContext.getConfigParameterValue(ENCODING);
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        FSIterator sdiit;
        CAS cas = jcas.getCas();
        Type targetType = cas.getTypeSystem().getType(this.type);
        FSIterator iterator = cas.getAnnotationIndex(targetType).iterator();
        StringBuilder newDocument = new StringBuilder();
        while (iterator.isValid()) {
            AnnotationFS fs = (AnnotationFS)iterator.get();
            newDocument.append(fs.getCoveredText());
            newDocument.append("\n");
            iterator.moveToNext();
        }
        Type sdiType = cas.getTypeSystem().getType("org.apache.uima.examples.SourceDocumentInformation");
        String filename = "output.txt";
        File file = new File(this.output, filename);
        if (sdiType != null && (sdiit = cas.getAnnotationIndex(sdiType).iterator()).isValid()) {
            Feature uriFeature;
            AnnotationFS annotationFS = (AnnotationFS)sdiit.get();
            String stringValue = annotationFS.getStringValue(uriFeature = sdiType.getFeatureByBaseName("uri"));
            File f = new File(stringValue);
            String name = f.getName();
            if (!name.endsWith(".txt")) {
                name = name + ".txt";
            }
            file = new File(f.getParent() + this.output, name);
        }
        try {
            FileUtils.saveString2File((String)newDocument.toString(), (File)file, (String)this.encoding);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

