/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.documentation;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class RutaPageFolder {
    private String path;
    private HashMap pages = new HashMap();

    public RutaPageFolder(String path) {
        this.path = path;
    }

    public void addPage(String keyword, String file) {
        this.pages.put(keyword, file);
    }

    public boolean verify() {
        if (this.path == null) {
            return false;
        }
        File file = new File(this.path);
        return file.exists() && file.isDirectory();
    }

    public String getPath() {
        return this.path;
    }

    public HashMap getPages() {
        return this.pages;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RutaPageFolder)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RutaPageFolder f = (RutaPageFolder)obj;
        if (!f.path.equals(this.path)) {
            return false;
        }
        return f.pages.equals(this.pages);
    }

    public static List readXML(String data) throws IOException {
        Element config = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(data.getBytes());){
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            parser.setErrorHandler(new DefaultHandler());
            config = parser.parse(new InputSource(stream)).getDocumentElement();
        }
        if (!config.getNodeName().equalsIgnoreCase("manPages")) {
            throw new RuntimeException("Bad top level node");
        }
        ArrayList<RutaPageFolder> folders = new ArrayList<RutaPageFolder>();
        NodeList list = config.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = list.item(i);
            short type = node.getNodeType();
            if (type != 1 || !node.getNodeName().equalsIgnoreCase("location")) continue;
            Element location = (Element)node;
            String path = location.getAttribute("path");
            RutaPageFolder folder = new RutaPageFolder(path);
            NodeList locationChilds = location.getChildNodes();
            int pages = locationChilds.getLength();
            for (int j = 0; j < pages; ++j) {
                node = locationChilds.item(j);
                type = node.getNodeType();
                if (type != 1 || !node.getNodeName().equalsIgnoreCase("page")) continue;
                Element word = (Element)node;
                String kw = word.getAttribute("keyword");
                String file = word.getAttribute("file");
                folder.addPage(kw, file);
            }
            folders.add(folder);
        }
        return folders;
    }
}

