/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.uima.ruta.ide.ui.text;

import org.eclipse.dltk.ui.text.DLTKColorConstants;

public final class RutaColorConstants {

  private RutaColorConstants() {
  }

  public static final String RUTA_STRING = DLTKColorConstants.DLTK_STRING;

  public static final String RUTA_SINGLE_LINE_COMMENT = DLTKColorConstants.DLTK_SINGLE_LINE_COMMENT;

  public static final String RUTA_DOC_COMMENT = DLTKColorConstants.DLTK_DOC;

  public static final String RUTA_NUMBER = DLTKColorConstants.DLTK_NUMBER;

  public static final String RUTA_KEYWORD = DLTKColorConstants.DLTK_KEYWORD;

  public static final String RUTA_KEYWORD_RETURN = DLTKColorConstants.DLTK_KEYWORD_RETURN;

  public static final String RUTA_DEFAULT = DLTKColorConstants.DLTK_DEFAULT;

  public static final String RUTA_CONDITION = "ruta_condition"; //$NON-NLS-1$

  public static final String RUTA_ACTION = "ruta_action"; //$NON-NLS-1$

  public static final String RUTA_RULE = "ruta_rule";

  public static final String RUTA_THEN = "ruta_then";

  public static final String RUTA_DECLARATION = "ruta_declaration";

  public static final String RUTA_BASICSYMBOL = "ruta_basicSymbol";

  public static final String RUTA_FUNCTION = "ruta_function";

  public static final String RUTA_VARIABLE = "ruta_variable"; //$NON-NLS-1$

  public static final String RUTA_TODO_TAG = DLTKColorConstants.TASK_TAG; // DLTKColorConstants.TASK_TAG;
}
