/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationListExpression;
import org.apache.uima.ruta.expression.feature.FeatureExpression;
import org.apache.uima.ruta.expression.feature.SimpleFeatureExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class RutaExpression
extends RutaElement
implements IRutaExpression {
    protected List<AnnotationFS> getTargetAnnotation(AnnotationFS matchedAnnotation, FeatureExpression fe, MatchContext context, RutaStream stream) {
        if (fe instanceof SimpleFeatureExpression) {
            SimpleFeatureExpression sfe = (SimpleFeatureExpression)fe;
            IAnnotationExpression annotationExpression = sfe.getMatchReference().getAnnotationExpression(context, stream);
            IAnnotationListExpression annotationListExpression = sfe.getMatchReference().getAnnotationListExpression(context, stream);
            if (annotationExpression != null) {
                return Arrays.asList(annotationExpression.getAnnotation(context, stream));
            }
            if (annotationListExpression != null) {
                return annotationListExpression.getAnnotationList(context, stream);
            }
        }
        if (matchedAnnotation == null) {
            return Collections.emptyList();
        }
        Type type = fe.getInitialType(context, stream);
        AnnotationFS documentAnnotation = stream.getCas().getDocumentAnnotation();
        Type docType = documentAnnotation.getType();
        if (docType.equals(type)) {
            AnnotationFS windowAnnotation = stream.getFilter().getWindowAnnotation();
            if (windowAnnotation == null) {
                return Arrays.asList(documentAnnotation);
            }
            return Arrays.asList(windowAnnotation);
        }
        return stream.getBestGuessedAnnotationsAt(matchedAnnotation, type);
    }
}

