/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.analysis_engine.impl.compatibility;

import java.io.IOException;
import java.util.HashMap;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.AnalysisComponent;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.impl.AnalysisEngineDescription_impl;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;

public class CollectionReaderAdapter
implements AnalysisComponent {
    private CollectionReader mCollectionReader;
    private TypeSystem mLastTypeSystem;
    private UimaContext mUimaContext;
    private boolean mSofaAware;
    private boolean mProcessCalled;

    public CollectionReaderAdapter(CollectionReader aCollectionReader, AnalysisEngineMetaData aMetaData) {
        this.mCollectionReader = aCollectionReader;
        this.mSofaAware = aMetaData.isSofaAware();
        this.mProcessCalled = false;
    }

    @Override
    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        AnalysisEngineDescription_impl desc = new AnalysisEngineDescription_impl();
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        paramsMap.put("UIMA_CONTEXT", aContext);
        this.mCollectionReader.initialize(desc, paramsMap);
        this.mUimaContext = aContext;
    }

    public void checkTypeSystemChange(AbstractCas aCAS) throws AnalysisEngineProcessException {
        try {
            TypeSystem typeSystem = aCAS instanceof JCas ? ((JCas)aCAS).getTypeSystem() : ((CAS)aCAS).getTypeSystem();
            if (typeSystem != this.mLastTypeSystem) {
                this.mCollectionReader.typeSystemInit(typeSystem);
                this.mLastTypeSystem = typeSystem;
            }
        }
        catch (ResourceInitializationException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public void process(AbstractCas aCAS) throws AnalysisEngineProcessException {
        if (this.mProcessCalled) {
            try {
                this.reconfigure();
            }
            catch (ResourceInitializationException e) {
                throw new AnalysisEngineProcessException(e);
            }
            catch (ResourceConfigurationException e) {
                throw new AnalysisEngineProcessException(e);
            }
        } else {
            this.mProcessCalled = true;
        }
    }

    @Override
    public void batchProcessComplete() throws AnalysisEngineProcessException {
    }

    @Override
    public void collectionProcessComplete() throws AnalysisEngineProcessException {
    }

    @Override
    public void destroy() {
        this.mCollectionReader.destroy();
    }

    @Override
    public void reconfigure() throws ResourceInitializationException, ResourceConfigurationException {
        this.mCollectionReader.reconfigure();
    }

    @Override
    public boolean hasNext() throws AnalysisEngineProcessException {
        try {
            return this.mCollectionReader.hasNext();
        }
        catch (CollectionException e) {
            throw new AnalysisEngineProcessException(e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException(e);
        }
    }

    @Override
    public AbstractCas next() throws AnalysisEngineProcessException {
        CAS cas = this.mUimaContext.getEmptyCas(CAS.class);
        this.checkTypeSystemChange(cas);
        CAS view = ((CASImpl)cas).getBaseCAS();
        if (!this.mSofaAware) {
            view = cas.getView("_InitialView");
        }
        try {
            this.mCollectionReader.getNext(view);
        }
        catch (CollectionException e) {
            throw new AnalysisEngineProcessException(e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException(e);
        }
        return cas;
    }

    public void next(AbstractCas aEmptyCas) throws AnalysisEngineProcessException {
        if (!CAS.class.isAssignableFrom(aEmptyCas.getClass())) {
            throw new AnalysisEngineProcessException("incorrect_cas_interface", new Object[]{CAS.class, aEmptyCas.getClass()});
        }
    }

    @Override
    public Class<? extends AbstractCas> getRequiredCasInterface() {
        return AbstractCas.class;
    }

    @Override
    public int getCasInstancesRequired() {
        return 1;
    }

    @Override
    public void setResultSpecification(ResultSpecification aResultSpec) {
    }
}

