/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.uima.UimaSerializable;
import org.apache.uima.cas.AbstractCas;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.CommonArrayFS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.impl.AllFSs;
import org.apache.uima.cas.impl.AllowPreexistingFS;
import org.apache.uima.cas.impl.BinaryCasSerDes;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.CasCompare;
import org.apache.uima.cas.impl.CasSeqAddrMaps;
import org.apache.uima.cas.impl.CasTypeSystemMapper;
import org.apache.uima.cas.impl.CommonSerDes;
import org.apache.uima.cas.impl.FSsTobeAddedback;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FeatureStructureImplC;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.SlotKinds;
import org.apache.uima.cas.impl.SlotKindsConstants;
import org.apache.uima.cas.impl.StringHeap;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeImpl_array;
import org.apache.uima.cas.impl.TypeImpl_string;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.Int2ObjHashMap;
import org.apache.uima.internal.util.IntListIterator;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.Misc;
import org.apache.uima.internal.util.PositiveIntSet;
import org.apache.uima.internal.util.PositiveIntSet_impl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.BooleanArray;
import org.apache.uima.jcas.cas.ByteArray;
import org.apache.uima.jcas.cas.DoubleArray;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.IntegerArray;
import org.apache.uima.jcas.cas.LongArray;
import org.apache.uima.jcas.cas.ShortArray;
import org.apache.uima.jcas.cas.Sofa;
import org.apache.uima.jcas.cas.StringArray;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.AutoCloseableNoException;
import org.apache.uima.util.CasIOUtils;
import org.apache.uima.util.CasLoadMode;
import org.apache.uima.util.impl.DataIO;
import org.apache.uima.util.impl.OptimizeStrings;
import org.apache.uima.util.impl.SerializationMeasures;

public class BinaryCasSerDes6
implements SlotKindsConstants {
    private static final String EMPTY_STRING = "";
    private static final boolean TRACE_SER = false;
    private static final boolean TRACE_DES = false;
    private static final boolean TRACE_MOD_SER = false;
    private static final boolean TRACE_MOD_DES = false;
    private static final boolean TRACE_STR_ARRAY = false;
    private TypeSystemImpl srcTs;
    private final TypeSystemImpl tgtTs;
    private final CompressLevel compressLevel;
    private final CompressStrat compressStrategy;
    private final CASImpl cas;
    private final BinaryCasSerDes bcsd;
    private final StringHeap stringHeapObj;
    private int nextFsId;
    private final boolean isSerializingDelta;
    private boolean isDelta;
    private boolean isReadingDelta;
    private final MarkerImpl mark;
    private final CasSeqAddrMaps fsStartIndexes;
    private final boolean reuseInfoProvided;
    private final boolean doMeasurements;
    private OptimizeStrings os;
    private boolean only1CommonString;
    private boolean isTsIncluded;
    private boolean isTsiIncluded;
    private final CasTypeSystemMapper typeMapper;
    private boolean isTypeMapping;
    private final int[][] prevHeapInstanceWithIntValues;
    private final Int2ObjHashMap<long[], long[]> prevFsWithLongValues;
    private PositiveIntSet foundFSs;
    private PositiveIntSet foundFSsBelowMark;
    private List<TOP> fssToSerialize;
    private PositiveIntSet uimaSerializableSavedToCas;
    private final List<TOP> toBeScanned = new ArrayList<TOP>();
    private final boolean debugEOF = false;
    private DataOutputStream serializedOut;
    private final SerializationMeasures sm;
    private final ByteArrayOutputStream[] baosZipSources = new ByteArrayOutputStream[NBR_SLOT_KIND_ZIP_STREAMS];
    private final DataOutputStream[] dosZipSources = new DataOutputStream[NBR_SLOT_KIND_ZIP_STREAMS];
    private DataOutputStream byte_dos;
    private DataOutputStream typeCode_dos;
    private DataOutputStream strOffset_dos;
    private DataOutputStream strLength_dos;
    private DataOutputStream float_Mantissa_Sign_dos;
    private DataOutputStream float_Exponent_dos;
    private DataOutputStream double_Mantissa_Sign_dos;
    private DataOutputStream double_Exponent_dos;
    private DataOutputStream fsIndexes_dos;
    private DataOutputStream control_dos;
    private DataOutputStream strSeg_dos;
    private AllowPreexistingFS allowPreexistingFS;
    private DataInputStream deserIn;
    private int version;
    private final DataInputStream[] dataInputs = new DataInputStream[NBR_SLOT_KIND_ZIP_STREAMS];
    private final Inflater[] inflaters = new Inflater[NBR_SLOT_KIND_ZIP_STREAMS];
    private final List<Runnable> fixupsNeeded = new ArrayList<Runnable>();
    private final List<Runnable> uimaSerializableFixups = new ArrayList<Runnable>();
    private final List<Runnable> singleFsDefer = new ArrayList<Runnable>();
    private int sofaNum;
    private String sofaName;
    private String sofaMimeType;
    private Sofa sofaRef;
    private TOP currentFs;
    private boolean isUpdatePrevOK;
    private String[] readCommonString;
    private DataInputStream arrayLength_dis;
    private DataInputStream heapRef_dis;
    private DataInputStream int_dis;
    private DataInputStream byte_dis;
    private DataInputStream short_dis;
    private DataInputStream typeCode_dis;
    private DataInputStream strOffset_dis;
    private DataInputStream strLength_dis;
    private DataInputStream long_High_dis;
    private DataInputStream long_Low_dis;
    private DataInputStream float_Mantissa_Sign_dis;
    private DataInputStream float_Exponent_dis;
    private DataInputStream double_Mantissa_Sign_dis;
    private DataInputStream double_Exponent_dis;
    private DataInputStream fsIndexes_dis;
    private DataInputStream strChars_dis;
    private DataInputStream control_dis;
    private DataInputStream strSeg_dis;
    private int lastArrayLength;

    public ReuseInfo getReuseInfo() {
        return new ReuseInfo(this.foundFSs, this.fssToSerialize, this.fsStartIndexes);
    }

    public BinaryCasSerDes6(AbstractCas aCas, MarkerImpl mark, TypeSystemImpl tgtTs, ReuseInfo rfs, boolean doMeasurements, CompressLevel compressLevel, CompressStrat compressStrategy) throws ResourceInitializationException {
        this(aCas, mark, tgtTs, false, false, rfs, doMeasurements, compressLevel, compressStrategy);
    }

    private BinaryCasSerDes6(AbstractCas aCas, MarkerImpl mark, TypeSystemImpl tgtTs, boolean storeTS, boolean storeTSI, ReuseInfo rfs, boolean doMeasurements, CompressLevel compressLevel, CompressStrat compressStrategy) throws ResourceInitializationException {
        this.cas = ((CASImpl)(aCas instanceof JCas ? ((JCas)aCas).getCas() : aCas)).getBaseCAS();
        this.bcsd = this.cas.getBinaryCasSerDes();
        this.srcTs = this.cas.getTypeSystemImpl();
        this.mark = mark;
        if (null != mark && !mark.isValid()) {
            throw new CASRuntimeException("INVALID_MARKER", "Invalid Marker.");
        }
        this.doMeasurements = doMeasurements;
        this.sm = doMeasurements ? new SerializationMeasures() : null;
        this.isSerializingDelta = mark != null;
        this.isDelta = this.isSerializingDelta;
        this.typeMapper = this.srcTs.getTypeSystemMapper(tgtTs);
        this.isTypeMapping = null != this.typeMapper;
        this.isTsIncluded = storeTS;
        this.isTsiIncluded = storeTSI;
        this.nextFsId = this.isSerializingDelta ? mark.getNextFSId() : 0;
        this.stringHeapObj = new StringHeap();
        int sz = Math.max(this.srcTs.getTypeArraySize(), tgtTs == null ? 0 : tgtTs.getTypeArraySize());
        this.prevHeapInstanceWithIntValues = new int[sz][];
        this.prevFsWithLongValues = new Int2ObjHashMap(long[].class);
        this.compressLevel = compressLevel;
        this.compressStrategy = compressStrategy;
        boolean bl = this.reuseInfoProvided = rfs != null;
        if (this.reuseInfoProvided) {
            this.foundFSs = rfs.foundFSs;
            this.fssToSerialize = rfs.fssToSerialize;
            this.fsStartIndexes = rfs.fsStartIndexes.copy();
        } else {
            this.foundFSs = null;
            this.fssToSerialize = null;
            this.fsStartIndexes = new CasSeqAddrMaps();
        }
        this.tgtTs = tgtTs;
    }

    BinaryCasSerDes6(BinaryCasSerDes6 f6, TypeSystemImpl tgtTs) throws ResourceInitializationException {
        this.cas = f6.cas;
        this.bcsd = f6.bcsd;
        this.stringHeapObj = f6.stringHeapObj;
        this.nextFsId = f6.nextFsId;
        this.srcTs = f6.srcTs;
        this.tgtTs = tgtTs;
        this.compressLevel = f6.compressLevel;
        this.compressStrategy = f6.compressStrategy;
        this.mark = f6.mark;
        if (null != this.mark && !this.mark.isValid()) {
            throw new CASRuntimeException("INVALID_MARKER", "Invalid Marker.");
        }
        this.isSerializingDelta = this.mark != null;
        this.isDelta = this.isSerializingDelta;
        this.fsStartIndexes = f6.fsStartIndexes;
        this.reuseInfoProvided = f6.reuseInfoProvided;
        this.doMeasurements = f6.doMeasurements;
        this.sm = f6.sm;
        this.isTsIncluded = f6.isTsIncluded;
        this.isTsiIncluded = f6.isTsiIncluded;
        this.typeMapper = this.srcTs.getTypeSystemMapper(tgtTs);
        this.isTypeMapping = null != this.typeMapper;
        this.prevHeapInstanceWithIntValues = f6.prevHeapInstanceWithIntValues;
        this.prevFsWithLongValues = f6.prevFsWithLongValues;
        this.foundFSs = f6.foundFSs;
        this.foundFSsBelowMark = f6.foundFSsBelowMark;
        this.fssToSerialize = f6.fssToSerialize;
    }

    public BinaryCasSerDes6(AbstractCas cas) throws ResourceInitializationException {
        this(cas, null, null, false, false, null, false, CompressLevel.Default, CompressStrat.Default);
    }

    public BinaryCasSerDes6(AbstractCas cas, TypeSystemImpl tgtTs) throws ResourceInitializationException {
        this(cas, null, tgtTs, false, false, null, false, CompressLevel.Default, CompressStrat.Default);
    }

    public BinaryCasSerDes6(AbstractCas cas, MarkerImpl mark, TypeSystemImpl tgtTs, ReuseInfo rfs) throws ResourceInitializationException {
        this(cas, mark, tgtTs, false, false, rfs, false, CompressLevel.Default, CompressStrat.Default);
    }

    public BinaryCasSerDes6(AbstractCas cas, MarkerImpl mark, TypeSystemImpl tgtTs, ReuseInfo rfs, boolean doMeasurements) throws ResourceInitializationException {
        this(cas, mark, tgtTs, false, false, rfs, doMeasurements, CompressLevel.Default, CompressStrat.Default);
    }

    public BinaryCasSerDes6(AbstractCas cas, ReuseInfo rfs) throws ResourceInitializationException {
        this(cas, null, null, false, false, rfs, false, CompressLevel.Default, CompressStrat.Default);
    }

    public BinaryCasSerDes6(AbstractCas cas, ReuseInfo rfs, boolean storeTS, boolean storeTSI) throws ResourceInitializationException {
        this(cas, null, null, storeTS, storeTSI, rfs, false, CompressLevel.Default, CompressStrat.Default);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SerializationMeasures serialize(Object out) throws IOException {
        if (this.isSerializingDelta && this.tgtTs != null) {
            throw new UnsupportedOperationException("Can't do Delta Serialization with different target TS");
        }
        CASImpl.SharedViewData sharedViewData = this.cas.svd;
        synchronized (sharedViewData) {
            SerializeModifiedFSs smfs;
            this.setupOutputStreams(out);
            if (this.doMeasurements) {
                this.sm.totalTime = System.currentTimeMillis();
            }
            CommonSerDes.createHeader().form6().delta(this.isSerializingDelta).seqVer(2).v3().typeSystemIncluded(this.isTsIncluded).typeSystemIndexDefIncluded(this.isTsiIncluded).write(this.serializedOut);
            if (this.isTsIncluded || this.isTsiIncluded) {
                CasIOUtils.writeTypeSystem(this.cas, this.serializedOut, this.isTsiIncluded);
            }
            this.os = new OptimizeStrings(this.doMeasurements);
            this.uimaSerializableSavedToCas = new PositiveIntSet_impl(1024, 1, 1024);
            if (!this.reuseInfoProvided || this.isSerializingDelta) {
                this.processIndexedFeatureStructures(this.cas, false);
            }
            this.initSrcTgtIdMapsAndStrings();
            SerializeModifiedFSs serializeModifiedFSs = smfs = this.isSerializingDelta ? new SerializeModifiedFSs() : null;
            if (this.isSerializingDelta) {
                smfs.addModifiedStrings();
            }
            this.os.optimize();
            this.writeStringInfo();
            this.writeVnumber(this.control_dos, this.fssToSerialize.size());
            Arrays.fill((Object[])this.prevHeapInstanceWithIntValues, null);
            this.prevFsWithLongValues.clear();
            for (TOP fs : this.fssToSerialize) {
                TypeImpl tgtType;
                TypeImpl srcType = fs._getTypeImpl();
                int tCode = srcType.getCode();
                TypeImpl typeImpl = tgtType = this.isTypeMapping ? this.typeMapper.mapTypeSrc2Tgt(srcType) : srcType;
                assert (null != tgtType);
                this.writeVnumber(this.typeCode_dos, tgtType.getCode());
                if (fs instanceof CommonArrayFS) {
                    this.serializeArray(fs);
                } else if (this.isTypeMapping) {
                    for (FeatureImpl tgtFeat : tgtType.getFeatureImpls()) {
                        FeatureImpl srcFeat = this.typeMapper.getSrcFeature(tgtType, tgtFeat);
                        assert (srcFeat != null);
                        this.serializeByKind(fs, srcFeat);
                    }
                } else {
                    for (FeatureImpl srcFeat : srcType.getFeatureImpls()) {
                        this.serializeByKind(fs, srcFeat);
                    }
                }
                if (!this.doMeasurements) continue;
                this.sm.statDetails[typeCode_i].incr(DataIO.lengthVnumber(tCode));
                ++this.sm.mainHeapFSs;
            }
            this.processIndexedFeatureStructures(this.cas, true);
            if (this.isSerializingDelta) {
                smfs.serializeModifiedFSs();
            }
            this.collectAndZip();
            if (this.doMeasurements) {
                this.sm.totalTime = System.currentTimeMillis() - this.sm.totalTime;
            }
            return this.sm;
        }
    }

    private void serializeArray(TOP fs) throws IOException {
        TypeImpl_array arrayType = (TypeImpl_array)fs._getTypeImpl();
        CommonArrayFS a = (CommonArrayFS)((Object)fs);
        SlotKinds.SlotKind arrayElementKind = arrayType.getComponentSlotKind();
        int length = this.serializeArrayLength(a);
        if (length == 0) {
            if (arrayElementKind == SlotKinds.SlotKind.Slot_HeapRef || arrayElementKind == SlotKinds.SlotKind.Slot_Int) {
                this.updatePrevArray0IntValue(arrayType, 0);
            }
            return;
        }
        int io = arrayElementKind.ordinal();
        int prev = 0;
        boolean isFirstElement = true;
        switch (arrayElementKind) {
            case Slot_HeapRef: {
                prev = this.getPrevIntValue(arrayType.getCode(), 0);
                for (TOP tOP : ((FSArray)fs)._getTheArray()) {
                    int v = this.getTgtSeqFromSrcFS(tOP);
                    this.writeDiff(io, v, prev);
                    if (this.isUpdatePrevOK && isFirstElement) {
                        this.updatePrevArray0IntValue(arrayType, v);
                    }
                    prev = v;
                    isFirstElement = false;
                }
                break;
            }
            case Slot_Int: {
                prev = this.getPrevIntValue(arrayType.getCode(), 0);
                for (int n : ((IntegerArray)fs)._getTheArray()) {
                    this.writeDiff(io, n, prev);
                    if (this.isUpdatePrevOK && isFirstElement) {
                        this.updatePrevArray0IntValue(arrayType, n);
                    }
                    isFirstElement = false;
                    prev = n;
                }
                break;
            }
            case Slot_Float: {
                for (float f : ((FloatArray)fs)._getTheArray()) {
                    this.writeFloat(CASImpl.float2int(f));
                }
                break;
            }
            case Slot_StrRef: {
                for (String string : ((StringArray)fs)._getTheArray()) {
                    this.writeString(string);
                }
                break;
            }
            case Slot_BooleanRef: {
                for (boolean bl : ((BooleanArray)fs)._getTheArray()) {
                    this.byte_dos.write(bl ? 1 : 0);
                }
                break;
            }
            case Slot_ByteRef: {
                this.byte_dos.write(((ByteArray)fs)._getTheArray(), 0, length);
                break;
            }
            case Slot_ShortRef: {
                for (int n : ((ShortArray)fs)._getTheArray()) {
                    this.writeDiff(short_i, n, prev);
                    prev = n;
                }
                break;
            }
            case Slot_LongRef: {
                long longPrev = 0L;
                for (long l : ((LongArray)fs)._getTheArray()) {
                    this.writeLong(l, longPrev);
                    longPrev = l;
                }
                break;
            }
            case Slot_DoubleRef: {
                for (double d : ((DoubleArray)fs)._getTheArray()) {
                    this.writeDouble(Double.doubleToRawLongBits(d));
                }
                break;
            }
            default: {
                Misc.internalError();
            }
        }
    }

    private void serializeByKind(TOP fs, FeatureImpl feat) throws IOException {
        SlotKinds.SlotKind kind = feat.getSlotKind();
        switch (kind) {
            case Slot_Short: {
                this.serializeDiffWithPrevTypeSlot(kind, fs, feat, fs._getShortValueNc(feat));
                break;
            }
            case Slot_Int: {
                this.serializeDiffWithPrevTypeSlot(kind, fs, feat, fs._getIntValueNc(feat));
                break;
            }
            case Slot_HeapRef: {
                this.serializeDiffWithPrevTypeSlot(kind, fs, feat, this.getTgtSeqFromSrcFS(fs._getFeatureValueNc(feat)));
                break;
            }
            case Slot_Float: {
                this.writeFloat(CASImpl.float2int(fs._getFloatValueNc(feat)));
                break;
            }
            case Slot_Boolean: {
                this.byte_dos.write(fs._getBooleanValueNc(feat) ? 1 : 0);
                break;
            }
            case Slot_Byte: {
                this.byte_dos.write(fs._getByteValueNc(feat));
                break;
            }
            case Slot_StrRef: {
                this.writeString(fs._getStringValueNc(feat));
                break;
            }
            case Slot_LongRef: {
                TypeImpl ti = fs._getTypeImpl();
                int offset = feat.getOffset();
                long prevLong = this.getPrevLongValue(ti.getCode(), offset);
                long vLong = fs._getLongValueNc(feat);
                this.writeLong(vLong, prevLong);
                this.updatePrevLongValue(ti, offset, vLong);
                break;
            }
            case Slot_DoubleRef: {
                this.writeDouble(Double.doubleToRawLongBits(fs._getDoubleValueNc(feat)));
                break;
            }
            default: {
                throw new RuntimeException("internal error");
            }
        }
    }

    private int serializeArrayLength(CommonArrayFS array) throws IOException {
        int length = array.size();
        this.writeVnumber(arrayLength_i, length);
        return length;
    }

    private void serializeDiffWithPrevTypeSlot(SlotKinds.SlotKind kind, TOP fs, FeatureImpl feat, int newValue) throws IOException {
        int prev = this.getPrevIntValue(fs._getTypeCode(), feat.getOffset());
        this.writeDiff(kind.ordinal(), newValue, prev);
        if (this.isUpdatePrevOK) {
            this.updatePrevIntValue(fs._getTypeImpl(), feat.getOffset(), newValue);
        }
    }

    private void updatePrevIntValue(TypeImpl ti, int featOffset, int newValue) {
        int[] featCache = this.initPrevIntValue(ti);
        featCache[featOffset] = newValue;
    }

    private void updatePrevLongValue(TypeImpl ti, int featOffset, long newValue) {
        long[] featCache = this.initPrevLongValue(ti);
        featCache[featOffset] = newValue;
    }

    private void updatePrevArray0IntValue(TypeImpl ti, int newValue) {
        int[] featCache = this.initPrevIntValue(ti);
        featCache[0] = newValue;
    }

    private int[] initPrevIntValue(TypeImpl ti) {
        int tcode = ti.getCode();
        int[] featCache = this.prevHeapInstanceWithIntValues[tcode];
        if (null == featCache) {
            this.prevHeapInstanceWithIntValues[tcode] = new int[ti.isArray() ? 1 : ti.getNumberOfFeatures()];
            return this.prevHeapInstanceWithIntValues[tcode];
        }
        return featCache;
    }

    private long[] initPrevLongValue(TypeImpl ti) {
        int tcode = ti.getCode();
        long[] featCache = this.prevFsWithLongValues.get(tcode);
        if (null == featCache) {
            featCache = new long[ti.getNumberOfFeatures()];
            this.prevFsWithLongValues.put(tcode, featCache);
        }
        return featCache;
    }

    private int getPrevIntValue(int typeCode, int featOffset) {
        int[] featCache = this.prevHeapInstanceWithIntValues[typeCode];
        if (null == featCache) {
            return 0;
        }
        return featCache[featOffset];
    }

    private long getPrevLongValue(int typeCode, int featOffset) {
        long[] featCache = this.prevFsWithLongValues.get(typeCode);
        return featCache == null ? 0L : featCache[featOffset];
    }

    private void collectAndZip() throws IOException {
        int i;
        ByteArrayOutputStream baosZipped = new ByteArrayOutputStream(4096);
        Deflater deflater = new Deflater(this.compressLevel.lvl, true);
        deflater.setStrategy(this.compressStrategy.strat);
        int nbrEntries = 0;
        ArrayList<Integer> idxAndLen = new ArrayList<Integer>();
        for (i = 0; i < this.baosZipSources.length; ++i) {
            ByteArrayOutputStream baos = this.baosZipSources[i];
            if (baos == null) continue;
            ++nbrEntries;
            this.dosZipSources[i].close();
            long startTime = System.currentTimeMillis();
            int zipBufSize = Math.max(1024, baos.size() / 100);
            deflater.reset();
            DeflaterOutputStream cds = new DeflaterOutputStream((OutputStream)baosZipped, deflater, zipBufSize);
            baos.writeTo(cds);
            cds.close();
            idxAndLen.add(i);
            if (this.doMeasurements) {
                this.sm.statDetails[i].afterZip = deflater.getBytesWritten();
                idxAndLen.add((int)this.sm.statDetails[i].afterZip);
                this.sm.statDetails[i].beforeZip = deflater.getBytesRead();
                idxAndLen.add((int)this.sm.statDetails[i].beforeZip);
                this.sm.statDetails[i].zipTime = System.currentTimeMillis() - startTime;
                continue;
            }
            idxAndLen.add((int)deflater.getBytesWritten());
            idxAndLen.add((int)deflater.getBytesRead());
        }
        this.serializedOut.writeInt(nbrEntries);
        i = 0;
        while (i < idxAndLen.size()) {
            this.serializedOut.write((Integer)idxAndLen.get(i++));
            this.serializedOut.writeInt((Integer)idxAndLen.get(i++));
            this.serializedOut.writeInt((Integer)idxAndLen.get(i++));
        }
        baosZipped.writeTo(this.serializedOut);
    }

    private void writeLong(long v, long prev) throws IOException {
        this.writeDiff(long_High_i, (int)(v >>> 32), (int)(prev >>> 32));
        this.writeDiff(long_Low_i, (int)v, (int)prev);
    }

    private void writeString(String s) throws IOException {
        if (null == s) {
            this.writeVnumber(this.strLength_dos, 0);
            if (this.doMeasurements) {
                this.sm.statDetails[strLength_i].incr(1);
            }
            return;
        }
        int indexOrSeq = this.os.getIndexOrSeqIndex(s);
        if (indexOrSeq < 0) {
            int v = this.encodeIntSign(indexOrSeq);
            this.writeVnumber(this.strLength_dos, v);
            if (this.doMeasurements) {
                this.sm.statDetails[strLength_i].incr(DataIO.lengthVnumber(v));
            }
            return;
        }
        if (s.length() == 0) {
            this.writeVnumber(this.strLength_dos, this.encodeIntSign(1));
            if (this.doMeasurements) {
                this.sm.statDetails[strLength_i].incr(1);
            }
            return;
        }
        if (s.length() == Integer.MAX_VALUE) {
            throw new RuntimeException("Cannot serialize string of Integer.MAX_VALUE length - too large.");
        }
        int offset = this.os.getOffset(indexOrSeq);
        int length = this.encodeIntSign(s.length() + 1);
        this.writeVnumber(this.strOffset_dos, offset);
        this.writeVnumber(this.strLength_dos, length);
        if (this.doMeasurements) {
            this.sm.statDetails[strOffset_i].incr(DataIO.lengthVnumber(offset));
            this.sm.statDetails[strLength_i].incr(DataIO.lengthVnumber(length));
        }
        if (!this.only1CommonString) {
            int csi = this.os.getCommonStringIndex(indexOrSeq);
            this.writeVnumber(this.strSeg_dos, csi);
            if (this.doMeasurements) {
                this.sm.statDetails[strSeg_i].incr(DataIO.lengthVnumber(csi));
            }
        }
    }

    private void writeFloat(int raw) throws IOException {
        if (raw == 0) {
            this.writeUnsignedByte(this.float_Exponent_dos, 0);
            if (this.doMeasurements) {
                this.sm.statDetails[float_Exponent_i].incr(1);
            }
            return;
        }
        int exponent = (raw >>> 23 & 0xFF) + 1;
        int revMants = Integer.reverse((raw & 0x7FFFFF) << 9);
        int mants = (revMants << 1) + (raw < 0 ? 1 : 0);
        this.writeVnumber(this.float_Exponent_dos, exponent);
        this.writeVnumber(this.float_Mantissa_Sign_dos, mants);
        if (this.doMeasurements) {
            this.sm.statDetails[float_Exponent_i].incr(DataIO.lengthVnumber(exponent));
            this.sm.statDetails[float_Mantissa_Sign_i].incr(DataIO.lengthVnumber(mants));
        }
    }

    private void writeVnumber(int kind, int v) throws IOException {
        DataIO.writeVnumber((DataOutput)this.dosZipSources[kind], v);
        if (this.doMeasurements) {
            this.sm.statDetails[kind].incr(DataIO.lengthVnumber(v));
        }
    }

    private void writeVnumber(int kind, long v) throws IOException {
        DataIO.writeVnumber((DataOutput)this.dosZipSources[kind], v);
        if (this.doMeasurements) {
            this.sm.statDetails[kind].incr(DataIO.lengthVnumber(v));
        }
    }

    private void writeVnumber(DataOutputStream s, int v) throws IOException {
        DataIO.writeVnumber((DataOutput)s, v);
    }

    private void writeVnumber(DataOutputStream s, long v) throws IOException {
        DataIO.writeVnumber((DataOutput)s, v);
    }

    private void writeUnsignedByte(DataOutputStream s, int v) throws IOException {
        s.write(v);
    }

    private void writeDouble(long raw) throws IOException {
        if (raw == 0L) {
            this.writeVnumber(this.double_Exponent_dos, 0);
            if (this.doMeasurements) {
                this.sm.statDetails[double_Exponent_i].incr(1);
            }
            return;
        }
        int exponent = (int)(raw >>> 52 & 0x7FFL);
        if ((exponent -= 1023) >= 0) {
            ++exponent;
        }
        exponent = this.encodeIntSign(exponent);
        long revMants = Long.reverse((raw & 0xFFFFFFFFFFFFFL) << 12);
        long mants = (revMants << 1) + (long)(raw < 0L ? 1 : 0);
        this.writeVnumber(this.double_Exponent_dos, exponent);
        this.writeVnumber(this.double_Mantissa_Sign_dos, mants);
        if (this.doMeasurements) {
            this.sm.statDetails[double_Exponent_i].incr(DataIO.lengthVnumber(exponent));
            this.sm.statDetails[double_Mantissa_Sign_i].incr(DataIO.lengthVnumber(mants));
        }
    }

    private int encodeIntSign(int v) {
        if (v < 0) {
            return -v << 1 | 1;
        }
        return v << 1;
    }

    private int writeDiff(int kind, int v, int prev) throws IOException {
        if (v == 0) {
            this.write0(kind);
            this.isUpdatePrevOK = false;
            return 0;
        }
        if (v == Integer.MIN_VALUE) {
            this.writeVnumber(kind, 2);
            if (this.doMeasurements) {
                ++this.sm.statDetails[kind].diffEncoded;
                ++this.sm.statDetails[kind].valueLeDiff;
            }
            this.isUpdatePrevOK = false;
            return 0;
        }
        int absV = Math.abs(v);
        if (v > 0 && prev > 0 || v < 0 && prev < 0) {
            int absDiff;
            int diff = v - prev;
            int n = absDiff = diff < 0 ? -diff : diff;
            assert (absDiff >= 0);
            assert (absV >= 0);
            long v2write = absV <= absDiff ? ((long)absV << 2) + (v < 0 ? 2L : 0L) : ((long)absDiff << 2) + (diff < 0 ? 3L : 1L);
            this.writeVnumber(kind, v2write);
            if (this.doMeasurements) {
                ++this.sm.statDetails[kind].diffEncoded;
                this.sm.statDetails[kind].valueLeDiff = this.sm.statDetails[kind].valueLeDiff + (absV <= absDiff ? 1L : 0L);
            }
            this.isUpdatePrevOK = true;
            return v;
        }
        this.writeVnumber(kind, ((long)absV << 2) + (long)(v < 0 ? 2 : 0));
        if (this.doMeasurements) {
            ++this.sm.statDetails[kind].diffEncoded;
            ++this.sm.statDetails[kind].valueLeDiff;
        }
        this.isUpdatePrevOK = true;
        return v;
    }

    private void write0(int kind) throws IOException {
        this.writeVnumber(kind, 0);
        if (this.doMeasurements) {
            ++this.sm.statDetails[kind].diffEncoded;
            ++this.sm.statDetails[kind].valueLeDiff;
        }
    }

    public void deserialize(InputStream istream) throws IOException {
        CommonSerDes.Header h = this.readHeader(istream);
        if (this.isReadingDelta) {
            if (!this.reuseInfoProvided) {
                throw new UnsupportedOperationException("Deserializing Delta Cas, but original not serialized from");
            }
        } else {
            this.cas.resetNoQuestions();
        }
        this.bcsd.reinit(h, this.deserIn, null, CasLoadMode.DEFAULT, this, AllowPreexistingFS.allow, null);
    }

    public void deserialize(InputStream istream, AllowPreexistingFS allowPreexistingFS) throws IOException {
        CommonSerDes.Header h = this.readHeader(istream);
        if (this.isReadingDelta) {
            if (!this.reuseInfoProvided) {
                throw new UnsupportedOperationException("Deserializing Delta Cas, but original not serialized from");
            }
        } else {
            throw new UnsupportedOperationException("Delta CAS required for this call");
        }
        this.bcsd.reinit(h, this.deserIn, null, CasLoadMode.DEFAULT, this, allowPreexistingFS, null);
    }

    public void deserializeAfterVersion(DataInputStream istream, boolean isDelta, AllowPreexistingFS allowPreexistingFS) throws IOException {
        int totalMappedHeapSize;
        this.allowPreexistingFS = allowPreexistingFS;
        if (allowPreexistingFS == AllowPreexistingFS.ignore) {
            throw new UnsupportedOperationException("AllowPreexistingFS.ignore not an allowed setting");
        }
        this.deserIn = istream;
        this.isDelta = this.isReadingDelta = isDelta;
        this.setupReadStreams();
        int lenCmnStrs = this.readVnumber(this.strChars_dis);
        this.readCommonString = new String[lenCmnStrs];
        for (int i = 0; i < lenCmnStrs; ++i) {
            this.readCommonString[i] = DataIO.readUTFv(this.strChars_dis);
        }
        this.only1CommonString = lenCmnStrs == 1;
        int nbrNewFSsInTarget = this.readVnumber(this.control_dis);
        int n = totalMappedHeapSize = this.bcsd.isBeforeV3 ? nbrNewFSsInTarget : -1;
        if (this.bcsd.isBeforeV3) {
            nbrNewFSsInTarget = -1;
        }
        this.nextFsId = this.isReadingDelta ? this.cas.peekNextFsId() : 0;
        Arrays.fill((Object[])this.prevHeapInstanceWithIntValues, null);
        this.prevFsWithLongValues.clear();
        if (this.nextFsId == 0) {
            this.nextFsId = 1;
        }
        if (this.isReadingDelta && !this.reuseInfoProvided) {
            throw new IllegalStateException("Reading Delta into CAS not serialized from");
        }
        this.fixupsNeeded.clear();
        this.lastArrayLength = 0;
        int currentFsId = this.nextFsId;
        int nbrFSs = 0;
        int nextFsAddr = 1;
        while (this.bcsd.isBeforeV3 ? nextFsAddr < totalMappedHeapSize : nbrFSs < nbrNewFSsInTarget) {
            boolean storeIt;
            int tgtTypeCode;
            TypeImpl tgtType = (this.isTypeMapping ? this.tgtTs : this.srcTs).getTypeForCode(tgtTypeCode = this.readVnumber(this.typeCode_dis));
            if (tgtType == null) {
                throw new CASRuntimeException("DESER_FORM_6_BAD_TYPE_CODE", tgtTypeCode, currentFsId, nbrFSs, nextFsAddr);
            }
            TypeImpl srcType = this.isTypeMapping ? this.typeMapper.mapTypeCodeTgt2Src(tgtTypeCode) : tgtType;
            boolean bl = storeIt = srcType != null;
            if (storeIt) {
                this.initPrevIntValue(tgtType);
            }
            if (tgtType.isArray()) {
                this.readArray(storeIt, srcType, tgtType);
            } else {
                if (storeIt) {
                    if (!this.srcTs.annotBaseType.subsumes(srcType) && this.srcTs.sofaType != srcType) {
                        this.createCurrentFs(srcType, this.cas);
                    } else {
                        this.currentFs = null;
                        this.singleFsDefer.clear();
                        this.sofaRef = null;
                        this.sofaNum = -1;
                        this.sofaName = null;
                        this.sofaMimeType = null;
                    }
                }
                if (this.isTypeMapping && storeIt) {
                    for (FeatureImpl tgtFeat : tgtType.getFeatureImpls()) {
                        FeatureImpl srcFeat = this.typeMapper.getSrcFeature(tgtType, tgtFeat);
                        this.readByKind(this.currentFs, tgtFeat, srcFeat, storeIt, tgtType);
                    }
                } else {
                    for (FeatureImpl tgtFeat : tgtType.getFeatureImpls()) {
                        this.readByKind(this.currentFs, tgtFeat, tgtFeat, storeIt, tgtType);
                    }
                }
                if (this.currentFs == null) {
                    if (this.srcTs.sofaType == srcType) {
                        this.currentFs = this.cas.hasView(this.sofaName) ? (TOP)((Object)this.cas.getView(this.sofaName).getSofa()) : this.cas.createSofa(this.sofaNum, this.sofaName, this.sofaMimeType);
                    } else {
                        CASImpl view = null == this.sofaRef ? this.cas.getInitialView() : this.cas.getView(this.sofaRef);
                        this.createCurrentFs(srcType, view);
                    }
                    if (srcType.getCode() == 36) {
                        boolean wasRemoved = this.cas.removeFromCorruptableIndexAnyView(this.currentFs, this.cas.getAddbackSingle());
                        for (Runnable r : this.singleFsDefer) {
                            r.run();
                        }
                        this.cas.addbackSingleIfWasRemoved(wasRemoved, this.currentFs);
                    } else {
                        for (Runnable r : this.singleFsDefer) {
                            r.run();
                        }
                    }
                }
            }
            this.fsStartIndexes.addSrcFsForTgt(this.currentFs, storeIt);
            currentFsId += storeIt ? this.cas.lastV2IdIncr() : 0;
            ++nbrFSs;
            nextFsAddr += this.bcsd.isBeforeV3 ? tgtType.getFsSpaceReq(this.lastArrayLength) : 0;
        }
        for (Runnable r : this.fixupsNeeded) {
            r.run();
        }
        for (Runnable r : this.uimaSerializableFixups) {
            r.run();
        }
        this.readIndexedFeatureStructures();
        if (this.isReadingDelta) {
            new ReadModifiedFSs().readModifiedFSs();
        }
        this.closeDataInputs();
    }

    private void createCurrentFs(TypeImpl type, CASImpl view) {
        this.currentFs = (TOP)view.createFS(type);
        if (this.currentFs instanceof UimaSerializable) {
            UimaSerializable ufs = (UimaSerializable)((Object)this.currentFs);
            this.uimaSerializableFixups.add(() -> ufs._init_from_cas_data());
        }
    }

    private void readArray(boolean storeIt, TypeImpl srcType, TypeImpl tgtType) throws IOException {
        TOP fs;
        int length;
        this.lastArrayLength = length = this.readArrayLength();
        SlotKinds.SlotKind slotKind = tgtType.getComponentSlotKind();
        this.currentFs = fs = storeIt ? this.cas.createArray(srcType, length) : null;
        switch (slotKind) {
            case Slot_BooleanRef: {
                if (storeIt) {
                    for (int i = 0; i < length; ++i) {
                        ((BooleanArray)fs).set(i, this.byte_dis.readByte() == 1);
                    }
                    break;
                }
                BinaryCasSerDes6.skipBytes(this.byte_dis, length);
                break;
            }
            case Slot_ByteRef: {
                this.readIntoByteArray(((ByteArray)fs)._getTheArray(), length, storeIt);
                break;
            }
            case Slot_ShortRef: {
                this.readIntoShortArray(((ShortArray)fs)._getTheArray(), length, storeIt);
                break;
            }
            case Slot_Int: {
                IntegerArray ia = (IntegerArray)fs;
                int prev = this.getPrevIntValue(8, 0);
                for (int i = 0; i < length; ++i) {
                    int v;
                    prev = v = this.readDiff(SlotKinds.SlotKind.Slot_Int, prev);
                    if (0 == i && this.isUpdatePrevOK && storeIt) {
                        this.updatePrevArray0IntValue(ia._getTypeImpl(), v);
                    }
                    if (!storeIt) continue;
                    ia.set(i, v);
                }
                break;
            }
            case Slot_LongRef: {
                this.readIntoLongArray(((LongArray)fs)._getTheArray(), SlotKinds.SlotKind.Slot_LongRef, length, storeIt);
                break;
            }
            case Slot_Float: {
                FloatArray fa = (FloatArray)fs;
                for (int i = 0; i < length; ++i) {
                    int floatRef = this.readFloat();
                    if (!storeIt) continue;
                    fa.set(i, Float.intBitsToFloat(floatRef));
                }
                break;
            }
            case Slot_DoubleRef: {
                this.readIntoDoubleArray(((DoubleArray)fs)._getTheArray(), SlotKinds.SlotKind.Slot_DoubleRef, length, storeIt);
                break;
            }
            case Slot_HeapRef: {
                FSArray fsa = (FSArray)fs;
                TypeImpl_array arrayType = (TypeImpl_array)fsa._getTypeImpl();
                int prev = this.getPrevIntValue(arrayType.getCode(), 0);
                for (int i = 0; i < length; ++i) {
                    int v;
                    prev = v = this.readDiff(SlotKinds.SlotKind.Slot_HeapRef, prev);
                    if (0 == i && this.isUpdatePrevOK && storeIt) {
                        this.updatePrevArray0IntValue(fsa._getTypeImpl(), v);
                    }
                    if (!storeIt) continue;
                    int locali = i;
                    this.maybeStoreOrDefer_slotFixups(v, refd_fs -> fsa.set(locali, refd_fs));
                }
                break;
            }
            case Slot_StrRef: {
                StringArray sa = (StringArray)fs;
                for (int i = 0; i < length; ++i) {
                    String s = this.readString(storeIt);
                    if (!storeIt) continue;
                    sa.set(i, s);
                }
                break;
            }
            default: {
                Misc.internalError();
            }
        }
    }

    private TOP getRefVal(int tgtSeq) {
        return tgtSeq == 0 ? null : this.fsStartIndexes.getSrcFsFromTgtSeq(tgtSeq);
    }

    private int readArrayLength() throws IOException {
        return this.readVnumber(this.arrayLength_dis);
    }

    private void readByKind(TOP fs, FeatureImpl tgtFeat, FeatureImpl srcFeat, boolean storeIt, TypeImpl tgtType) throws IOException {
        int tgtFeatOffset = tgtFeat.getOffset();
        if (srcFeat == null) {
            storeIt = false;
        }
        SlotKinds.SlotKind kind = tgtFeat.getSlotKind();
        switch (kind) {
            case Slot_Int: {
                int vi = this.readDiffIntSlot(storeIt, tgtFeatOffset, kind, tgtType);
                if (srcFeat == this.srcTs.sofaNum) {
                    this.sofaNum = vi;
                    break;
                }
                this.maybeStoreOrDefer(storeIt, fs, lfs -> lfs._setIntLikeValueNcNj(kind, srcFeat, vi));
                break;
            }
            case Slot_Short: {
                int vs = this.readDiffIntSlot(storeIt, tgtFeatOffset, kind, tgtType);
                this.maybeStoreOrDefer(storeIt, fs, lfs -> lfs._setIntLikeValueNcNj(kind, srcFeat, vs));
                break;
            }
            case Slot_HeapRef: {
                int vh = this.readDiffIntSlot(storeIt, tgtFeatOffset, kind, tgtType);
                if (this.srcTs.annotBaseSofaFeat == srcFeat) {
                    this.sofaRef = (Sofa)this.getRefVal(vh);
                }
                if (this.srcTs.annotBaseSofaFeat == srcFeat && this.sofaRef != null) break;
                this.maybeStoreOrDefer(storeIt, fs, lfs -> {
                    if (tgtType.getCode() == 33) {
                        if (tgtFeat.getCode() == 12) {
                            Sofa sofa = (Sofa)lfs;
                            this.maybeStoreOrDefer_slotFixups(vh, ref_fs -> sofa.setLocalSofaData((FeatureStructure)ref_fs));
                        }
                    } else {
                        this.maybeStoreOrDefer_slotFixups(vh, ref_fs -> lfs._setFeatureValueNcNj(srcFeat, ref_fs));
                    }
                });
                break;
            }
            case Slot_Float: {
                int floatAsInt = this.readFloat();
                this.maybeStoreOrDefer(storeIt, fs, lfs -> lfs._setFloatValueNcNj(srcFeat, Float.intBitsToFloat(floatAsInt)));
                break;
            }
            case Slot_Boolean: 
            case Slot_Byte: {
                byte vByte = this.byte_dis.readByte();
                this.maybeStoreOrDefer(storeIt, fs, lfs -> lfs._setIntLikeValueNcNj(kind, srcFeat, vByte));
                break;
            }
            case Slot_StrRef: {
                String vString = this.readString(storeIt);
                if (null == vString || !storeIt) break;
                if (tgtType.getCode() == 33) {
                    if (srcFeat == this.srcTs.sofaId) {
                        this.sofaName = vString;
                        break;
                    }
                    if (srcFeat == this.srcTs.sofaMime) {
                        this.maybeStoreOrDefer(storeIt, fs, lfs -> ((Sofa)lfs).setMimeType(vString));
                        break;
                    }
                    if (srcFeat == this.srcTs.sofaUri) {
                        this.maybeStoreOrDefer(storeIt, fs, lfs -> ((Sofa)lfs).setRemoteSofaURI(vString));
                        break;
                    }
                    if (srcFeat == this.srcTs.sofaString) {
                        this.maybeStoreOrDefer(storeIt, fs, lfs -> ((Sofa)lfs).setLocalSofaDataNoDocAnnotUpdate(vString));
                        break;
                    }
                }
                this.maybeStoreOrDefer(storeIt, fs, lfs -> lfs._setStringValueNcNj(srcFeat, vString));
                break;
            }
            case Slot_LongRef: {
                long prevLong = this.getPrevLongValue(tgtType.getCode(), tgtFeatOffset);
                long vl = this.readLongOrDouble(kind, prevLong);
                this.updatePrevLongValue(tgtType, tgtFeatOffset, vl);
                this.maybeStoreOrDefer(storeIt, fs, lfs -> lfs._setLongValueNcNj(srcFeat, vl));
                break;
            }
            case Slot_DoubleRef: {
                long vd = this.readDouble();
                this.maybeStoreOrDefer(storeIt, fs, lfs -> lfs._setDoubleValueNcNj(srcFeat, CASImpl.long2double(vd)));
                break;
            }
            default: {
                Misc.internalError();
            }
        }
    }

    private void maybeStoreOrDefer(boolean storeIt, TOP fs, Consumer<TOP> doStore) {
        if (storeIt) {
            if (null == fs) {
                this.singleFsDefer.add(() -> doStore.accept(this.currentFs));
            } else {
                doStore.accept(fs);
            }
        }
    }

    private void maybeStoreOrDefer_slotFixups(int tgtSeq, Consumer<TOP> r) {
        if (tgtSeq == 0) {
            r.accept(null);
            return;
        }
        TOP src = this.getRefVal(tgtSeq);
        if (src == null) {
            this.fixupsNeeded.add(() -> r.accept(this.getRefVal(tgtSeq)));
        } else {
            r.accept(src);
        }
    }

    private void readIndexedFeatureStructures() throws IOException {
        int i2;
        int nbrViews = this.readVnumber(this.control_dis);
        int nbrSofas = this.readVnumber(this.control_dis);
        IntVector fsIndexes = new IntVector(nbrViews + nbrSofas + 100);
        fsIndexes.add(nbrViews);
        fsIndexes.add(nbrSofas);
        for (i2 = 0; i2 < nbrSofas; ++i2) {
            int tgtAddrOfSofa = this.readVnumber(this.control_dis);
            fsIndexes.add(tgtAddrOfSofa);
        }
        for (i2 = 0; i2 < nbrViews; ++i2) {
            this.readFsxPart(fsIndexes);
            if (!this.isDelta) continue;
            this.readFsxPart(fsIndexes);
            this.readFsxPart(fsIndexes);
        }
        IntFunction<TOP> getFsFromTgtAddr = i -> this.fsStartIndexes.getSrcFsFromTgtSeq(i);
        this.bcsd.reinitIndexedFSs(fsIndexes.getArray(), this.isDelta, getFsFromTgtAddr);
    }

    private void readFsxPart(IntVector fsIndexes) throws IOException {
        int nbrEntries = this.readVnumber(this.control_dis);
        int nbrEntriesAdded = 0;
        int indexOfNbrAdded = fsIndexes.size();
        fsIndexes.add(0);
        int prev = 0;
        for (int i = 0; i < nbrEntries; ++i) {
            int v;
            prev = v = this.readVnumber(this.fsIndexes_dis) + prev;
            if (this.fsStartIndexes.getSrcFsFromTgtSeq(v) == null) continue;
            ++nbrEntriesAdded;
            fsIndexes.add(v);
        }
        fsIndexes.set(indexOfNbrAdded, nbrEntriesAdded);
    }

    private DataInput getInputStream(SlotKinds.SlotKind kind) {
        return this.dataInputs[kind.ordinal()];
    }

    private int readVnumber(DataInputStream dis) throws IOException {
        return DataIO.readVnumber(dis);
    }

    private long readVlong(DataInputStream dis) throws IOException {
        return DataIO.readVlong(dis);
    }

    private void readIntoByteArray(byte[] array, int length, boolean storeIt) throws IOException {
        if (storeIt) {
            this.byte_dis.readFully(array, 0, length);
        } else {
            BinaryCasSerDes6.skipBytes(this.byte_dis, length);
        }
    }

    private void readIntoShortArray(short[] array, int length, boolean storeIt) throws IOException {
        if (storeIt) {
            int prev = 0;
            for (int i = 0; i < length; ++i) {
                prev = (short)this.readDiff(this.short_dis, prev);
            }
        } else {
            BinaryCasSerDes6.skipBytes(this.short_dis, length * 2);
        }
    }

    private void readIntoLongArray(long[] array, SlotKinds.SlotKind kind, int length, boolean storeIt) throws IOException {
        if (storeIt) {
            long prev = 0L;
            for (int i = 0; i < length; ++i) {
                array[i] = prev = this.readLongOrDouble(kind, prev);
            }
        } else if (kind == SlotKinds.SlotKind.Slot_LongRef) {
            this.skipLong(length);
        } else {
            this.skipDouble(length);
        }
    }

    private void readIntoDoubleArray(double[] array, SlotKinds.SlotKind kind, int length, boolean storeIt) throws IOException {
        if (storeIt) {
            long prev = 0L;
            for (int i = 0; i < length; ++i) {
                prev = this.readLongOrDouble(kind, prev);
                array[i] = CASImpl.long2double(prev);
            }
        } else if (kind == SlotKinds.SlotKind.Slot_LongRef) {
            this.skipLong(length);
        } else {
            this.skipDouble(length);
        }
    }

    private int readDiff(SlotKinds.SlotKind kind, int prev) throws IOException {
        return this.readDiff(this.getInputStream(kind), prev);
    }

    private int readDiffIntSlot(boolean storeIt, int featOffset, SlotKinds.SlotKind kind, TypeImpl tgtType) throws IOException {
        int prev = this.getPrevIntValue(tgtType.getCode(), featOffset);
        int v = this.readDiff(kind, prev);
        if (this.isUpdatePrevOK) {
            this.updatePrevIntValue(tgtType, featOffset, v);
        }
        return v;
    }

    private int readDiff(DataInput in, int prev) throws IOException {
        long encoded = this.readVlong(in);
        boolean bl = this.isUpdatePrevOK = encoded != 0L;
        if (!this.isUpdatePrevOK) {
            return 0;
        }
        boolean isDeltaEncoded = 0L != (encoded & 1L);
        boolean isNegative = 0L != (encoded & 2L);
        int v = (int)(encoded >>> 2);
        if (isNegative) {
            if (v == 0) {
                this.isUpdatePrevOK = false;
                return Integer.MIN_VALUE;
            }
            v = -v;
        }
        if (isDeltaEncoded) {
            v += prev;
        }
        return v;
    }

    private long readLongOrDouble(SlotKinds.SlotKind kind, long prev) throws IOException {
        if (kind == SlotKinds.SlotKind.Slot_DoubleRef) {
            return this.readDouble();
        }
        int vh = this.readDiff(this.long_High_dis, (int)(prev >>> 32));
        int vl = this.readDiff(this.long_Low_dis, (int)prev);
        long v = (long)vh << 32 | 0xFFFFFFFFL & (long)vl;
        return v;
    }

    private void skipLong(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            BinaryCasSerDes6.skipBytes(this.long_High_dis, 8);
            BinaryCasSerDes6.skipBytes(this.long_Low_dis, 8);
        }
    }

    private void skipDouble(int length) throws IOException {
        for (int i = 0; i < length; ++i) {
            this.readDouble();
        }
    }

    private int readFloat() throws IOException {
        int exponent = this.readVnumber(this.float_Exponent_dis);
        if (exponent == 0) {
            return 0;
        }
        int mants = this.readVnumber(this.float_Mantissa_Sign_dis);
        boolean isNegative = (mants & 1) == 1;
        mants >>>= 1;
        mants = Integer.reverse(mants) >>> 9;
        return exponent - 1 << 23 | mants | (isNegative ? Integer.MIN_VALUE : 0);
    }

    private int decodeIntSign(int v) {
        if (1 == (v & 1)) {
            return -(v >>> 1);
        }
        return v >>> 1;
    }

    private long readDouble() throws IOException {
        int exponent = this.readVnumber(this.double_Exponent_dis);
        if (exponent == 0) {
            return 0L;
        }
        long mants = this.readVlong(this.double_Mantissa_Sign_dis);
        return this.decodeDouble(mants, exponent);
    }

    private long decodeDouble(long mants, int exponent) {
        if ((exponent = this.decodeIntSign(exponent)) > 0) {
            --exponent;
        }
        long r = (long)((exponent += 1023) & 0x7FF) << 52;
        boolean isNegative = 1L == (mants & 1L);
        mants = Long.reverse(mants >>> 1) >>> 12;
        r = r | mants | (isNegative ? Long.MIN_VALUE : 0L);
        return r;
    }

    private long readVlong(DataInput dis) throws IOException {
        return DataIO.readVlong(dis);
    }

    private String readString(boolean storeIt) throws IOException {
        int length = this.decodeIntSign(this.readVnumber(this.strLength_dis));
        if (0 == length) {
            return null;
        }
        if (1 == length) {
            this.stringHeapObj.addString(EMPTY_STRING);
            return EMPTY_STRING;
        }
        if (length < 0) {
            if (storeIt) {
                return this.stringHeapObj.getStringForCode(-length);
            }
            return null;
        }
        int offset = this.readVnumber(this.strOffset_dis);
        int segmentIndex = this.only1CommonString ? 0 : this.readVnumber(this.strSeg_dis);
        String s = this.readCommonString[segmentIndex].substring(offset, offset + length - 1);
        this.stringHeapObj.addString(s);
        return s;
    }

    static void skipBytes(DataInputStream stream, int skipNumber) throws IOException {
        int r = stream.skipBytes(skipNumber);
        if (r != skipNumber) {
            throw new IOException(String.format("%d bytes skipped when %d was requested, causing out-of-synch while deserializing from stream %s", r, skipNumber, stream));
        }
    }

    private void processIndexedFeatureStructures(CASImpl cas1, boolean isWrite) throws IOException {
        if (!isWrite) {
            AllFSs allFSs;
            try (AutoCloseableNoException a = cas1.ll_enableV2IdRefs(false);){
                allFSs = new AllFSs(cas1, this.mark, this.isTypeMapping ? fs -> this.isTypeInTgt((TOP)fs) : null, this.isTypeMapping ? this.typeMapper : null).getAllFSsAllViews_sofas_reachable();
                allFSs.getAllFSs().forEach(fs -> this.uimaSerializableSavedToCas.add(fs._id));
            }
            this.fssToSerialize = CASImpl.filterAboveMark(allFSs.getAllFSsSorted(), this.mark);
            this.foundFSs = allFSs.getAllNew();
            this.foundFSsBelowMark = allFSs.getAllBelowMark();
            return;
        }
        this.writeVnumber(control_i, cas1.getNumberOfViews());
        this.writeVnumber(control_i, cas1.getNumberOfSofas());
        if (this.doMeasurements) {
            this.sm.statDetails[fsIndexes_i].incr(1);
            this.sm.statDetails[fsIndexes_i].incr(1);
        }
        FSIterator it = cas1.getSofaIterator();
        while (it.hasNext()) {
            Sofa sofa = (Sofa)it.nextNvc();
            if (this.isSerializingDelta && !this.mark.isNew(sofa)) continue;
            int v = this.getTgtSeqFromSrcFS(sofa);
            this.writeVnumber(control_i, v);
            if (!this.doMeasurements) continue;
            this.sm.statDetails[fsIndexes_i].incr(DataIO.lengthVnumber(v));
        }
        TypeImpl topType = cas1.getTypeSystemImpl().getTopType();
        cas1.forAllViews(view -> {
            this.processFSsForView(true, this.isSerializingDelta ? view.indexRepository.getAddedFSs().stream() : view.indexRepository.getIndexedFSs(topType).stream());
            if (this.isSerializingDelta) {
                this.processFSsForView(false, view.indexRepository.getDeletedFSs().stream());
                this.processFSsForView(false, view.indexRepository.getReindexedFSs().stream());
            }
        });
    }

    private void processFSsForView(boolean isEnqueue, Stream<TOP> fss) {
        boolean prevId = false;
        boolean entriesWritten = true;
        int[] context = new int[]{0, 0};
        fss.sorted(FeatureStructureImplC::compare).forEachOrdered(fs -> {
            if (this.isTypeInTgt((TOP)fs)) {
                int tgtId = this.getTgtSeqFromSrcFS((TOP)fs);
                assert (tgtId > 0);
                int delta = tgtId - context[0];
                context[0] = tgtId;
                try {
                    this.writeVnumber(this.fsIndexes_dos, delta);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                context[1] = context[1] + 1;
                if (this.doMeasurements) {
                    this.sm.statDetails[fsIndexes_i].incr(DataIO.lengthVnumber(delta));
                }
            }
            if (isEnqueue) {
                this.enqueueFS((TOP)fs);
            }
        });
        try {
            this.writeVnumber(this.control_dos, context[1]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.doMeasurements) {
            this.sm.statDetails[typeCode_i].incr(DataIO.lengthVnumber(1));
        }
    }

    private void enqueueFS(TOP fs) {
        if (null == fs || !this.isTypeInTgt(fs)) {
            return;
        }
        int id = fs._id;
        if (!this.isSerializingDelta || this.mark.isNew(fs)) {
            if (!this.foundFSs.contains(id)) {
                this.foundFSs.add(id);
                this.toBeScanned.add(fs);
            }
        } else if (!this.foundFSsBelowMark.contains(id)) {
            this.foundFSsBelowMark.add(id);
            this.toBeScanned.add(fs);
        }
    }

    private boolean isTypeInTgt(TOP fs) {
        return !this.isTypeMapping || null != this.typeMapper.mapTypeSrc2Tgt(fs._getTypeImpl());
    }

    private void initSrcTgtIdMapsAndStrings() {
        int nextTgtId = this.isSerializingDelta ? this.mark.nextFSId : 1;
        for (TOP fs : this.fssToSerialize) {
            TypeImpl srcType = fs._getTypeImpl();
            TypeImpl tgtType = this.isTypeMapping ? this.typeMapper.mapTypeSrc2Tgt(srcType) : srcType;
            boolean isIncludedType = tgtType != null;
            this.fsStartIndexes.addItemId(fs, nextTgtId, isIncludedType);
            if (!isIncludedType) continue;
            if (fs instanceof UimaSerializable && !this.uimaSerializableSavedToCas.contains(fs._id)) {
                ((UimaSerializable)((Object)fs))._save_to_cas_data();
                this.uimaSerializableSavedToCas.add(fs._id);
            }
            if (this.os != null) {
                this.addStringsFromFS(fs);
            }
            ++nextTgtId;
        }
    }

    private void addStringsFromFS(TOP fs) {
        if (fs instanceof StringArray) {
            for (String s : ((StringArray)fs)._getTheArray()) {
                this.os.add(s);
            }
            return;
        }
        for (FeatureImpl fi : fs._getTypeImpl().getFeatureImpls()) {
            if (!(fi.getRange() instanceof TypeImpl_string)) continue;
            this.os.add(fs._getStringValueNc(fi));
        }
    }

    public boolean compareCASes(CASImpl c1, CASImpl c2) {
        return new CasCompare(c1, c2).compareCASes();
    }

    private static DataOutputStream makeDataOutputStream(Object f) throws FileNotFoundException {
        if (f instanceof DataOutputStream) {
            return (DataOutputStream)f;
        }
        if (f instanceof OutputStream) {
            return new DataOutputStream((OutputStream)f);
        }
        if (f instanceof File) {
            FileOutputStream fos = new FileOutputStream((File)f);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            return new DataOutputStream(bos);
        }
        throw new RuntimeException(String.format("Invalid class passed to method, class was %s", f.getClass().getName()));
    }

    private void setupOutputStreams(Object out) throws FileNotFoundException {
        this.serializedOut = BinaryCasSerDes6.makeDataOutputStream(out);
        BinaryCasSerDes6.setupOutputStreams(this.cas, this.baosZipSources, this.dosZipSources);
        this.byte_dos = this.dosZipSources[byte_i];
        this.typeCode_dos = this.dosZipSources[typeCode_i];
        this.strOffset_dos = this.dosZipSources[strOffset_i];
        this.strLength_dos = this.dosZipSources[strLength_i];
        this.float_Mantissa_Sign_dos = this.dosZipSources[float_Mantissa_Sign_i];
        this.float_Exponent_dos = this.dosZipSources[float_Exponent_i];
        this.double_Mantissa_Sign_dos = this.dosZipSources[double_Mantissa_Sign_i];
        this.double_Exponent_dos = this.dosZipSources[double_Exponent_i];
        this.fsIndexes_dos = this.dosZipSources[fsIndexes_i];
        this.control_dos = this.dosZipSources[control_i];
        this.strSeg_dos = this.dosZipSources[strSeg_i];
    }

    static void setupOutputStreams(CASImpl cas, ByteArrayOutputStream[] baosZipSources, DataOutputStream[] dosZipSources) {
        int[] estimatedZipSize = new int[NBR_SLOT_KIND_ZIP_STREAMS];
        int compr = cas.getLastUsedFsId() * 5 * 8 / 3 / 50;
        int compr1000 = Misc.nextHigherPowerOfX(Math.max(512, compr / 1000), 32);
        estimatedZipSize[BinaryCasSerDes6.typeCode_i] = Math.max(512, compr / 4);
        estimatedZipSize[BinaryCasSerDes6.byte_i] = compr1000;
        estimatedZipSize[BinaryCasSerDes6.short_i] = compr1000;
        estimatedZipSize[BinaryCasSerDes6.int_i] = Math.max(1024, compr1000);
        estimatedZipSize[BinaryCasSerDes6.arrayLength_i] = compr1000;
        estimatedZipSize[BinaryCasSerDes6.float_Mantissa_Sign_i] = compr1000;
        estimatedZipSize[BinaryCasSerDes6.float_Exponent_i] = compr1000;
        estimatedZipSize[BinaryCasSerDes6.double_Mantissa_Sign_i] = compr1000;
        estimatedZipSize[BinaryCasSerDes6.double_Exponent_i] = compr1000;
        estimatedZipSize[BinaryCasSerDes6.long_High_i] = compr1000;
        estimatedZipSize[BinaryCasSerDes6.long_Low_i] = compr1000;
        estimatedZipSize[BinaryCasSerDes6.heapRef_i] = Math.max(1024, compr1000);
        estimatedZipSize[BinaryCasSerDes6.strOffset_i] = Math.max(512, compr / 4);
        estimatedZipSize[BinaryCasSerDes6.strLength_i] = Math.max(512, compr / 4);
        estimatedZipSize[BinaryCasSerDes6.fsIndexes_i] = Math.max(512, compr / 8);
        estimatedZipSize[BinaryCasSerDes6.strChars_i] = Math.max(512, compr / 4);
        estimatedZipSize[BinaryCasSerDes6.control_i] = 128;
        for (int i = 0; i < baosZipSources.length; ++i) {
            BinaryCasSerDes6.setupOutputStream(i, estimatedZipSize[i], baosZipSources, dosZipSources);
        }
    }

    private static void setupOutputStream(int i, int size, ByteArrayOutputStream[] baosZipSources, DataOutputStream[] dosZipSources) {
        baosZipSources[i] = new ByteArrayOutputStream(size);
        dosZipSources[i] = new DataOutputStream(baosZipSources[i]);
    }

    private void setupReadStreams() throws IOException {
        int i;
        int nbrEntries = this.deserIn.readInt();
        IntVector idxAndLen = new IntVector(nbrEntries * 3);
        for (i = 0; i < nbrEntries; ++i) {
            idxAndLen.add(this.deserIn.readUnsignedByte());
            idxAndLen.add(this.deserIn.readInt());
            idxAndLen.add(this.deserIn.readInt());
        }
        i = 0;
        while (i < idxAndLen.size()) {
            this.setupReadStream(idxAndLen.get(i++), idxAndLen.get(i++), idxAndLen.get(i++));
        }
        this.arrayLength_dis = this.dataInputs[arrayLength_i];
        this.heapRef_dis = this.dataInputs[heapRef_i];
        this.int_dis = this.dataInputs[int_i];
        this.byte_dis = this.dataInputs[byte_i];
        this.short_dis = this.dataInputs[short_i];
        this.typeCode_dis = this.dataInputs[typeCode_i];
        this.strOffset_dis = this.dataInputs[strOffset_i];
        this.strLength_dis = this.dataInputs[strLength_i];
        this.long_High_dis = this.dataInputs[long_High_i];
        this.long_Low_dis = this.dataInputs[long_Low_i];
        this.float_Mantissa_Sign_dis = this.dataInputs[float_Mantissa_Sign_i];
        this.float_Exponent_dis = this.dataInputs[float_Exponent_i];
        this.double_Mantissa_Sign_dis = this.dataInputs[double_Mantissa_Sign_i];
        this.double_Exponent_dis = this.dataInputs[double_Exponent_i];
        this.fsIndexes_dis = this.dataInputs[fsIndexes_i];
        this.strChars_dis = this.dataInputs[strChars_i];
        this.control_dis = this.dataInputs[control_i];
        this.strSeg_dis = this.dataInputs[strSeg_i];
    }

    private void setupReadStream(int slotIndex, int bytesCompr, int bytesOrig) throws IOException {
        Inflater inflater;
        byte[] b = new byte[bytesCompr + 1];
        this.deserIn.readFully(b, 0, bytesCompr);
        this.inflaters[slotIndex] = inflater = new Inflater(true);
        ByteArrayInputStream baiStream = new ByteArrayInputStream(b);
        int zipBufSize = Math.max(1024, bytesCompr);
        InflaterInputStream iis = new InflaterInputStream(baiStream, inflater, zipBufSize);
        this.dataInputs[slotIndex] = new DataInputStream(new BufferedInputStream(iis, zipBufSize * 1));
    }

    private void closeDataInputs() {
        for (DataInputStream is : this.dataInputs) {
            if (null == is) continue;
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (Inflater inflater : this.inflaters) {
            if (null == inflater) continue;
            inflater.end();
        }
    }

    private CommonSerDes.Header readHeader(InputStream istream) throws IOException {
        this.deserIn = CommonSerDes.maybeWrapToDataInputStream(istream);
        CommonSerDes.Header h = CommonSerDes.readHeader(this.deserIn);
        if (!h.isCompressed) {
            throw new RuntimeException("non-compressed invalid object passed to BinaryCasSerDes6 deserialize");
        }
        if (!h.form6) {
            throw new RuntimeException(String.format("Wrong version: %d in input source passed to BinaryCasSerDes6 for deserialization", this.version));
        }
        this.isReadingDelta = this.isDelta = h.isDelta;
        return h;
    }

    private void writeStringInfo() throws IOException {
        String[] commonStrings = this.os.getCommonStrings();
        this.writeVnumber(strChars_i, commonStrings.length);
        for (int i = 0; i < commonStrings.length; ++i) {
            int startPos = this.dosZipSources[strChars_i].size();
            DataIO.writeUTFv(commonStrings[i], this.dosZipSources[strChars_i]);
            if (!this.doMeasurements) continue;
            float len = this.dosZipSources[strChars_i].size() - startPos;
            float excess = len / (float)commonStrings[i].length() - 1.0f;
            int encAs2 = (int)(excess * (float)commonStrings[i].length());
            this.sm.statDetails[BinaryCasSerDes6.strChars_i].countTotal += commonStrings[i].length();
            this.sm.statDetails[BinaryCasSerDes6.strChars_i].c[0] = commonStrings[i].length() - encAs2;
            this.sm.statDetails[BinaryCasSerDes6.strChars_i].c[1] = encAs2;
            this.sm.statDetails[BinaryCasSerDes6.strChars_i].lengthTotal = (int)((float)this.sm.statDetails[BinaryCasSerDes6.strChars_i].lengthTotal + len);
        }
        boolean bl = this.only1CommonString = commonStrings.length == 1;
        if (this.doMeasurements) {
            long commonStringsLength = 0L;
            this.sm.stringsNbrCommon = commonStrings.length;
            int r = 0;
            for (int i = 0; i < commonStrings.length; ++i) {
                r = (int)((long)r + DataIO.lengthUTFv(commonStrings[i]));
                commonStringsLength += (long)commonStrings[i].length();
            }
            this.sm.stringsCommonChars = r;
            this.sm.stringsSavedExact = this.os.getSavedCharsExact() * 2L;
            this.sm.stringsSavedSubstr = this.os.getSavedCharsSubstr() * 2L;
            this.sm.statDetails[BinaryCasSerDes6.strChars_i].original = this.os.getSavedCharsExact() * 2L + this.os.getSavedCharsSubstr() * 2L + commonStringsLength * 2L;
            int stringHeapStart = this.isSerializingDelta ? this.mark.nextFSId : 1;
            int stringHeapEnd = this.stringHeapObj.getSize();
            this.sm.statDetails[BinaryCasSerDes6.strLength_i].original = (stringHeapEnd - stringHeapStart) * 4;
            this.sm.statDetails[BinaryCasSerDes6.strOffset_i].original = (stringHeapEnd - stringHeapStart) * 4;
        }
    }

    private int getTgtSeqFromSrcFS(TOP fs) {
        if (null == fs) {
            return 0;
        }
        if (this.isTypeMapping && this.typeMapper.mapTypeSrc2Tgt(fs._getTypeImpl()) == null) {
            return 0;
        }
        int v = this.fsStartIndexes.getTgtSeqFromSrcAddr(fs._id);
        assert (v != -1);
        return v;
    }

    TypeSystemImpl getTgtTs() {
        return this.tgtTs;
    }

    private class ReadModifiedFSs {
        private int vPrevModInt = 0;
        private int prevModHeapRefTgtSeq = 0;
        private short vPrevModShort = 0;
        private long vPrevModLong = 0L;
        private int iHeap;
        private FeatureImpl[] tgtF2srcF;
        private FSsTobeAddedback.FSsTobeAddedbackSingle addbackSingle;

        private ReadModifiedFSs() {
        }

        private void readModifiedFSs() throws IOException {
            int modFSsLength = BinaryCasSerDes6.this.readVnumber(BinaryCasSerDes6.this.control_dis);
            int prevSeq = 0;
            if (modFSsLength > 0 && BinaryCasSerDes6.this.allowPreexistingFS == AllowPreexistingFS.disallow) {
                throw new CASRuntimeException("DELTA_CAS_PREEXISTING_FS_DISALLOWED", String.format("%,d pre-existing Feature Structures modified", modFSsLength));
            }
            for (int i = 0; i < modFSsLength; ++i) {
                int seqNbrModified;
                prevSeq = seqNbrModified = BinaryCasSerDes6.this.readDiff(BinaryCasSerDes6.this.fsIndexes_dis, prevSeq);
                TOP fs = BinaryCasSerDes6.this.fsStartIndexes.getSrcFsFromTgtSeq(seqNbrModified);
                if (fs == null) {
                    throw Misc.internalError();
                }
                TypeImpl srcType = fs._getTypeImpl();
                if (BinaryCasSerDes6.this.isTypeMapping) {
                    this.tgtF2srcF = BinaryCasSerDes6.this.typeMapper.getSrcFeatures(BinaryCasSerDes6.this.typeMapper.mapTypeSrc2Tgt(srcType));
                }
                int numberOfModsInThisFs = BinaryCasSerDes6.this.readVnumber(BinaryCasSerDes6.this.fsIndexes_dis);
                if (srcType.isAuxStoredArray()) {
                    this.readModifiedAuxHeap(numberOfModsInThisFs, fs, srcType);
                    continue;
                }
                this.readModifiedMainHeap(numberOfModsInThisFs, fs, srcType);
            }
        }

        private void readModifiedAuxHeap(int numberOfMods, TOP fs, TypeImpl srcType) throws IOException {
            int prevOffset = 0;
            SlotKinds.SlotKind kind = srcType.getComponentSlotKind();
            BooleanArray booleanArray = kind == SlotKinds.SlotKind.Slot_BooleanRef ? (BooleanArray)fs : null;
            ByteArray byteArray = kind == SlotKinds.SlotKind.Slot_ByteRef ? (ByteArray)fs : null;
            ShortArray shortArray = kind == SlotKinds.SlotKind.Slot_ShortRef ? (ShortArray)fs : null;
            LongArray longArray = kind == SlotKinds.SlotKind.Slot_LongRef ? (LongArray)fs : null;
            DoubleArray doubleArray = kind == SlotKinds.SlotKind.Slot_DoubleRef ? (DoubleArray)fs : null;
            block7: for (int i2 = 0; i2 < numberOfMods; ++i2) {
                int offset;
                prevOffset = offset = BinaryCasSerDes6.this.readVnumber(BinaryCasSerDes6.this.fsIndexes_dis) + prevOffset;
                switch (kind) {
                    case Slot_BooleanRef: {
                        booleanArray.set(offset, BinaryCasSerDes6.this.byte_dis.readByte() == 1);
                        continue block7;
                    }
                    case Slot_ByteRef: {
                        byteArray.set(offset, BinaryCasSerDes6.this.byte_dis.readByte());
                        continue block7;
                    }
                    case Slot_ShortRef: {
                        short v;
                        this.vPrevModShort = v = (short)BinaryCasSerDes6.this.readDiff(BinaryCasSerDes6.this.int_dis, this.vPrevModShort);
                        shortArray.set(offset, v);
                        continue block7;
                    }
                    case Slot_LongRef: {
                        long v;
                        this.vPrevModLong = v = BinaryCasSerDes6.this.readLongOrDouble(kind, this.vPrevModLong);
                        longArray.set(offset, v);
                        continue block7;
                    }
                    case Slot_DoubleRef: {
                        doubleArray.set(offset, CASImpl.long2double(BinaryCasSerDes6.this.readDouble()));
                        continue block7;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
            }
        }

        private void readModifiedMainHeap(int numberOfMods, TOP fs, TypeImpl srcType) throws IOException {
            int iPrevTgtOffsetInFs = 0;
            boolean wasRemoved = false;
            this.addbackSingle = BinaryCasSerDes6.this.cas.getAddbackSingle();
            boolean isArray = srcType.isArray();
            FeatureImpl[] features = isArray ? null : srcType.getFeatureImpls();
            block11: for (int i = 0; i < numberOfMods; ++i) {
                SlotKinds.SlotKind kind;
                int srcOffsetInFs;
                int tgtOffsetInFs;
                iPrevTgtOffsetInFs = tgtOffsetInFs = BinaryCasSerDes6.this.readVnumber(BinaryCasSerDes6.this.fsIndexes_dis) + iPrevTgtOffsetInFs;
                int n = srcOffsetInFs = !isArray && BinaryCasSerDes6.this.isTypeMapping ? this.tgtF2srcF[tgtOffsetInFs].getOffset() : tgtOffsetInFs;
                assert (srcOffsetInFs >= 0);
                FeatureImpl srcFeat = features == null ? null : features[srcOffsetInFs];
                SlotKinds.SlotKind slotKind = kind = srcType.isArray() ? srcType.getComponentSlotKind() : srcFeat.getSlotKind();
                if (!isArray && kind != SlotKinds.SlotKind.Slot_HeapRef && !wasRemoved) {
                    wasRemoved = BinaryCasSerDes6.this.cas.checkForInvalidFeatureSetting(fs, srcFeat.getCode(), this.addbackSingle);
                }
                switch (kind) {
                    case Slot_HeapRef: {
                        int tgtSeq;
                        this.prevModHeapRefTgtSeq = tgtSeq = BinaryCasSerDes6.this.readDiff(BinaryCasSerDes6.this.heapRef_dis, this.prevModHeapRefTgtSeq);
                        TOP v = BinaryCasSerDes6.this.getRefVal(tgtSeq);
                        if (isArray) {
                            ((FSArray)fs).set(srcOffsetInFs, v);
                            continue block11;
                        }
                        fs.setFeatureValue(srcFeat, v);
                        continue block11;
                    }
                    case Slot_Int: {
                        int v;
                        this.vPrevModInt = v = BinaryCasSerDes6.this.readDiff(BinaryCasSerDes6.this.int_dis, this.vPrevModInt);
                        if (isArray) {
                            ((IntegerArray)fs).set(srcOffsetInFs, v);
                            continue block11;
                        }
                        fs.setIntValue(srcFeat, v);
                        continue block11;
                    }
                    case Slot_Short: {
                        short v;
                        this.vPrevModShort = v = (short)BinaryCasSerDes6.this.readDiff(BinaryCasSerDes6.this.int_dis, this.vPrevModShort);
                        fs.setShortValue(srcFeat, v);
                        continue block11;
                    }
                    case Slot_LongRef: {
                        long v;
                        this.vPrevModLong = v = BinaryCasSerDes6.this.readLongOrDouble(kind, this.vPrevModLong);
                        fs.setLongValue(srcFeat, v);
                        continue block11;
                    }
                    case Slot_DoubleRef: {
                        long v = BinaryCasSerDes6.this.readDouble();
                        fs.setDoubleValue(srcFeat, CASImpl.long2double(v));
                        continue block11;
                    }
                    case Slot_Float: {
                        float v = Float.intBitsToFloat(BinaryCasSerDes6.this.readFloat());
                        if (isArray) {
                            ((FloatArray)fs).set(srcOffsetInFs, v);
                            continue block11;
                        }
                        fs.setFloatValue(srcFeat, v);
                        continue block11;
                    }
                    case Slot_StrRef: {
                        String v = BinaryCasSerDes6.this.readString(true);
                        if (isArray) {
                            ((StringArray)fs).set(srcOffsetInFs, v);
                            continue block11;
                        }
                        fs.setStringValue(srcFeat, v);
                        continue block11;
                    }
                    case Slot_Boolean: {
                        fs.setBooleanValue(srcFeat, BinaryCasSerDes6.this.byte_dis.readByte() == 1);
                        continue block11;
                    }
                    case Slot_Byte: {
                        fs.setByteValue(srcFeat, BinaryCasSerDes6.this.byte_dis.readByte());
                        continue block11;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
            }
            BinaryCasSerDes6.this.cas.addbackSingleIfWasRemoved(wasRemoved, fs);
        }
    }

    private class SerializeModifiedFSs {
        final CASImpl.FsChange[] modifiedFSs;
        private int vPrevModInt;
        private int vPrevModHeapRef;
        private short vPrevModShort;
        private long vPrevModLong;

        private SerializeModifiedFSs() {
            this.modifiedFSs = BinaryCasSerDes6.this.cas.getModifiedFSList();
            this.vPrevModInt = 0;
            this.vPrevModHeapRef = 0;
            this.vPrevModShort = 0;
            this.vPrevModLong = 0L;
        }

        private void addModifiedStrings() {
            for (CASImpl.FsChange changedFs : this.modifiedFSs) {
                TOP fs = changedFs.fs;
                TypeImpl srcType = fs._getTypeImpl();
                if (BinaryCasSerDes6.this.isTypeMapping && null == BinaryCasSerDes6.this.typeMapper.mapTypeSrc2Tgt(srcType) || !BinaryCasSerDes6.this.foundFSsBelowMark.contains(fs._id)) continue;
                if (changedFs.arrayUpdates != null) {
                    if (!(fs instanceof StringArray)) continue;
                    String[] strings = ((StringArray)fs)._getTheArray();
                    IntListIterator it = changedFs.arrayUpdates.iterator();
                    while (it.hasNext()) {
                        BinaryCasSerDes6.this.os.add(strings[it.nextNvc()]);
                    }
                    continue;
                }
                if (fs instanceof UimaSerializable && !BinaryCasSerDes6.this.uimaSerializableSavedToCas.contains(fs._id)) {
                    ((UimaSerializable)((Object)fs))._save_to_cas_data();
                    BinaryCasSerDes6.this.uimaSerializableSavedToCas.add(fs._id);
                }
                BitSet featuresModified = changedFs.featuresModified;
                int next = featuresModified.nextSetBit(0);
                FeatureImpl[] feats = fs._getTypeImpl().getFeatureImpls();
                while (next >= 0) {
                    FeatureImpl srcFeat = feats[next];
                    if (BinaryCasSerDes6.this.isTypeMapping && BinaryCasSerDes6.this.typeMapper.getTgtFeature(srcType, srcFeat) == null) continue;
                    if (srcFeat.getRangeImpl().isStringOrStringSubtype()) {
                        BinaryCasSerDes6.this.os.add(fs._getStringValueNc(feats[next]));
                    }
                    next = featuresModified.nextSetBit(next + 1);
                }
            }
        }

        private void serializeModifiedFSs() throws IOException {
            int nbrModifiedFSWritten = 0;
            int prevHeapSeq = 0;
            int splitPoint = ((BinaryCasSerDes6)BinaryCasSerDes6.this).mark.nextFSId;
            for (CASImpl.FsChange fsChange : this.modifiedFSs) {
                int id;
                TOP fs = fsChange.fs;
                TypeImpl srcType = fs._getTypeImpl();
                if (BinaryCasSerDes6.this.isTypeMapping && BinaryCasSerDes6.this.typeMapper.mapTypeSrc2Tgt(srcType) == null || (id = fs._id) >= splitPoint && !BinaryCasSerDes6.this.foundFSs.contains(id) || id < splitPoint && !BinaryCasSerDes6.this.foundFSsBelowMark.contains(id)) continue;
                int v = BinaryCasSerDes6.this.fsStartIndexes.getTgtSeqFromSrcAddr(id);
                assert (v != -1);
                prevHeapSeq = BinaryCasSerDes6.this.writeDiff(SlotKindsConstants.fsIndexes_i, v, prevHeapSeq);
                this.writeModsForOneFs(fsChange);
                ++nbrModifiedFSWritten;
            }
            BinaryCasSerDes6.this.writeVnumber(BinaryCasSerDes6.this.control_dos, nbrModifiedFSWritten);
        }

        private void writeModsForOneFs(CASImpl.FsChange fsChange) throws IOException {
            TOP fs = fsChange.fs;
            TypeImpl ti = fs._getTypeImpl();
            if (fsChange.arrayUpdates != null) {
                int prevIndex = 0;
                BinaryCasSerDes6.this.writeVnumber(BinaryCasSerDes6.this.fsIndexes_dos, fsChange.arrayUpdates.size());
                IntListIterator it = fsChange.arrayUpdates.iterator();
                SlotKinds.SlotKind slotKind = ti.getComponentSlotKind();
                block22: while (it.hasNext()) {
                    int index = it.nextNvc();
                    BinaryCasSerDes6.this.writeVnumber(BinaryCasSerDes6.this.fsIndexes_dos, index - prevIndex);
                    prevIndex = index;
                    switch (slotKind) {
                        case Slot_BooleanRef: {
                            BinaryCasSerDes6.this.writeUnsignedByte(BinaryCasSerDes6.this.byte_dos, ((BooleanArray)fs).get(index) ? 1 : 0);
                            continue block22;
                        }
                        case Slot_ByteRef: {
                            BinaryCasSerDes6.this.writeUnsignedByte(BinaryCasSerDes6.this.byte_dos, ((ByteArray)fs).get(index));
                            continue block22;
                        }
                        case Slot_ShortRef: {
                            short vs = ((ShortArray)fs).get(index);
                            BinaryCasSerDes6.this.writeDiff(SlotKindsConstants.int_i, vs, this.vPrevModShort);
                            this.vPrevModShort = vs;
                            continue block22;
                        }
                        case Slot_LongRef: {
                            long v = ((LongArray)fs).get(index);
                            BinaryCasSerDes6.this.writeLong(v, this.vPrevModLong);
                            this.vPrevModLong = v;
                            continue block22;
                        }
                        case Slot_DoubleRef: {
                            long v = Double.doubleToRawLongBits(((DoubleArray)fs).get(index));
                            BinaryCasSerDes6.this.writeDouble(v);
                            continue block22;
                        }
                        case Slot_Int: {
                            this.vPrevModInt = BinaryCasSerDes6.this.writeDiff(SlotKindsConstants.int_i, ((IntegerArray)fs).get(index), this.vPrevModInt);
                            continue block22;
                        }
                        case Slot_Float: {
                            BinaryCasSerDes6.this.writeFloat(CASImpl.float2int(((FloatArray)fs).get(index)));
                            continue block22;
                        }
                        case Slot_HeapRef: {
                            int v = BinaryCasSerDes6.this.getTgtSeqFromSrcFS((TOP)((FSArray)fs).get(index));
                            this.vPrevModHeapRef = BinaryCasSerDes6.this.writeDiff(SlotKindsConstants.heapRef_i, v, this.vPrevModHeapRef);
                            continue block22;
                        }
                        case Slot_StrRef: {
                            BinaryCasSerDes6.this.writeString(((StringArray)fs).get(index));
                            continue block22;
                        }
                    }
                    Misc.internalError();
                }
                return;
            }
            BinaryCasSerDes6.this.writeVnumber(BinaryCasSerDes6.this.fsIndexes_dos, fsChange.featuresModified.cardinality());
            int iPrevOffsetInFs = 0;
            BitSet bs = fsChange.featuresModified;
            int offset = bs.nextSetBit(0);
            while (offset >= 0) {
                BinaryCasSerDes6.this.writeVnumber(BinaryCasSerDes6.this.fsIndexes_dos, offset - iPrevOffsetInFs);
                iPrevOffsetInFs = offset;
                FeatureImpl fi = ti.getFeatureImpls()[offset];
                SlotKinds.SlotKind slotKind = fi.getSlotKind();
                switch (slotKind) {
                    case Slot_Boolean: {
                        BinaryCasSerDes6.this.byte_dos.write(fs._getBooleanValueNc(fi) ? 1 : 0);
                        break;
                    }
                    case Slot_Byte: {
                        BinaryCasSerDes6.this.byte_dos.write(fs._getByteValueNc(fi));
                        break;
                    }
                    case Slot_Short: {
                        this.vPrevModShort = (short)BinaryCasSerDes6.this.writeDiff(SlotKindsConstants.int_i, fs._getShortValueNc(fi), this.vPrevModShort);
                        break;
                    }
                    case Slot_Int: {
                        this.vPrevModInt = BinaryCasSerDes6.this.writeDiff(SlotKindsConstants.int_i, fs._getIntValueNc(fi), this.vPrevModInt);
                        break;
                    }
                    case Slot_LongRef: {
                        long v = fs._getLongValueNc(fi);
                        BinaryCasSerDes6.this.writeLong(v, this.vPrevModLong);
                        this.vPrevModLong = v;
                        break;
                    }
                    case Slot_Float: {
                        BinaryCasSerDes6.this.writeFloat(CASImpl.float2int(fs._getFloatValueNc(fi)));
                        break;
                    }
                    case Slot_DoubleRef: {
                        BinaryCasSerDes6.this.writeDouble(Double.doubleToRawLongBits(fs._getDoubleValueNc(fi)));
                        break;
                    }
                    case Slot_HeapRef: {
                        int v = BinaryCasSerDes6.this.getTgtSeqFromSrcFS(fs._getFeatureValueNc(fi));
                        this.vPrevModHeapRef = BinaryCasSerDes6.this.writeDiff(SlotKindsConstants.heapRef_i, v, this.vPrevModHeapRef);
                        break;
                    }
                    case Slot_StrRef: {
                        BinaryCasSerDes6.this.writeString(fs._getStringValueNc(fi));
                        break;
                    }
                    default: {
                        Misc.internalError();
                    }
                }
                offset = bs.nextSetBit(offset + 1);
            }
        }
    }

    public static class ReuseInfo {
        private final PositiveIntSet foundFSs;
        private final List<TOP> fssToSerialize;
        private final CasSeqAddrMaps fsStartIndexes;

        private ReuseInfo(PositiveIntSet foundFSs, List<TOP> fssToSerialize, CasSeqAddrMaps fsStartIndexes) {
            this.foundFSs = foundFSs;
            this.fssToSerialize = fssToSerialize;
            this.fsStartIndexes = fsStartIndexes;
        }
    }

    public static enum CompressStrat {
        Default(0),
        Filtered(1),
        HuffmanOnly(2);

        public final int strat;

        private CompressStrat(int strat) {
            this.strat = strat;
        }
    }

    public static enum CompressLevel {
        None(0),
        Fast(1),
        Default(-1),
        Best(9);

        public final int lvl;

        private CompressLevel(int lvl) {
            this.lvl = lvl;
        }
    }
}

