/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.uima.CompositeResourceFactory;
import org.apache.uima.ResourceSpecifierFactory;
import org.apache.uima.UIMA_IllegalStateException;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineManagement;
import org.apache.uima.analysis_engine.TextAnalysisEngine;
import org.apache.uima.analysis_engine.impl.AnalysisEngineManagementImpl;
import org.apache.uima.collection.CasConsumer;
import org.apache.uima.collection.CasInitializer;
import org.apache.uima.collection.CollectionProcessingEngine;
import org.apache.uima.collection.CollectionProcessingManager;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.resource.ConfigurationManager;
import org.apache.uima.resource.Resource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.Logger;
import org.apache.uima.util.UimaTimer;
import org.apache.uima.util.XMLParser;

public abstract class UIMAFramework {
    public static final String CAS_INITIAL_HEAP_SIZE = "cas_initial_heap_size";
    public static final String PROCESS_TRACE_ENABLED = "process_trace_enabled";
    public static final Object SOCKET_KEEPALIVE_ENABLED = "socket_keepalive_enabled";
    public static final String JCAS_CACHE_ENABLED = "jcas_cache_enabled";
    public static final String SKIP_USER_JCAS_LOADING = "SKIP_USER_JCAS_LOADING";
    private static final UIMAFramework mInstance;
    private static final String REF_IMPL_CLASS_NAME = "org.apache.uima.impl.UIMAFramework_impl";
    public static final ThreadLocal<ResourceManager> newContextResourceManager;
    public static final ThreadLocal<ConfigurationManager> newContextConfigManager;

    protected abstract Properties _getDefaultPerformanceTuningProperties();

    public static String getVersionString() {
        return UIMAFramework.getMajorVersion() + "." + UIMAFramework.getMinorVersion() + "." + UIMAFramework.getBuildRevision();
    }

    public static short getMajorVersion() {
        return UIMAFramework.getInstance()._getMajorVersion();
    }

    public static short getMinorVersion() {
        return UIMAFramework.getInstance()._getMinorVersion();
    }

    public static short getBuildRevision() {
        return UIMAFramework.getInstance()._getBuildRevision();
    }

    public static CompositeResourceFactory getResourceFactory() {
        return UIMAFramework.getInstance()._getResourceFactory();
    }

    public static ResourceSpecifierFactory getResourceSpecifierFactory() {
        return UIMAFramework.getInstance()._getResourceSpecifierFactory();
    }

    public static XMLParser getXMLParser() {
        return UIMAFramework.getInstance()._getXMLParser();
    }

    public static CollectionProcessingManager newCollectionProcessingManager() {
        return UIMAFramework.getInstance()._newCollectionProcessingManager(null);
    }

    public static CollectionProcessingManager newCollectionProcessingManager(ResourceManager aResourceManager) {
        return UIMAFramework.getInstance()._newCollectionProcessingManager(aResourceManager);
    }

    public static Resource produceResource(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        return UIMAFramework.produceResource(Resource.class, aSpecifier, aAdditionalParams);
    }

    public static Resource produceResource(Class<? extends Resource> aResourceClass, ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        Resource resource = UIMAFramework.getResourceFactory().produceResource(aResourceClass, aSpecifier, aAdditionalParams);
        if (resource == null) {
            throw new ResourceInitializationException("do_not_know_how", new Object[]{aResourceClass.getName(), aSpecifier.getSourceUrlString()});
        }
        return resource;
    }

    public static Resource produceResource(Class<? extends Resource> aResourceClass, ResourceSpecifier aSpecifier, ResourceManager aResourceManager, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (aResourceManager != null) {
            aAdditionalParams = aAdditionalParams == null ? new HashMap<String, Object>() : new HashMap<String, Object>(aAdditionalParams);
            aAdditionalParams.put("RESOURCE_MANAGER", aResourceManager);
        }
        return UIMAFramework.produceResource(aResourceClass, aSpecifier, aAdditionalParams);
    }

    private static void updateAeState(AnalysisEngine ae, long initStartTime) {
        if (ae.getManagementInterface() instanceof AnalysisEngineManagementImpl) {
            ((AnalysisEngineManagementImpl)ae.getManagementInterface()).setState(AnalysisEngineManagement.State.Ready);
            ((AnalysisEngineManagementImpl)ae.getManagementInterface()).setInitializationTime(System.currentTimeMillis() - initStartTime);
        }
    }

    public static AnalysisEngine produceAnalysisEngine(ResourceSpecifier aSpecifier) throws ResourceInitializationException {
        AnalysisEngine ae = null;
        long initStartTime = System.currentTimeMillis();
        ae = (AnalysisEngine)UIMAFramework.produceResource(AnalysisEngine.class, aSpecifier, null);
        UIMAFramework.updateAeState(ae, initStartTime);
        return ae;
    }

    public static AnalysisEngine produceAnalysisEngine(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        AnalysisEngine ae = null;
        long initStartTime = System.currentTimeMillis();
        ae = (AnalysisEngine)UIMAFramework.produceResource(AnalysisEngine.class, aSpecifier, aAdditionalParams);
        UIMAFramework.updateAeState(ae, initStartTime);
        return ae;
    }

    public static AnalysisEngine produceAnalysisEngine(ResourceSpecifier aSpecifier, ResourceManager aResourceManager, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        AnalysisEngine ae = null;
        long initStartTime = System.currentTimeMillis();
        ae = (AnalysisEngine)UIMAFramework.produceResource(AnalysisEngine.class, aSpecifier, aResourceManager, aAdditionalParams);
        UIMAFramework.updateAeState(ae, initStartTime);
        return ae;
    }

    public static AnalysisEngine produceAnalysisEngine(ResourceSpecifier aSpecifier, int aMaxSimultaneousRequests, int aTimeoutPeriod) throws ResourceInitializationException {
        HashMap<String, Object> aAdditionalParams = new HashMap<String, Object>();
        aAdditionalParams.put("NUM_SIMULTANEOUS_REQUESTS", aMaxSimultaneousRequests);
        aAdditionalParams.put("TIMEOUT_PERIOD", aTimeoutPeriod);
        AnalysisEngine ae = null;
        long initStartTime = System.currentTimeMillis();
        ae = (AnalysisEngine)UIMAFramework.produceResource(AnalysisEngine.class, aSpecifier, aAdditionalParams);
        UIMAFramework.updateAeState(ae, initStartTime);
        return ae;
    }

    @Deprecated
    public static TextAnalysisEngine produceTAE(ResourceSpecifier aSpecifier) throws ResourceInitializationException {
        return (TextAnalysisEngine)UIMAFramework.produceResource(TextAnalysisEngine.class, aSpecifier, null);
    }

    @Deprecated
    public static TextAnalysisEngine produceTAE(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        return (TextAnalysisEngine)UIMAFramework.produceResource(TextAnalysisEngine.class, aSpecifier, aAdditionalParams);
    }

    @Deprecated
    public static TextAnalysisEngine produceTAE(ResourceSpecifier aSpecifier, ResourceManager aResourceManager, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        return (TextAnalysisEngine)UIMAFramework.produceResource(TextAnalysisEngine.class, aSpecifier, aResourceManager, aAdditionalParams);
    }

    @Deprecated
    public static TextAnalysisEngine produceTAE(ResourceSpecifier aSpecifier, int aMaxSimultaneousRequests, int aTimeoutPeriod) throws ResourceInitializationException {
        HashMap<String, Object> aAdditionalParams = new HashMap<String, Object>();
        aAdditionalParams.put("NUM_SIMULTANEOUS_REQUESTS", aMaxSimultaneousRequests);
        aAdditionalParams.put("TIMEOUT_PERIOD", aTimeoutPeriod);
        return (TextAnalysisEngine)UIMAFramework.produceResource(TextAnalysisEngine.class, aSpecifier, aAdditionalParams);
    }

    public static CasConsumer produceCasConsumer(ResourceSpecifier aSpecifier) throws ResourceInitializationException {
        return (CasConsumer)UIMAFramework.produceResource(CasConsumer.class, aSpecifier, null);
    }

    public static CasConsumer produceCasConsumer(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        return (CasConsumer)UIMAFramework.produceResource(CasConsumer.class, aSpecifier, aAdditionalParams);
    }

    public static CasConsumer produceCasConsumer(ResourceSpecifier aSpecifier, ResourceManager aResourceManager, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        return (CasConsumer)UIMAFramework.produceResource(CasConsumer.class, aSpecifier, aResourceManager, aAdditionalParams);
    }

    public static CollectionReader produceCollectionReader(ResourceSpecifier aSpecifier) throws ResourceInitializationException {
        return (CollectionReader)UIMAFramework.produceResource(CollectionReader.class, aSpecifier, null);
    }

    public static CollectionReader produceCollectionReader(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        return (CollectionReader)UIMAFramework.produceResource(CollectionReader.class, aSpecifier, aAdditionalParams);
    }

    public static CollectionReader produceCollectionReader(ResourceSpecifier aSpecifier, ResourceManager aResourceManager, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        return (CollectionReader)UIMAFramework.produceResource(CollectionReader.class, aSpecifier, aResourceManager, aAdditionalParams);
    }

    @Deprecated
    public static CasInitializer produceCasInitializer(ResourceSpecifier aSpecifier) throws ResourceInitializationException {
        return (CasInitializer)UIMAFramework.produceResource(CasInitializer.class, aSpecifier, null);
    }

    public static CasInitializer produceCasInitializer(ResourceSpecifier aSpecifier, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        return (CasInitializer)UIMAFramework.produceResource(CasInitializer.class, aSpecifier, aAdditionalParams);
    }

    public static CasInitializer produceCasInitializer(ResourceSpecifier aSpecifier, ResourceManager aResourceManager, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        return (CasInitializer)UIMAFramework.produceResource(CasInitializer.class, aSpecifier, aResourceManager, aAdditionalParams);
    }

    public static CollectionProcessingEngine produceCollectionProcessingEngine(CpeDescription aCpeDescription) throws ResourceInitializationException {
        return UIMAFramework.getInstance()._produceCollectionProcessingEngine(aCpeDescription, null);
    }

    public static CollectionProcessingEngine produceCollectionProcessingEngine(CpeDescription aCpeDescription, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        return UIMAFramework.getInstance()._produceCollectionProcessingEngine(aCpeDescription, aAdditionalParams);
    }

    public static CollectionProcessingEngine produceCollectionProcessingEngine(CpeDescription aCpeDescription, ResourceManager aResourceManager, Map<String, Object> aAdditionalParams) throws ResourceInitializationException {
        if (aResourceManager != null) {
            aAdditionalParams = aAdditionalParams == null ? new HashMap<String, Object>() : new HashMap<String, Object>(aAdditionalParams);
            aAdditionalParams.put("RESOURCE_MANAGER", aResourceManager);
        }
        return UIMAFramework.getInstance()._produceCollectionProcessingEngine(aCpeDescription, aAdditionalParams);
    }

    public static Logger getLogger() {
        return UIMAFramework.getInstance()._getLogger();
    }

    public static Logger getLogger(Class<?> component) {
        return UIMAFramework.getInstance()._getLogger(component);
    }

    public static Logger newLogger() {
        return UIMAFramework.getInstance()._newLogger();
    }

    public static UimaTimer newTimer() {
        return UIMAFramework.getInstance()._newTimer();
    }

    public static ResourceManager newDefaultResourceManager() {
        return UIMAFramework.getInstance()._newDefaultResourceManager();
    }

    public static ResourceManager newDefaultResourceManagerPearWrapper() {
        return UIMAFramework.getInstance()._newDefaultResourceManagerPearWrapper();
    }

    public static ConfigurationManager newConfigurationManager() {
        return UIMAFramework.getInstance()._newConfigurationManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UimaContextAdmin newUimaContext(Logger aLogger, ResourceManager aResourceManager, ConfigurationManager aConfigManager) {
        UimaContextAdmin context;
        try {
            newContextResourceManager.set(aResourceManager);
            newContextConfigManager.set(aConfigManager);
            context = UIMAFramework.getInstance()._newUimaContext();
        }
        finally {
            newContextResourceManager.set(null);
            newContextConfigManager.set(null);
        }
        context.initializeRoot(aLogger, aResourceManager, aConfigManager);
        return context;
    }

    public static Properties getDefaultPerformanceTuningProperties() {
        return UIMAFramework.getInstance()._getDefaultPerformanceTuningProperties();
    }

    protected static UIMAFramework getInstance() {
        return mInstance;
    }

    protected abstract short _getMajorVersion();

    protected abstract short _getMinorVersion();

    protected abstract void _initialize() throws Exception;

    protected abstract short _getBuildRevision();

    protected abstract CompositeResourceFactory _getResourceFactory();

    protected abstract ResourceSpecifierFactory _getResourceSpecifierFactory();

    protected abstract XMLParser _getXMLParser();

    protected abstract CollectionProcessingManager _newCollectionProcessingManager(ResourceManager var1);

    protected abstract Logger _getLogger();

    protected abstract Logger _getLogger(Class<?> var1);

    protected abstract Logger _newLogger();

    protected abstract UimaTimer _newTimer();

    protected abstract ResourceManager _newDefaultResourceManager();

    protected abstract ResourceManager _newDefaultResourceManagerPearWrapper();

    protected abstract ConfigurationManager _newConfigurationManager();

    protected abstract UimaContextAdmin _newUimaContext();

    protected abstract CollectionProcessingEngine _produceCollectionProcessingEngine(CpeDescription var1, Map<String, Object> var2) throws ResourceInitializationException;

    static {
        newContextResourceManager = new ThreadLocal();
        newContextConfigManager = new ThreadLocal();
        String frameworkClassName = null;
        try {
            frameworkClassName = System.getProperty("uima.framework_impl");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (frameworkClassName == null) {
            frameworkClassName = REF_IMPL_CLASS_NAME;
        }
        try {
            Class<?> implClass = Class.forName(frameworkClassName);
            mInstance = (UIMAFramework)implClass.newInstance();
            mInstance._initialize();
        }
        catch (Exception e) {
            System.err.println("Could not create UIMA framework, using framework class name: " + frameworkClassName);
            e.printStackTrace();
            throw new UIMA_IllegalStateException("could_not_create_framework", new Object[]{frameworkClassName}, e);
        }
    }
}

