/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.util.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.UIMAFramework;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.impl.RelativePathResolver_impl;
import org.apache.uima.util.Level;
import org.apache.uima.util.Settings;
import org.apache.uima.util.impl.Constants;

public class Settings_impl
implements Settings {
    protected static final String LOG_RESOURCE_BUNDLE = "org.apache.uima.impl.log_messages";
    private BufferedReader rdr;
    private Map<String, String> map;
    private ThreadLocal<HashMap<String, Integer>> tlResolving = new ThreadLocal<HashMap<String, Integer>>(){

        @Override
        protected synchronized HashMap<String, Integer> initialValue() {
            return new HashMap<String, Integer>();
        }
    };
    private Pattern evalPattern = Pattern.compile("\\$\\{.*?\\}");

    public Settings_impl() {
        this.map = new HashMap<String, String>();
    }

    @Override
    public Set<String> getKeys() {
        return this.map.keySet();
    }

    @Override
    public void load(InputStream in) throws IOException {
        String line;
        this.rdr = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
        String legalPunc = "./-~_";
        while ((line = this.getLine()) != null) {
            String value;
            String[] parts = line.split("\\s*[:=\\s]\\s*", 2);
            String name = parts[0];
            boolean validName = name.length() > 0;
            for (int i = 0; i < name.length() && validName; ++i) {
                validName = Character.isLetterOrDigit(name.charAt(i)) || "./-~_".indexOf(name.charAt(i)) >= 0;
            }
            if (!validName) {
                throw new IOException("Invalid name '" + name + "' --- characters must be alphanumeric or ./-~_");
            }
            if (parts.length == 1) {
                value = "";
            } else {
                value = parts[1];
                if (value.length() > 0 && value.charAt(0) == '[') {
                    value = this.getArray(value);
                }
            }
            if (!this.map.containsKey(name)) {
                this.map.put(name, value);
                continue;
            }
            if (value.equals(this.map.get(name))) continue;
            UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "load", LOG_RESOURCE_BUNDLE, "UIMA_external_override_ignored__CONFIG", new Object[]{name, value});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void loadSystemDefaults() throws ResourceConfigurationException {
        String fnames = System.getProperty("UimaExternalOverrides");
        if (fnames == null) return;
        RelativePathResolver_impl relativePathResolver = new RelativePathResolver_impl();
        for (String fname : fnames.split(",")) {
            UIMAFramework.getLogger(this.getClass()).logrb(Level.CONFIG, this.getClass().getName(), "loadSystemDefaults", LOG_RESOURCE_BUNDLE, "UIMA_external_overrides_load__CONFIG", new Object[]{fname});
            try {
                InputStream is = null;
                if (fname.startsWith("path:")) {
                    URL relativeUrl = new URL("file", "", fname.substring(5).replace('.', '/') + ".settings");
                    URL relPath = relativePathResolver.resolveRelativePath(relativeUrl);
                    if (relPath == null) throw new FileNotFoundException(fname + " - not found in the datapath or classpath.");
                    is = relPath.openStream();
                } else {
                    File f;
                    if (fname.startsWith("file:")) {
                        fname = fname.substring(5);
                    }
                    if (!(f = new File(fname)).exists()) throw new FileNotFoundException(fname + " - not in filesystem.");
                    is = new FileInputStream(fname);
                }
                try {
                    this.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new ResourceConfigurationException("external_override_error", new Object[]{fname}, e);
            }
        }
    }

    @Override
    public String lookUp(String name) throws ResourceConfigurationException {
        return this.lookUp(name, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String lookUp(String from, String name) throws ResourceConfigurationException {
        HashMap<String, Integer> resolving = this.tlResolving.get();
        if (resolving.containsKey(name)) {
            System.err.println("Circular evaluation of property: '" + name + "' - definitions are:");
            for (String s : resolving.keySet()) {
                System.err.println(resolving.get(s) + ": " + s + " = " + this.map.get(s));
            }
            throw new ResourceConfigurationException("external_override_circular_reference", new Object[]{name, from});
        }
        resolving.put(name, resolving.size());
        try {
            String string = this.resolve(from, this.map.get(name));
            return string;
        }
        finally {
            resolving.remove(name);
        }
    }

    public String resolve(String value) throws Exception {
        return this.unescape(this.resolve(value, value));
    }

    private String resolve(String from, String value) throws ResourceConfigurationException {
        if (value == null) {
            return null;
        }
        Matcher matcher = this.evalPattern.matcher(value);
        if (!matcher.find()) {
            return value;
        }
        StringBuilder result = new StringBuilder(value.length() + 100);
        if (this.isEscaped(value, matcher.start())) {
            result.append(value.substring(0, matcher.start() - 1));
            result.append("${");
            result.append(this.resolve(from, value.substring(matcher.start() + 2)));
            return result.toString();
        }
        result.append(value.substring(0, matcher.start()));
        String remainder = this.resolve(from, value.substring(matcher.start() + 2));
        int end = remainder.indexOf(125);
        if (end < 0) {
            result.append("${");
            result.append(remainder);
        } else {
            String key = remainder.substring(0, end);
            if (end > 0) {
                String val = this.lookUp(from, key);
                if (val == null) {
                    throw new ResourceConfigurationException("external_override_invalid", new Object[]{key, from});
                }
                result.append(val);
            }
            result.append(remainder.substring(end + 1));
        }
        return result.toString();
    }

    @Override
    public String getSetting(String name) throws ResourceConfigurationException {
        String value = this.lookUp(name, name);
        if (value == null) {
            return null;
        }
        if (value.length() >= 2 && value.charAt(0) == '[' && value.charAt(value.length() - 1) == ']' && value.charAt(value.length() - 2) != '\\') {
            throw new ResourceConfigurationException("external_override_type_mismatch", new Object[]{name});
        }
        return this.unescape(value);
    }

    @Override
    public String[] getSettingArray(String name) throws ResourceConfigurationException {
        String value = this.lookUp(name, name);
        if (value == null) {
            return null;
        }
        if (value.length() < 2 || value.charAt(0) != '[' || value.charAt(value.length() - 1) != ']' || value.charAt(value.length() - 2) == '\\') {
            throw new ResourceConfigurationException("external_override_type_mismatch", new Object[]{name});
        }
        if ((value = value.substring(1, value.length() - 1)).length() == 0) {
            return Constants.EMPTY_STRING_ARRAY;
        }
        String[] tokens = value.split(",");
        int nTokens = tokens.length;
        int last = tokens.length - 1;
        for (int i = 0; i < last; ++i) {
            if (!this.endsWithEscape(tokens[i])) continue;
            tokens[i + 1] = tokens[i] + "," + tokens[i + 1];
            tokens[i] = null;
            --nTokens;
        }
        if (this.endsWithEscape(tokens[last])) {
            int n = last;
            tokens[n] = tokens[n] + ",";
        }
        String[] result = new String[nTokens];
        int i = 0;
        for (String token : tokens) {
            if (token == null) continue;
            result[i++] = this.unescape(token.trim());
        }
        return result;
    }

    private String unescape(String token) {
        int next = token.indexOf(92);
        if (next < 0) {
            return token;
        }
        StringBuilder result = new StringBuilder(token.length());
        int last = 0;
        while (next >= 0) {
            result.append(token.substring(last, next));
            last = next + 1;
            next = token.indexOf(92, last + 1);
        }
        result.append(token.substring(last));
        return result.toString();
    }

    private boolean endsWithEscape(String line) {
        int i;
        for (i = line.length(); i > 0 && line.charAt(i - 1) == '\\'; --i) {
        }
        return (line.length() - i) % 2 != 0;
    }

    private String getArray(String line) throws IOException {
        int iend = line.indexOf(93);
        while (iend >= 0 && this.isEscaped(line, iend)) {
            iend = line.indexOf(93, iend + 1);
        }
        if (iend >= 0) {
            if (iend + 1 < line.length()) {
                throw new IOException("Syntax error - invalid character(s) '" + line.substring(iend + 1, line.length()) + "' after end of array");
            }
            return line;
        }
        String nextline = this.getLine();
        if (nextline == null) {
            throw new IOException("Premature EOF - missing ']'");
        }
        iend = line.length() - 1;
        if (line.charAt(iend) == ',' && !this.isEscaped(line, iend) || line.equals("[") || nextline.charAt(0) == ']') {
            return line + this.getArray(nextline);
        }
        return line + "," + this.getArray(nextline);
    }

    private String getLine() throws IOException {
        String line = this.rdr.readLine();
        if (line == null) {
            return null;
        }
        String trimmed = line.trim();
        if (trimmed.length() == 0 || trimmed.charAt(0) == '#' || trimmed.charAt(0) == '!') {
            return this.getLine();
        }
        if (!this.isEscaped(line, line.length())) {
            return trimmed;
        }
        return this.extendLine(trimmed);
    }

    private String extendLine(String line) throws IOException {
        int ilast = ((String)line).length() - 1;
        String next = this.rdr.readLine();
        if (next == null) {
            next = "";
        }
        line = ((String)line).substring(0, ilast) + next.trim();
        if (!this.isEscaped(next, next.length())) {
            return ((String)line).trim();
        }
        return this.extendLine((String)line);
    }

    private boolean isEscaped(String line, int ichar) {
        int i;
        for (i = ichar - 1; i >= 0 && line.charAt(i) == '\\'; --i) {
        }
        return (ichar - i) % 2 == 0;
    }
}

