/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vinci.transport.vns.service;

import org.apache.vinci.debug.Debug;
import org.apache.vinci.transport.vns.service.VNS;

class BackupThread
implements Runnable {
    VNS parent;
    String backupFile;
    String configFile = null;
    String counterFile = null;
    int interval;
    protected volatile boolean stop = false;

    public BackupThread(VNS parent, String backupFile, String configFile, int interval, String counterFile) {
        this.parent = parent;
        this.backupFile = new String(backupFile);
        if (configFile != null) {
            this.configFile = new String(configFile);
        }
        if (counterFile != null) {
            this.counterFile = new String(counterFile);
        }
        this.interval = interval * 1000;
    }

    public void forceWrite() {
        this.parent.saveConfig(this.backupFile);
        if (this.configFile != null) {
            this.parent.saveConfig(this.configFile);
        }
        if (this.counterFile != null) {
            this.parent.saveCounters(this.counterFile);
        }
        Debug.p("All files written to disk");
    }

    @Override
    public void run() {
        Debug.p("Backup thread started");
        do {
            this.parent.saveConfig(this.backupFile);
            if (this.configFile != null) {
                this.parent.saveConfig(this.configFile);
            }
            if (this.counterFile != null) {
                this.parent.saveCounters(this.counterFile);
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                break;
            }
        } while (!this.stop);
        Debug.p("Backup thread exitted");
    }
}

