/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Collections;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.SelectFSs;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.SelectFSs_impl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.CommonList;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;

public abstract class FSList<T extends TOP>
extends TOP
implements CommonList,
Iterable<T> {
    protected FSList() {
    }

    public FSList(JCas jcas) {
        super(jcas);
    }

    public FSList(TypeImpl t, CASImpl c) {
        super(t, c);
    }

    public T getNthElement(int i) {
        FSList node = (FSList)this.getNthNode(i);
        if (node instanceof EmptyFSList) {
            throw new CASRuntimeException("JCAS_GET_NTH_PAST_END", Integer.toString(i));
        }
        return ((NonEmptyFSList)node).getHead();
    }

    @Override
    public NonEmptyFSList<T> createNonEmptyNode() {
        return new NonEmptyFSList((JCas)this._casView.getJCasImpl());
    }

    @Override
    public NonEmptyFSList<T> pushNode() {
        CommonList n = this.createNonEmptyNode();
        ((NonEmptyFSList)n).setTail(this);
        return n;
    }

    public <U extends T> SelectFSs<U> select() {
        return new SelectFSs_impl(this);
    }

    public <U extends T> SelectFSs<U> select(Type filterByType) {
        return new SelectFSs_impl(this).type(filterByType);
    }

    public <U extends T> SelectFSs<U> select(Class<U> filterByType) {
        return new SelectFSs_impl(this).type(filterByType);
    }

    public <U extends T> SelectFSs<U> select(int filterByType) {
        return new SelectFSs_impl(this).type(filterByType);
    }

    public <U extends T> SelectFSs<U> select(String filterByType) {
        return new SelectFSs_impl(this).type(filterByType);
    }

    public static <U extends TOP, E extends FeatureStructure> FSList<U> create(JCas jcas, E[] a) {
        FSList fsl = jcas.getCasImpl().emptyFSList();
        for (int i = a.length - 1; i >= 0; --i) {
            fsl = fsl.push((TOP)a[i]);
        }
        return fsl;
    }

    @Override
    public Iterator<T> iterator() {
        return Collections.emptyIterator();
    }

    public NonEmptyFSList<T> push(T item) {
        return new NonEmptyFSList<T>(this._casView.getJCasImpl(), item, this);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Override
    public EmptyFSList emptyList() {
        return this._casView.emptyFSList();
    }

    public boolean contains(T v) {
        FSList node = this;
        while (node instanceof NonEmptyFSList) {
            NonEmptyFSList n = (NonEmptyFSList)node;
            if (n.getHead() == v) {
                return true;
            }
            node = n.getTail();
        }
        return false;
    }
}

