/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.web;

import java.util.Date;
import java.util.List;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.web.Changes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletCommon {
    private static final Logger logger = LoggerFactory.getLogger((String)ServletCommon.class.getName());

    public static String getProfileIdCookieValue(HttpServletRequest httpServletRequest, String profileIdCookieName) {
        String cookieProfileId = null;
        Cookie[] cookies = httpServletRequest.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!profileIdCookieName.equals(cookie.getName())) continue;
                cookieProfileId = cookie.getValue();
            }
        }
        return cookieProfileId;
    }

    public static Changes handleEvents(List<Event> events, Session session, Profile profile, ServletRequest request, ServletResponse response, Date timestamp, PrivacyService privacyService, EventService eventService) {
        List filteredEventTypes = privacyService.getFilteredEventTypes(profile);
        String thirdPartyId = eventService.authenticateThirdPartyServer(((HttpServletRequest)request).getHeader("X-Unomi-Peer"), request.getRemoteAddr());
        int changes = 0;
        int processedEventsCnt = 0;
        if (events != null && !(profile instanceof Persona)) {
            for (Event event : events) {
                ++processedEventsCnt;
                if (event.getEventType() == null) continue;
                Event eventToSend = new Event(event.getEventType(), session, profile, event.getScope(), event.getSource(), event.getTarget(), event.getProperties(), timestamp, event.isPersistent());
                if (!eventService.isEventAllowed(event, thirdPartyId)) {
                    logger.warn("Event is not allowed : {}", (Object)event.getEventType());
                    continue;
                }
                if (thirdPartyId != null && event.getItemId() != null) {
                    eventToSend = new Event(event.getItemId(), event.getEventType(), session, profile, event.getScope(), event.getSource(), event.getTarget(), event.getProperties(), timestamp, event.isPersistent());
                }
                if (filteredEventTypes != null && filteredEventTypes.contains(event.getEventType())) {
                    logger.debug("Profile is filtering event type {}", (Object)event.getEventType());
                    continue;
                }
                if (profile.isAnonymousProfile()) {
                    eventToSend.setProfileId(null);
                }
                eventToSend.getAttributes().put("http_request", request);
                eventToSend.getAttributes().put("http_response", response);
                logger.debug("Received event " + event.getEventType() + " for profile=" + profile.getItemId() + " session=" + (session != null ? session.getItemId() : null) + " target=" + event.getTarget() + " timestamp=" + timestamp);
                changes = eventService.send(eventToSend);
                if ((changes & 4) == 4) {
                    profile = eventToSend.getProfile();
                }
                if ((changes & 1) != 1) continue;
                logger.error("Error processing events. Total number of processed events: {}/{}", (Object)(--processedEventsCnt), (Object)events.size());
                break;
            }
        }
        return new Changes(changes, processedEventsCnt, profile);
    }
}

