/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.openapi;

import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.ApplicationInfo;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.doc.DocumentationProvider;
import org.apache.cxf.jaxrs.model.doc.JavaDocProvider;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;

public class OpenApiCustomizer {
    private boolean dynamicBasePath;
    private boolean replaceTags;
    private DocumentationProvider javadocProvider;
    private List<ClassResourceInfo> cris;
    private String applicationPath;

    public OpenAPIConfiguration customize(OpenAPIConfiguration configuration) {
        if (configuration == null) {
            return configuration;
        }
        if (this.dynamicBasePath) {
            MessageContext ctx = this.createMessageContext();
            String url = StringUtils.removeEnd((String)StringUtils.substringBeforeLast((String)ctx.getUriInfo().getRequestUri().toString(), (String)"/"), (String)this.applicationPath);
            List servers = configuration.getOpenAPI().getServers();
            if (servers == null || servers.stream().noneMatch(s -> s.getUrl().equalsIgnoreCase(url))) {
                configuration.getOpenAPI().setServers(Collections.singletonList(new Server().url(url)));
            }
        }
        return configuration;
    }

    public void customize(OpenAPI oas) {
        if (this.replaceTags || this.javadocProvider != null) {
            HashMap operations = new HashMap();
            HashMap methods = new HashMap();
            this.cris.forEach(cri -> cri.getMethodDispatcher().getOperationResourceInfos().forEach(ori -> {
                String normalizedPath = this.getNormalizedPath(cri.getURITemplate().getValue(), ori.getURITemplate().getValue());
                operations.put(normalizedPath, cri);
                methods.put(Pair.of((Object)ori.getHttpMethod(), (Object)normalizedPath), ori);
            }));
            ArrayList tags = new ArrayList();
            oas.getPaths().forEach((pathKey, pathItem) -> {
                Tag tag = null;
                if (this.replaceTags && operations.containsKey(pathKey)) {
                    ClassResourceInfo cri = (ClassResourceInfo)operations.get(pathKey);
                    tag = new Tag();
                    tag.setName(cri.getURITemplate().getValue().replaceAll("/", "_"));
                    if (this.javadocProvider != null) {
                        tag.setDescription(this.javadocProvider.getClassDoc(cri));
                    }
                    if (!tags.contains(tag)) {
                        tags.add(tag);
                    }
                }
                for (Map.Entry subentry : pathItem.readOperationsMap().entrySet()) {
                    Pair key;
                    if (this.replaceTags && tag != null) {
                        ((Operation)subentry.getValue()).setTags(Collections.singletonList(tag.getName()));
                    }
                    if (!methods.containsKey(key = Pair.of((Object)((PathItem.HttpMethod)subentry.getKey()).name(), (Object)pathKey)) || this.javadocProvider == null) continue;
                    OperationResourceInfo ori = (OperationResourceInfo)methods.get(key);
                    if (StringUtils.isBlank((CharSequence)((Operation)subentry.getValue()).getSummary())) {
                        ((Operation)subentry.getValue()).setSummary(this.javadocProvider.getMethodDoc(ori));
                    }
                    if (((Operation)subentry.getValue()).getParameters() == null) {
                        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
                        this.addParameters(parameters);
                        ((Operation)subentry.getValue()).setParameters(parameters);
                    } else {
                        for (int i = 0; i < ((Operation)subentry.getValue()).getParameters().size(); ++i) {
                            if (!StringUtils.isBlank((CharSequence)((Parameter)((Operation)subentry.getValue()).getParameters().get(i)).getDescription())) continue;
                            ((Parameter)((Operation)subentry.getValue()).getParameters().get(i)).setDescription(this.javadocProvider.getMethodParameterDoc(ori, i));
                        }
                        this.addParameters(((Operation)subentry.getValue()).getParameters());
                    }
                    this.customizeResponses((Operation)subentry.getValue(), ori);
                }
            });
            if (this.replaceTags && oas.getTags() != null) {
                oas.setTags(tags);
            }
        }
    }

    protected String getNormalizedPath(String classResourcePath, String operationResourcePath) {
        String[] segments;
        StringBuilder normalizedPath = new StringBuilder();
        for (String segment : segments = (classResourcePath + operationResourcePath).split("/")) {
            if (StringUtils.isEmpty((CharSequence)segment)) continue;
            normalizedPath.append('/').append(segment);
        }
        if (normalizedPath.toString().endsWith(":.*}")) {
            normalizedPath.setLength(normalizedPath.length() - 4);
            normalizedPath.append('}');
        }
        return "".equals(normalizedPath.toString()) ? "/" : normalizedPath.toString();
    }

    protected void addParameters(List<Parameter> parameters) {
    }

    protected void customizeResponses(Operation operation, OperationResourceInfo ori) {
        ApiResponse response;
        if (operation.getResponses() != null && !operation.getResponses().isEmpty() && (StringUtils.isBlank((CharSequence)(response = (ApiResponse)((Map.Entry)operation.getResponses().entrySet().iterator().next()).getValue()).getDescription()) || StringUtils.isNotBlank((CharSequence)this.javadocProvider.getMethodResponseDoc(ori)) && "default response".equals(response.getDescription()))) {
            response.setDescription(this.javadocProvider.getMethodResponseDoc(ori));
        }
    }

    public void setDynamicBasePath(boolean dynamicBasePath) {
        this.dynamicBasePath = dynamicBasePath;
    }

    public void setReplaceTags(boolean replaceTags) {
        this.replaceTags = replaceTags;
    }

    public void setJavadocProvider(DocumentationProvider javadocProvider) {
        this.javadocProvider = javadocProvider;
    }

    public void setClassResourceInfos(List<ClassResourceInfo> classResourceInfos) {
        this.cris = classResourceInfos;
    }

    public void setJavaDocPath(String javaDocPath) throws Exception {
        this.javadocProvider = new JavaDocProvider(javaDocPath);
    }

    public void setJavaDocPaths(String ... javaDocPaths) throws Exception {
        this.javadocProvider = new JavaDocProvider(javaDocPaths);
    }

    public void setJavaDocURLs(URL[] javaDocURLs) {
        this.javadocProvider = new JavaDocProvider(javaDocURLs);
    }

    public void setApplicationInfo(ApplicationInfo application) {
        Class<?> clazz;
        ApplicationPath path;
        if (application != null && application.getProvider() != null && (path = ResourceUtils.locateApplicationPath(clazz = ((Application)application.getProvider()).getClass())) != null) {
            this.applicationPath = path.value();
            if (!this.applicationPath.startsWith("/")) {
                this.applicationPath = "/" + this.applicationPath;
            }
            if (this.applicationPath.endsWith("/")) {
                this.applicationPath = this.applicationPath.substring(0, this.applicationPath.lastIndexOf(47));
            }
        }
    }

    private MessageContext createMessageContext() {
        return (MessageContext)JAXRSUtils.createContextValue((Message)JAXRSUtils.getCurrentMessage(), null, MessageContext.class);
    }
}

