/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j2.internal;

import java.io.FileInputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.ops4j.pax.logging.EventAdminPoster;
import org.ops4j.pax.logging.PaxLoggingConstants;
import org.ops4j.pax.logging.PaxLoggingService;
import org.ops4j.pax.logging.log4j2.internal.PaxLoggingServiceImpl;
import org.ops4j.pax.logging.spi.support.BackendSupport;
import org.ops4j.pax.logging.spi.support.ConfigurationNotifier;
import org.ops4j.pax.logging.spi.support.DefaultServiceLog;
import org.ops4j.pax.logging.spi.support.FallbackLogFactory;
import org.ops4j.pax.logging.spi.support.LogReaderServiceImpl;
import org.ops4j.pax.logging.spi.support.OsgiUtil;
import org.ops4j.pax.logging.spi.support.RegisteredService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.log.LogReaderService;

public class Activator
implements BundleActivator {
    private static final String PAX_LOGGING_PROPERTY_FILE = "pax-logging.properties";
    private ServiceRegistration<?> m_RegistrationPaxLogging;
    private PaxLoggingServiceImpl m_PaxLogging;
    private RegisteredService<LogReaderService, LogReaderServiceImpl> logReaderInfo;
    private RegisteredService<EventAdminPoster, EventAdminPoster> eventAdminInfo;
    private RegisteredService<ConfigurationNotifier, ConfigurationNotifier> eventAdminConfigurationNotifierInfo;
    private BundleContext bundleContext;

    public void start(BundleContext bundleContext) throws Exception {
        this.sanityCheck();
        this.bundleContext = bundleContext;
        String levelName = BackendSupport.defaultLogLevel(bundleContext);
        DefaultServiceLog.setLogLevel(levelName);
        this.logReaderInfo = BackendSupport.createAndRegisterLogReaderService(bundleContext);
        this.eventAdminInfo = BackendSupport.eventAdminSupport(bundleContext);
        this.eventAdminConfigurationNotifierInfo = BackendSupport.eventAdminConfigurationNotifier(bundleContext);
        this.m_PaxLogging = new PaxLoggingServiceImpl(bundleContext, this.logReaderInfo.getService(), this.eventAdminInfo.getService(), this.eventAdminConfigurationNotifierInfo.getService());
        Path configFilePath = Paths.get(this.externalFile(), new String[0]);
        if (configFilePath.toFile().isFile()) {
            try (FileInputStream inputStream = new FileInputStream(configFilePath.toFile());){
                ConfigurationAdmin configurationAdmin;
                Properties properties = new Properties();
                properties.load(inputStream);
                Hashtable<String, String> config = new Hashtable<String, String>();
                StrSubstitutor strSubstitutor = new StrSubstitutor(System.getProperties());
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    String propValue = (String)entry.getValue();
                    propValue = strSubstitutor.replace(propValue);
                    ((Dictionary)config).put((String)entry.getKey(), propValue);
                }
                ServiceReference sr = bundleContext.getServiceReference(ConfigurationAdmin.class);
                if (sr != null && (configurationAdmin = (ConfigurationAdmin)bundleContext.getService(sr)) != null) {
                    Configuration configuration = configurationAdmin.getConfiguration("org.ops4j.pax.logging", "?");
                    configuration.update(config);
                }
                this.m_PaxLogging.updated(config);
            }
        }
        Hashtable<String, Object> serviceProperties = new Hashtable<String, Object>();
        ((Dictionary)serviceProperties).put("service.pid", "org.ops4j.pax.logging");
        ((Dictionary)serviceProperties).put("service.ranking", BackendSupport.paxLoggingServiceRanking(bundleContext));
        this.m_RegistrationPaxLogging = bundleContext.registerService(PaxLoggingConstants.LOGGING_LOGSERVICE_NAMES, (Object)this.m_PaxLogging, serviceProperties);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.eventAdminInfo != null) {
            this.eventAdminInfo.close();
        }
        if (this.logReaderInfo != null) {
            this.logReaderInfo.close();
        }
        if (this.eventAdminConfigurationNotifierInfo != null) {
            this.eventAdminConfigurationNotifierInfo.close();
        }
        this.m_RegistrationPaxLogging.unregister();
        this.m_RegistrationPaxLogging = null;
        if (this.m_PaxLogging != null) {
            this.m_PaxLogging.shutdown();
            this.m_PaxLogging = null;
        }
        FallbackLogFactory.cleanup();
    }

    private void sanityCheck() {
        Bundle paxLoggingApi = FrameworkUtil.getBundle(PaxLoggingService.class);
        Bundle paxLoggingLog4J2 = FrameworkUtil.getBundle(this.getClass());
    }

    private String externalFile() {
        String property = OsgiUtil.systemOrContextProperty(this.bundleContext, "org.ops4j.pax.logging.property.file");
        return property == null ? PAX_LOGGING_PROPERTY_FILE : property;
    }
}

