/*
 * Decompiled with CFR 0.152.
 */
package nonapi.io.github.classgraph.fastzipfilereader;

import java.io.IOException;
import nonapi.io.github.classgraph.WhiteBlackList;
import nonapi.io.github.classgraph.fastzipfilereader.FastZipEntry;
import nonapi.io.github.classgraph.fastzipfilereader.PhysicalZipFile;

public class ZipFileSlice {
    final ZipFileSlice parentZipFileSlice;
    public final PhysicalZipFile physicalZipFile;
    final long startOffsetWithinPhysicalZipFile;
    final long len;
    String name;

    ZipFileSlice(PhysicalZipFile physicalZipFile) {
        this.parentZipFileSlice = null;
        this.physicalZipFile = physicalZipFile;
        this.startOffsetWithinPhysicalZipFile = 0L;
        this.len = physicalZipFile.fileLen;
        this.name = physicalZipFile.getPath();
    }

    ZipFileSlice(PhysicalZipFile physicalZipFileInRam, FastZipEntry zipEntry) {
        this.parentZipFileSlice = zipEntry.parentLogicalZipFile;
        this.physicalZipFile = physicalZipFileInRam;
        this.startOffsetWithinPhysicalZipFile = 0L;
        this.len = this.physicalZipFile.fileLen;
        this.name = zipEntry.entryName;
    }

    ZipFileSlice(FastZipEntry zipEntry) throws IOException {
        this.parentZipFileSlice = zipEntry.parentLogicalZipFile;
        this.physicalZipFile = zipEntry.parentLogicalZipFile.physicalZipFile;
        this.startOffsetWithinPhysicalZipFile = zipEntry.getEntryDataStartOffsetWithinPhysicalZipFile();
        this.len = zipEntry.compressedSize;
        this.name = zipEntry.entryName;
    }

    ZipFileSlice(ZipFileSlice other) {
        this.parentZipFileSlice = other.parentZipFileSlice;
        this.physicalZipFile = other.physicalZipFile;
        this.startOffsetWithinPhysicalZipFile = other.startOffsetWithinPhysicalZipFile;
        this.len = other.len;
        this.name = other.name;
    }

    public boolean isWhitelistedAndNotBlacklisted(WhiteBlackList.WhiteBlackListLeafname jarWhiteBlackList) {
        if (!jarWhiteBlackList.isWhitelistedAndNotBlacklisted(this.name)) {
            return false;
        }
        return this.parentZipFileSlice == null || this.parentZipFileSlice.isWhitelistedAndNotBlacklisted(jarWhiteBlackList);
    }

    private void getPath(StringBuilder buf) {
        if (this.parentZipFileSlice != null) {
            this.parentZipFileSlice.getPath(buf);
        }
        if (buf.length() > 0) {
            buf.append("!/");
        }
        buf.append(this.name);
    }

    public String getPath() {
        StringBuilder buf = new StringBuilder();
        this.getPath(buf);
        return buf.toString();
    }

    public int hashCode() {
        return this.physicalZipFile.getPath().hashCode() ^ (int)this.startOffsetWithinPhysicalZipFile ^ (int)this.len;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ZipFileSlice)) {
            return false;
        }
        ZipFileSlice o = (ZipFileSlice)obj;
        return this.startOffsetWithinPhysicalZipFile == o.startOffsetWithinPhysicalZipFile && this.len == o.len && this.physicalZipFile.equals(o.physicalZipFile);
    }

    public String toString() {
        return (this.physicalZipFile.isDeflatedToRam ? "[ByteBuffer deflated to RAM]" : this.physicalZipFile.getFile()) + " [byte range " + this.startOffsetWithinPhysicalZipFile + ".." + (this.startOffsetWithinPhysicalZipFile + this.len) + " / " + this.physicalZipFile.fileLen + "]";
    }
}

