/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.migration.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.shell.api.console.Session;
import org.apache.unomi.shell.migration.Migration;
import org.apache.unomi.shell.migration.utils.ConsoleUtils;
import org.apache.unomi.shell.migration.utils.HttpUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

@Command(scope="unomi", name="migrate", description="This will Migrate your date in ES to be compliant with current version")
@Service
public class Migrate
implements Action {
    @Reference
    Session session;
    @Reference
    BundleContext bundleContext;
    @Argument(name="fromVersionWithoutSuffix", description="Origin version without suffix/qualifier (e.g: 1.2.0)", multiValued=false, valueToShowInHelp="1.2.0")
    private String fromVersionWithoutSuffix;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute() throws Exception {
        if (this.fromVersionWithoutSuffix == null) {
            this.listMigrations();
            return null;
        }
        String confirmation = ConsoleUtils.askUserWithAuthorizedAnswer(this.session, "[WARNING] You are about to execute a migration, this a very sensitive operation, are you sure? (yes/no): ", Arrays.asList("yes", "no"));
        if (confirmation.equalsIgnoreCase("no")) {
            System.out.println("Migration process aborted");
            return null;
        }
        System.out.println("Starting migration process from version: " + this.fromVersionWithoutSuffix);
        Version fromVersion = new Version(this.fromVersionWithoutSuffix);
        Version currentVersion = this.getCurrentVersionWithoutQualifier();
        System.out.println("current version: " + currentVersion.toString());
        if (currentVersion.compareTo(fromVersion) <= 0) {
            System.out.println("From version is same or superior than current version, nothing to migrate.");
            return null;
        }
        try (CloseableHttpClient httpClient = null;){
            httpClient = HttpUtils.initHttpClient(this.session);
            String esAddress = ConsoleUtils.askUserWithDefaultAnswer(this.session, "Enter ElasticSearch 7 TARGET address (default = http://localhost:9200): ", "http://localhost:9200");
            for (Migration migration : this.getMigrations()) {
                if (fromVersion.compareTo(migration.getToVersion()) >= 0) continue;
                String migrateConfirmation = ConsoleUtils.askUserWithAuthorizedAnswer(this.session, "Starting migration to version " + migration.getToVersion() + ", do you want to proceed? (yes/no): ", Arrays.asList("yes", "no"));
                if (migrateConfirmation.equalsIgnoreCase("no")) {
                    System.out.println("Migration process aborted");
                    break;
                }
                migration.execute(this.session, httpClient, esAddress, this.bundleContext);
                System.out.println("Migration to version " + migration.getToVersion() + " done successfully");
            }
        }
        return null;
    }

    private Version getCurrentVersionWithoutQualifier() {
        Version currentVersion = this.bundleContext.getBundle().getVersion();
        return new Version(currentVersion.getMajor() + "." + currentVersion.getMinor() + "." + currentVersion.getMicro());
    }

    private void listMigrations() {
        Version previousVersion = new Version("0.0.0");
        for (Migration migration : this.getMigrations()) {
            if (migration.getToVersion().getMajor() > previousVersion.getMajor() || migration.getToVersion().getMinor() > previousVersion.getMinor()) {
                System.out.println("From " + migration.getToVersion().getMajor() + "." + migration.getToVersion().getMinor() + ".0:");
            }
            System.out.println("- " + migration.getToVersion() + " " + migration.getDescription());
            previousVersion = migration.getToVersion();
        }
        System.out.println("Select your migration starting point by specifying the current version (e.g. 1.2.0) or the last script that was already run (e.g. 1.2.1)");
    }

    private List<Migration> getMigrations() {
        Collection migrationServiceReferences = null;
        try {
            migrationServiceReferences = this.bundleContext.getServiceReferences(Migration.class, null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        TreeSet<Migration> migrations = new TreeSet<Migration>(new Comparator<Migration>(){

            @Override
            public int compare(Migration o1, Migration o2) {
                return o1.getToVersion().compareTo(o2.getToVersion());
            }
        });
        for (ServiceReference migrationServiceReference : migrationServiceReferences) {
            Migration migration = (Migration)this.bundleContext.getService(migrationServiceReference);
            migrations.add(migration);
        }
        return new ArrayList<Migration>(migrations);
    }
}

