/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml;

import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;

public class DeleteCalendarEventRequest
extends ActionRequest {
    private final String eventId;
    private final String calendarId;

    public DeleteCalendarEventRequest(String calendarId, String eventId) {
        this.calendarId = Objects.requireNonNull(calendarId, "[calendar_id] must not be null.");
        this.eventId = Objects.requireNonNull(eventId, "[event_id] must not be null.");
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getCalendarId() {
        return this.calendarId;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.calendarId);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DeleteCalendarEventRequest that = (DeleteCalendarEventRequest)other;
        return Objects.equals(this.eventId, that.eventId) && Objects.equals(this.calendarId, that.calendarId);
    }
}

