/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.watcher;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.client.NodesResponseHeader;
import org.elasticsearch.client.watcher.QueuedWatch;
import org.elasticsearch.client.watcher.WatchExecutionSnapshot;
import org.elasticsearch.client.watcher.WatcherMetaData;
import org.elasticsearch.client.watcher.WatcherState;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;

public class WatcherStatsResponse {
    private final List<Node> nodes;
    private final NodesResponseHeader header;
    private final String clusterName;
    private final WatcherMetaData watcherMetaData;
    private static ConstructingObjectParser<WatcherStatsResponse, Void> PARSER = new ConstructingObjectParser("watcher_stats_response", true, a -> new WatcherStatsResponse((NodesResponseHeader)a[0], (String)a[1], new WatcherMetaData((Boolean)a[2]), (List)a[3]));

    public WatcherStatsResponse(NodesResponseHeader header, String clusterName, WatcherMetaData watcherMetaData, List<Node> nodes) {
        this.nodes = nodes;
        this.header = header;
        this.clusterName = clusterName;
        this.watcherMetaData = watcherMetaData;
    }

    public WatcherMetaData getWatcherMetaData() {
        return this.watcherMetaData;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public NodesResponseHeader getHeader() {
        return this.header;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public static WatcherStatsResponse fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatcherStatsResponse that = (WatcherStatsResponse)o;
        return Objects.equals(this.nodes, that.nodes) && Objects.equals(this.header, that.header) && Objects.equals(this.clusterName, that.clusterName) && Objects.equals(this.watcherMetaData, that.watcherMetaData);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.header, this.clusterName, this.watcherMetaData);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), NodesResponseHeader::fromXContent, new ParseField("_nodes", new String[0]));
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("cluster_name", new String[0]));
        PARSER.declareBoolean(ConstructingObjectParser.constructorArg(), new ParseField("manually_stopped", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> Node.PARSER.apply(p, null), new ParseField("stats", new String[0]));
    }

    public static class Node {
        public static final ConstructingObjectParser<Node, Void> PARSER = new ConstructingObjectParser<Node, Void>("watcher_stats_node", true, (args, c) -> new Node((String)args[0], WatcherState.valueOf(((String)args[1]).toUpperCase(Locale.ROOT)), (Long)args[2], (Long)((Tuple)args[3]).v1(), (Long)((Tuple)args[3]).v2(), (List)args[4], (List)args[5], (Map)args[6]));
        private static final ConstructingObjectParser<Tuple<Long, Long>, Void> THREAD_POOL_PARSER = new ConstructingObjectParser<Tuple, Void>("execution_thread_pool", true, (args, id) -> new Tuple<Long, Long>((Long)args[0], (Long)args[1]));
        private final String nodeId;
        private WatcherState watcherState;
        private long watchesCount;
        private long threadPoolQueueSize;
        private long threadPoolMaxSize;
        private List<WatchExecutionSnapshot> snapshots;
        private List<QueuedWatch> queuedWatches;
        private Map<String, Object> stats;

        public Node(String nodeId, WatcherState watcherState, long watchesCount, long threadPoolQueueSize, long threadPoolMaxSize, List<WatchExecutionSnapshot> snapshots, List<QueuedWatch> queuedWatches, Map<String, Object> stats) {
            this.nodeId = nodeId;
            this.watcherState = watcherState;
            this.watchesCount = watchesCount;
            this.threadPoolQueueSize = threadPoolQueueSize;
            this.threadPoolMaxSize = threadPoolMaxSize;
            this.snapshots = snapshots;
            this.queuedWatches = queuedWatches;
            this.stats = stats;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public long getWatchesCount() {
            return this.watchesCount;
        }

        public WatcherState getWatcherState() {
            return this.watcherState;
        }

        public long getThreadPoolQueueSize() {
            return this.threadPoolQueueSize;
        }

        public long getThreadPoolMaxSize() {
            return this.threadPoolMaxSize;
        }

        public List<WatchExecutionSnapshot> getSnapshots() {
            return this.snapshots;
        }

        public List<QueuedWatch> getQueuedWatches() {
            return this.queuedWatches;
        }

        public Map<String, Object> getStats() {
            return this.stats;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.watchesCount == node.watchesCount && this.threadPoolQueueSize == node.threadPoolQueueSize && this.threadPoolMaxSize == node.threadPoolMaxSize && Objects.equals(this.nodeId, node.nodeId) && this.watcherState == node.watcherState && Objects.equals(this.snapshots, node.snapshots) && Objects.equals(this.queuedWatches, node.queuedWatches) && Objects.equals(this.stats, node.stats);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.nodeId, this.watcherState, this.watchesCount, this.threadPoolQueueSize, this.threadPoolMaxSize, this.snapshots, this.queuedWatches, this.stats});
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("node_id", new String[0]));
            PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField("watcher_state", new String[0]));
            PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("watch_count", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), THREAD_POOL_PARSER::apply, new ParseField("execution_thread_pool", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), WatchExecutionSnapshot.PARSER, new ParseField("current_watches", new String[0]));
            PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), QueuedWatch.PARSER, new ParseField("queued_watches", new String[0]));
            PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), new ParseField("stats", new String[0]));
            THREAD_POOL_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("queue_size", new String[0]));
            THREAD_POOL_PARSER.declareLong(ConstructingObjectParser.constructorArg(), new ParseField("max_size", new String[0]));
        }
    }
}

