/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.alias;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.RequestValidators;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexAliasesService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.index.Index;
import org.elasticsearch.rest.action.admin.indices.AliasesNotFoundException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndicesAliasesAction
extends TransportMasterNodeAction<IndicesAliasesRequest, AcknowledgedResponse> {
    private final MetaDataIndexAliasesService indexAliasesService;
    private final RequestValidators<IndicesAliasesRequest> requestValidators;

    @Inject
    public TransportIndicesAliasesAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetaDataIndexAliasesService indexAliasesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, RequestValidators<IndicesAliasesRequest> requestValidators) {
        super("indices:admin/aliases", transportService, clusterService, threadPool, actionFilters, IndicesAliasesRequest::new, indexNameExpressionResolver);
        this.indexAliasesService = indexAliasesService;
        this.requestValidators = Objects.requireNonNull(requestValidators);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesAliasesRequest request, ClusterState state) {
        HashSet indices = new HashSet();
        for (IndicesAliasesRequest.AliasActions aliasAction : request.aliasActions()) {
            Collections.addAll(indices, aliasAction.indices());
        }
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices.toArray(new String[indices.size()]));
    }

    @Override
    protected void masterOperation(IndicesAliasesRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        List<IndicesAliasesRequest.AliasActions> actions = request.aliasActions();
        ArrayList<AliasAction> finalActions = new ArrayList<AliasAction>();
        HashSet aliases = new HashSet();
        for (IndicesAliasesRequest.AliasActions action : actions) {
            Index[] concreteIndices = this.indexNameExpressionResolver.concreteIndices(state, request.indicesOptions(), action.indices());
            Optional<Exception> maybeException = this.requestValidators.validateRequest(request, state, concreteIndices);
            if (maybeException.isPresent()) {
                listener.onFailure(maybeException.get());
                return;
            }
            Collections.addAll(aliases, action.getOriginalAliases());
            block6: for (Index index : concreteIndices) {
                switch (action.actionType()) {
                    case ADD: {
                        for (String alias : TransportIndicesAliasesAction.concreteAliases(action, state.metaData(), index.getName())) {
                            finalActions.add(new AliasAction.Add(index.getName(), alias, action.filter(), action.indexRouting(), action.searchRouting(), action.writeIndex()));
                        }
                        continue block6;
                    }
                    case REMOVE: {
                        for (String alias : TransportIndicesAliasesAction.concreteAliases(action, state.metaData(), index.getName())) {
                            finalActions.add(new AliasAction.Remove(index.getName(), alias));
                        }
                        continue block6;
                    }
                    case REMOVE_INDEX: {
                        finalActions.add(new AliasAction.RemoveIndex(index.getName()));
                        continue block6;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported action [" + (Object)((Object)action.actionType()) + "]");
                    }
                }
            }
        }
        if (finalActions.isEmpty() && !actions.isEmpty()) {
            throw new AliasesNotFoundException(aliases.toArray(new String[aliases.size()]));
        }
        request.aliasActions().clear();
        IndicesAliasesClusterStateUpdateRequest updateRequest = (IndicesAliasesClusterStateUpdateRequest)((IndicesAliasesClusterStateUpdateRequest)new IndicesAliasesClusterStateUpdateRequest(Collections.unmodifiableList(finalActions)).ackTimeout(request.timeout())).masterNodeTimeout(request.masterNodeTimeout());
        this.indexAliasesService.indicesAliases(updateRequest, new ActionListener<ClusterStateUpdateResponse>(){

            @Override
            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse(new AcknowledgedResponse(response.isAcknowledged()));
            }

            @Override
            public void onFailure(Exception t) {
                TransportIndicesAliasesAction.this.logger.debug("failed to perform aliases", (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    private static String[] concreteAliases(IndicesAliasesRequest.AliasActions action, MetaData metaData, String concreteIndex) {
        if (action.expandAliasesWildcards()) {
            String[] indexAsArray = new String[]{concreteIndex};
            ImmutableOpenMap<String, List<AliasMetaData>> aliasMetaData = metaData.findAliases(action, indexAsArray);
            ArrayList<String> finalAliases = new ArrayList<String>();
            for (ObjectCursor curAliases : aliasMetaData.values()) {
                for (AliasMetaData aliasMeta : (List)curAliases.value) {
                    finalAliases.add(aliasMeta.alias());
                }
            }
            return finalAliases.toArray(new String[finalAliases.size()]);
        }
        return action.aliases();
    }
}

