/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.hbase;

import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractSearchConditionVisitor;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.RegexStringComparator;
import org.apache.hadoop.hbase.filter.SingleColumnValueFilter;

public class HBaseQueryVisitor<T>
extends AbstractSearchConditionVisitor<T, Filter> {
    private final Deque<List<Filter>> queryStack = new ArrayDeque<List<Filter>>();
    private String family;
    private Map<String, String> familyMap;

    public HBaseQueryVisitor(String family) {
        this(family, Collections.emptyMap());
    }

    public HBaseQueryVisitor(String family, Map<String, String> fieldsMap) {
        super(fieldsMap);
        this.family = family;
        this.queryStack.push(new ArrayList());
    }

    public HBaseQueryVisitor(Map<String, String> familyMap) {
        this(familyMap, Collections.emptyMap());
    }

    public HBaseQueryVisitor(Map<String, String> familyMap, Map<String, String> fieldsMap) {
        super(fieldsMap);
        this.familyMap = familyMap;
        this.queryStack.push(new ArrayList());
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement = sc.getStatement();
        if (statement != null) {
            if (statement.getProperty() != null) {
                this.queryStack.peek().add(this.buildSimpleQuery(sc.getConditionType(), statement.getProperty(), statement.getValue()));
            }
        } else {
            this.queryStack.push(new ArrayList());
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                condition.accept(this);
            }
            boolean orCondition = sc.getConditionType() == ConditionType.OR;
            List<Filter> queries = this.queryStack.pop();
            this.queryStack.peek().add(this.createCompositeQuery(queries, orCondition));
        }
    }

    @Override
    public Filter getQuery() {
        List<Filter> queries = this.queryStack.peek();
        return queries.isEmpty() ? null : queries.get(0);
    }

    private Filter buildSimpleQuery(ConditionType ct, String name, Object value) {
        name = super.getRealPropertyName(name);
        this.validatePropertyValue(name, value);
        Class<?> clazz = this.getPrimitiveFieldClass(name, value.getClass());
        CompareFilter.CompareOp compareOp = null;
        boolean regexCompRequired = false;
        switch (ct) {
            case EQUALS: {
                compareOp = CompareFilter.CompareOp.EQUAL;
                regexCompRequired = String.class == clazz && value.toString().endsWith("*");
                break;
            }
            case NOT_EQUALS: {
                compareOp = CompareFilter.CompareOp.NOT_EQUAL;
                regexCompRequired = String.class == clazz && value.toString().endsWith("*");
                break;
            }
            case GREATER_THAN: {
                compareOp = CompareFilter.CompareOp.GREATER;
                break;
            }
            case GREATER_OR_EQUALS: {
                compareOp = CompareFilter.CompareOp.GREATER_OR_EQUAL;
                break;
            }
            case LESS_THAN: {
                compareOp = CompareFilter.CompareOp.LESS;
                break;
            }
            case LESS_OR_EQUALS: {
                compareOp = CompareFilter.CompareOp.LESS_OR_EQUAL;
                break;
            }
        }
        String qualifier = name;
        String theFamily = this.family != null ? this.family : this.familyMap.get(qualifier);
        RegexStringComparator byteArrayComparable = regexCompRequired ? new RegexStringComparator(value.toString().replace("*", ".")) : new BinaryComparator(value.toString().getBytes(StandardCharsets.UTF_8));
        return new SingleColumnValueFilter(theFamily.getBytes(StandardCharsets.UTF_8), qualifier.getBytes(StandardCharsets.UTF_8), compareOp, (ByteArrayComparable)byteArrayComparable);
    }

    private Filter createCompositeQuery(List<Filter> queries, boolean orCondition) {
        FilterList.Operator oper = orCondition ? FilterList.Operator.MUST_PASS_ONE : FilterList.Operator.MUST_PASS_ALL;
        FilterList list = new FilterList(oper);
        for (Filter query : queries) {
            list.addFilter(query);
        }
        return list;
    }
}

