/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.cfg.context;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.Map;
import org.hibernate.validator.cfg.ConstraintDef;
import org.hibernate.validator.internal.metadata.location.ConstraintLocation;
import org.hibernate.validator.internal.metadata.raw.ExecutableElement;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationDescriptor;
import org.hibernate.validator.internal.util.annotationfactory.AnnotationFactory;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

class ConfiguredConstraint<A extends Annotation> {
    private static final Log log = LoggerFactory.make();
    private final ConstraintDefAccessor<A> constraint;
    private final ConstraintLocation location;
    private final ElementType elementType;

    private ConfiguredConstraint(ConstraintDef<?, A> constraint, ConstraintLocation location, ElementType elementType) {
        this.constraint = new ConstraintDefAccessor(constraint);
        this.location = location;
        this.elementType = elementType;
    }

    static <A extends Annotation> ConfiguredConstraint<A> forType(ConstraintDef<?, A> constraint, Class<?> beanType) {
        return new ConfiguredConstraint<A>(constraint, ConstraintLocation.forClass(beanType), ElementType.TYPE);
    }

    static <A extends Annotation> ConfiguredConstraint<A> forProperty(ConstraintDef<?, A> constraint, Member member) {
        return new ConfiguredConstraint<A>(constraint, ConstraintLocation.forProperty(member), member instanceof Field ? ElementType.FIELD : ElementType.METHOD);
    }

    public static <A extends Annotation> ConfiguredConstraint<A> forParameter(ConstraintDef<?, A> constraint, ExecutableElement executable, int parameterIndex) {
        return new ConfiguredConstraint<A>(constraint, ConstraintLocation.forParameter(executable, parameterIndex), executable.getElementType());
    }

    public static <A extends Annotation> ConfiguredConstraint<A> forReturnValue(ConstraintDef<?, A> constraint, ExecutableElement executable) {
        return new ConfiguredConstraint<A>(constraint, ConstraintLocation.forReturnValue(executable), executable.getElementType());
    }

    public static <A extends Annotation> ConfiguredConstraint<A> forCrossParameter(ConstraintDef<?, A> constraint, ExecutableElement executable) {
        return new ConfiguredConstraint<A>(constraint, ConstraintLocation.forCrossParameter(executable), executable.getElementType());
    }

    public ConstraintDef<?, A> getConstraint() {
        return this.constraint;
    }

    public ConstraintLocation getLocation() {
        return this.location;
    }

    public Class<A> getConstraintType() {
        return ((ConstraintDefAccessor)this.constraint).getConstraintType();
    }

    public Map<String, Object> getParameters() {
        return ((ConstraintDefAccessor)this.constraint).getParameters();
    }

    public A createAnnotationProxy() {
        AnnotationDescriptor<A> annotationDescriptor = new AnnotationDescriptor<A>(this.getConstraintType());
        for (Map.Entry<String, Object> parameter : this.getParameters().entrySet()) {
            annotationDescriptor.setValue(parameter.getKey(), parameter.getValue());
        }
        try {
            return AnnotationFactory.create(annotationDescriptor);
        }
        catch (RuntimeException e) {
            throw log.getUnableToCreateAnnotationForConfiguredConstraintException(e);
        }
    }

    public String toString() {
        return this.constraint.toString();
    }

    public ElementType getElementType() {
        return this.elementType;
    }

    private static class ConstraintDefAccessor<A extends Annotation>
    extends ConstraintDef<ConstraintDefAccessor<A>, A> {
        private ConstraintDefAccessor(ConstraintDef<?, A> original) {
            super(original);
        }

        private Class<A> getConstraintType() {
            return this.constraintType;
        }

        private Map<String, Object> getParameters() {
            return this.parameters;
        }
    }
}

