/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.access;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.hibernate.RegionCache;
import com.hazelcast.hibernate.access.AccessDelegate;
import com.hazelcast.hibernate.region.AbstractTransactionalDataRegion;
import com.hazelcast.hibernate.region.HazelcastRegion;
import com.hazelcast.logging.ILogger;
import java.util.Comparator;
import java.util.Properties;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.SoftLock;

public abstract class AbstractAccessDelegate<T extends HazelcastRegion>
implements AccessDelegate<T> {
    protected final ILogger log;
    protected final T hazelcastRegion;
    protected final RegionCache cache;
    protected final Comparator<Object> versionComparator;

    protected AbstractAccessDelegate(T hazelcastRegion, Properties props) {
        this.hazelcastRegion = hazelcastRegion;
        this.log = hazelcastRegion.getLogger();
        this.versionComparator = hazelcastRegion instanceof AbstractTransactionalDataRegion ? ((AbstractTransactionalDataRegion)hazelcastRegion).getCacheDataDescription().getVersionComparator() : null;
        this.cache = hazelcastRegion.getCache();
    }

    @Override
    public final T getHazelcastRegion() {
        return this.hazelcastRegion;
    }

    @Override
    public Object get(Object key, long txTimestamp) throws CacheException {
        try {
            return this.cache.get(key, txTimestamp);
        }
        catch (HazelcastException e) {
            if (this.log.isFinestEnabled()) {
                this.log.finest("Could not read from Cache[" + this.hazelcastRegion.getName() + "]: " + e.getMessage());
            }
            return null;
        }
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version) throws CacheException {
        try {
            return this.cache.put(key, value, txTimestamp, version);
        }
        catch (HazelcastException e) {
            if (this.log.isFinestEnabled()) {
                this.log.finest("Could not put into Cache[" + this.hazelcastRegion.getName() + "]: " + e.getMessage());
            }
            return false;
        }
    }

    @Override
    public boolean putFromLoad(Object key, Object value, long txTimestamp, Object version, boolean minimalPuts) throws CacheException {
        return this.putFromLoad(key, value, txTimestamp, version);
    }

    @Override
    public void evict(Object key) throws CacheException {
        this.cache.remove(key);
    }

    @Override
    public void evictAll() throws CacheException {
        this.cache.clear();
    }

    @Override
    public SoftLock lockRegion() throws CacheException {
        return null;
    }

    @Override
    public void unlockRegion(SoftLock lock) throws CacheException {
        this.cache.clear();
    }
}

