/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebService;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.ContextRequest;
import org.apache.unomi.api.ContextResponse;
import org.apache.unomi.api.Persona;
import org.apache.unomi.api.PersonalizationResult;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.PersonalizationService;
import org.apache.unomi.api.services.PrivacyService;
import org.apache.unomi.api.services.RulesService;
import org.apache.unomi.persistence.spi.CustomObjectMapper;
import org.apache.unomi.rest.exception.InvalidRequestException;
import org.apache.unomi.rest.service.RestServiceUtils;
import org.apache.unomi.schema.api.SchemaService;
import org.apache.unomi.utils.EventsRequestContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/")
@Component(service={ContextJsonEndpoint.class}, property={"osgi.jaxrs.resource=true"})
public class ContextJsonEndpoint {
    private static final Logger logger = LoggerFactory.getLogger((String)ContextJsonEndpoint.class.getName());
    private final boolean sanitizeConditions = Boolean.parseBoolean(System.getProperty("org.apache.unomi.security.personalization.sanitizeConditions", "true"));
    @Context
    ServletContext context;
    @Context
    HttpServletRequest request;
    @Context
    HttpServletResponse response;
    @Reference
    private PrivacyService privacyService;
    @Reference
    private RulesService rulesService;
    @Reference
    private PersonalizationService personalizationService;
    @Reference
    private RestServiceUtils restServiceUtils;
    @Reference
    private SchemaService schemaService;

    @OPTIONS
    @Path(value="/context.js")
    public Response contextJSAsOptions() {
        return Response.status((Response.Status)Response.Status.NO_CONTENT).header("Access-Control-Allow-Origin", (Object)"*").build();
    }

    @OPTIONS
    @Path(value="/context.json")
    public Response contextJSONAsOptions() {
        return this.contextJSAsOptions();
    }

    @POST
    @Produces(value={"text/plain"})
    @Path(value="/context.js")
    public Response contextJSAsPost(ContextRequest contextRequest, @QueryParam(value="personaId") String personaId, @QueryParam(value="sessionId") String sessionId, @QueryParam(value="timestamp") Long timestampAsLong, @QueryParam(value="invalidateProfile") boolean invalidateProfile, @QueryParam(value="invalidateSession") boolean invalidateSession) throws JsonProcessingException {
        return this.contextJSAsGet(contextRequest, personaId, sessionId, timestampAsLong, invalidateProfile, invalidateSession);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="/context.js")
    public Response contextJSAsGet(@QueryParam(value="payload") ContextRequest contextRequest, @QueryParam(value="personaId") String personaId, @QueryParam(value="sessionId") String sessionId, @QueryParam(value="timestamp") Long timestampAsLong, @QueryParam(value="invalidateProfile") boolean invalidateProfile, @QueryParam(value="invalidateSession") boolean invalidateSession) throws JsonProcessingException {
        ContextResponse contextResponse = this.contextJSONAsPost(contextRequest, personaId, sessionId, timestampAsLong, invalidateProfile, invalidateSession);
        String contextAsJSONString = CustomObjectMapper.getObjectMapper().writeValueAsString((Object)contextResponse);
        StringBuilder responseAsString = new StringBuilder();
        responseAsString.append("window.digitalData = window.digitalData || {};\n").append("var cxs = ").append(contextAsJSONString).append(";\n");
        return Response.ok((Object)responseAsString.toString()).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/context.json")
    public ContextResponse contextJSONAsGet(@QueryParam(value="payload") ContextRequest contextRequest, @QueryParam(value="personaId") String personaId, @QueryParam(value="sessionId") String sessionId, @QueryParam(value="timestamp") Long timestampAsLong, @QueryParam(value="invalidateProfile") boolean invalidateProfile, @QueryParam(value="invalidateSession") boolean invalidateSession) {
        return this.contextJSONAsPost(contextRequest, personaId, sessionId, timestampAsLong, invalidateProfile, invalidateSession);
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="/context.json")
    public ContextResponse contextJSONAsPost(ContextRequest contextRequest, @QueryParam(value="personaId") String personaId, @QueryParam(value="sessionId") String sessionId, @QueryParam(value="timestamp") Long timestampAsLong, @QueryParam(value="invalidateProfile") boolean invalidateProfile, @QueryParam(value="invalidateSession") boolean invalidateSession) {
        ObjectNode paramsAsJson = JsonNodeFactory.instance.objectNode();
        paramsAsJson.put("personaId", personaId);
        paramsAsJson.put("sessionId", sessionId);
        if (!this.schemaService.isValid(paramsAsJson.toString(), "https://unomi.apache.org/schemas/json/rest/requestIds/1-0-0")) {
            throw new InvalidRequestException("Invalid parameter", "Invalid received data");
        }
        Date timestamp = new Date();
        if (timestampAsLong != null) {
            timestamp = new Date(timestampAsLong);
        }
        String profileId = null;
        String scope = null;
        if (contextRequest != null) {
            scope = contextRequest.getSource() != null ? contextRequest.getSource().getScope() : scope;
            sessionId = contextRequest.getSessionId() != null ? contextRequest.getSessionId() : sessionId;
            profileId = contextRequest.getProfileId();
        }
        EventsRequestContext eventsRequestContext = this.restServiceUtils.initEventsRequest(scope, sessionId, profileId, personaId, invalidateProfile, invalidateSession, this.request, this.response, timestamp);
        ContextResponse contextResponse = new ContextResponse();
        if (contextRequest != null) {
            eventsRequestContext = this.processContextRequest(contextRequest, contextResponse, eventsRequestContext);
        }
        this.restServiceUtils.finalizeEventsRequest(eventsRequestContext, false);
        contextResponse.setProfileId(eventsRequestContext.getProfile().getItemId());
        if (eventsRequestContext.getSession() != null) {
            contextResponse.setSessionId(eventsRequestContext.getSession().getItemId());
        } else if (sessionId != null) {
            contextResponse.setSessionId(sessionId);
        }
        return contextResponse;
    }

    private EventsRequestContext processContextRequest(ContextRequest contextRequest, ContextResponse data, EventsRequestContext eventsRequestContext) {
        List personalizations;
        this.processOverrides(contextRequest, eventsRequestContext.getProfile(), eventsRequestContext.getSession());
        eventsRequestContext = this.restServiceUtils.performEventsRequest(contextRequest.getEvents(), eventsRequestContext);
        data.setProcessedEvents(eventsRequestContext.getProcessedItems());
        List filterNodes = contextRequest.getFilters();
        if (filterNodes != null) {
            data.setFilteringResults(new HashMap());
            for (PersonalizationService.PersonalizedContent personalizedContent : this.sanitizePersonalizedContentObjects(filterNodes)) {
                data.getFilteringResults().put(personalizedContent.getId(), this.personalizationService.filter(eventsRequestContext.getProfile(), eventsRequestContext.getSession(), personalizedContent));
            }
        }
        if ((personalizations = contextRequest.getPersonalizations()) != null) {
            data.setPersonalizationResults(new HashMap());
            data.setPersonalizations(new HashMap());
            for (PersonalizationService.PersonalizationRequest personalization : this.sanitizePersonalizations(personalizations)) {
                PersonalizationResult personalizationResult = this.personalizationService.personalizeList(eventsRequestContext.getProfile(), eventsRequestContext.getSession(), personalization);
                eventsRequestContext.addChanges(personalizationResult.getChangeType());
                data.getPersonalizationResults().put(personalization.getId(), personalizationResult);
                data.getPersonalizations().put(personalization.getId(), personalizationResult.getContentIds());
            }
        }
        if (contextRequest.isRequireSegments()) {
            data.setProfileSegments(eventsRequestContext.getProfile().getSegments());
        }
        if (contextRequest.isRequireScores()) {
            data.setProfileScores(eventsRequestContext.getProfile().getScores());
        }
        if (contextRequest.getRequiredProfileProperties() != null) {
            HashMap hashMap = new HashMap(eventsRequestContext.getProfile().getProperties());
            if (!contextRequest.getRequiredProfileProperties().contains("*")) {
                hashMap.keySet().retainAll(contextRequest.getRequiredProfileProperties());
            }
            data.setProfileProperties(hashMap);
        }
        if (eventsRequestContext.getSession() != null) {
            data.setSessionId(eventsRequestContext.getSession().getItemId());
            if (contextRequest.getRequiredSessionProperties() != null) {
                HashMap hashMap = new HashMap(eventsRequestContext.getSession().getProperties());
                if (!contextRequest.getRequiredSessionProperties().contains("*")) {
                    hashMap.keySet().retainAll(contextRequest.getRequiredSessionProperties());
                }
                data.setSessionProperties(hashMap);
            }
        }
        if (!(eventsRequestContext.getProfile() instanceof Persona)) {
            data.setTrackedConditions(this.rulesService.getTrackedConditions(contextRequest.getSource()));
        } else {
            data.setTrackedConditions(Collections.emptySet());
        }
        data.setAnonymousBrowsing(this.privacyService.isRequireAnonymousBrowsing(eventsRequestContext.getProfile()).booleanValue());
        data.setConsents(eventsRequestContext.getProfile().getConsents());
        return eventsRequestContext;
    }

    private void processOverrides(ContextRequest contextRequest, Profile profile, Session session) {
        if (profile instanceof Persona && contextRequest.getProfileOverrides() != null) {
            if (contextRequest.getProfileOverrides().getScores() != null) {
                profile.setScores(contextRequest.getProfileOverrides().getScores());
            }
            if (contextRequest.getProfileOverrides().getSegments() != null) {
                profile.setSegments(contextRequest.getProfileOverrides().getSegments());
            }
            if (contextRequest.getProfileOverrides().getProperties() != null) {
                profile.setProperties(contextRequest.getProfileOverrides().getProperties());
            }
            if (contextRequest.getSessionPropertiesOverrides() != null && session != null) {
                session.setProperties(contextRequest.getSessionPropertiesOverrides());
            }
        }
    }

    public void destroy() {
        logger.info("Context servlet shutdown.");
    }

    private List<PersonalizationService.PersonalizedContent> sanitizePersonalizedContentObjects(List<PersonalizationService.PersonalizedContent> personalizedContentObjects) {
        if (!this.sanitizeConditions) {
            return personalizedContentObjects;
        }
        ArrayList<PersonalizationService.PersonalizedContent> result = new ArrayList<PersonalizationService.PersonalizedContent>();
        for (PersonalizationService.PersonalizedContent personalizedContentObject : personalizedContentObjects) {
            boolean foundInvalidCondition = false;
            if (personalizedContentObject.getFilters() != null) {
                for (PersonalizationService.Filter filter : personalizedContentObject.getFilters()) {
                    if (this.sanitizeCondition(filter.getCondition()) != null) continue;
                    foundInvalidCondition = true;
                    break;
                }
            }
            if (foundInvalidCondition) continue;
            result.add(personalizedContentObject);
        }
        return result;
    }

    private List<PersonalizationService.PersonalizationRequest> sanitizePersonalizations(List<PersonalizationService.PersonalizationRequest> personalizations) {
        if (!this.sanitizeConditions) {
            return personalizations;
        }
        ArrayList<PersonalizationService.PersonalizationRequest> result = new ArrayList<PersonalizationService.PersonalizationRequest>();
        for (PersonalizationService.PersonalizationRequest personalizationRequest : personalizations) {
            List<PersonalizationService.PersonalizedContent> personalizedContents = this.sanitizePersonalizedContentObjects(personalizationRequest.getContents());
            if (personalizedContents == null || personalizedContents.isEmpty()) continue;
            result.add(personalizationRequest);
        }
        return result;
    }

    private Condition sanitizeCondition(Condition condition) {
        LinkedHashMap newParameterValues = new LinkedHashMap();
        for (Map.Entry parameterEntry : condition.getParameterValues().entrySet()) {
            Object sanitizedValue = this.sanitizeValue(parameterEntry.getValue());
            if (sanitizedValue != null) {
                newParameterValues.put((String)parameterEntry.getKey(), parameterEntry.getValue());
                continue;
            }
            return null;
        }
        return condition;
    }

    private Object sanitizeValue(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (stringValue.startsWith("script::") || stringValue.startsWith("parameter::")) {
                logger.warn("Scripting detected in context request, filtering out. See debug level for more information");
                if (logger.isDebugEnabled()) {
                    logger.debug("Scripting detected in context request with value {}, filtering out...", value);
                }
                return null;
            }
            return stringValue;
        }
        if (value instanceof List) {
            List values = (List)value;
            ArrayList<Object> newValues = new ArrayList<Object>();
            for (Object listObject : values) {
                Object newObject = this.sanitizeValue(listObject);
                if (newObject == null) continue;
                newValues.add(newObject);
            }
            return values;
        }
        if (value instanceof Map) {
            LinkedHashMap newMap = new LinkedHashMap();
            ((Map)value).forEach((key, value1) -> {
                Object newObject = this.sanitizeValue(value1);
                if (newObject != null) {
                    newMap.put(key, newObject);
                }
            });
            return newMap;
        }
        if (value instanceof Condition) {
            return this.sanitizeCondition((Condition)value);
        }
        return value;
    }
}

