/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.rest.endpoints;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.cxf.rs.security.cors.CrossOriginResourceSharing;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.services.UserListService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebService
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@CrossOriginResourceSharing(allowAllOrigins=true, allowCredentials=true)
@Path(value="/userList")
@Component(service={UserListServiceEndPoint.class}, property={"osgi.jaxrs.resource=true"})
public class UserListServiceEndPoint {
    private static final Logger logger = LoggerFactory.getLogger((String)UserListServiceEndPoint.class.getName());
    @Reference
    private UserListService userListService;

    public UserListServiceEndPoint() {
        logger.info("Initializing user lists service endpoint...");
    }

    @WebMethod(exclude=true)
    public void setUserListService(UserListService userListService) {
        this.userListService = userListService;
    }

    @GET
    @Path(value="/")
    public List<Metadata> getUserListsMetadatas(@QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="size") @DefaultValue(value="50") int size, @QueryParam(value="sort") String sortBy) {
        return this.userListService.getUserListMetadatas(offset, size, sortBy).getList();
    }
}

