/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.shell.commands;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.common.DataTable;
import org.apache.unomi.shell.commands.ListCommandSupport;

@Command(scope="unomi", name="segment-list", description="This will list all the segments present in the Apache Unomi Context Server")
@Service
public class SegmentList
extends ListCommandSupport {
    @Reference
    SegmentService segmentService;
    @Argument(index=0, name="maxEntries", description="The maximum number of entries to retrieve (defaults to 100)", required=false, multiValued=false)
    int maxEntries = 100;

    @Override
    protected String[] getHeaders() {
        return new String[]{"Enabled", "Hidden", "Id", "Scope", "Name", "System tags"};
    }

    @Override
    protected DataTable buildDataTable() {
        PartialList segmentMetadatas = this.segmentService.getSegmentMetadatas(0, this.maxEntries, null);
        DataTable dataTable = new DataTable();
        for (Metadata metadata : segmentMetadatas.getList()) {
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(metadata.isEnabled() ? "x" : "");
            rowData.add(metadata.isHidden() ? "x" : "");
            rowData.add(metadata.getId());
            rowData.add(metadata.getScope());
            rowData.add(metadata.getName());
            rowData.add(StringUtils.join((Iterable)metadata.getSystemTags(), (String)","));
            dataTable.addRow(rowData.toArray(new Comparable[rowData.size()]));
        }
        dataTable.sort(new DataTable.SortCriteria[]{new DataTable.SortCriteria(Integer.valueOf(4), DataTable.SortOrder.ASCENDING)});
        return dataTable;
    }
}

